/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.WunderLib;
import java.io.File;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_6367;
import net.minecraft.class_7923;
import net.minecraft.class_8251;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class ItemHelper {
    private ItemHelper() {
    }

    public static void renderAll(@NotNull Stream<class_1792> items, @NotNull File folder) {
        ItemHelper.renderAll(items, 8.0f, folder);
    }

    public static void renderAll(@NotNull Stream<class_1792> items, float scale, @NotNull File folder) {
        folder.mkdirs();
        items.forEach(item -> {
            class_2960 id = class_7923.field_41178.method_10221(item);
            File subFolder = new File(folder, id.method_12836());
            subFolder.mkdirs();
            class_1799 stack = new class_1799((class_1935)item);
            File file = new File(subFolder, id.method_12832() + ".png");
            ItemHelper.renderToFile(stack, scale, file);
        });
    }

    public static void renderToFile(@NotNull class_1935 item, @NotNull File file) {
        ItemHelper.renderToFile(new class_1799(item), null, 8.0f, file);
    }

    public static void renderToFile(@NotNull class_1799 stack, @NotNull File file) {
        ItemHelper.renderToFile(stack, null, 8.0f, file);
    }

    public static void renderToFile(@NotNull class_1799 stack, float scale, @NotNull File file) {
        ItemHelper.renderToFile(stack, null, scale, file);
    }

    public static void renderToFile(@NotNull class_1799 stack, @Nullable String overlayText, float scale, @NotNull File file) {
        RenderSystem.recordRenderCall(() -> {
            class_276 framebuffer = ItemHelper.createRenderContext((int)(16.0f * scale), (int)(16.0f * scale));
            ItemHelper.renderToFramebuffer(stack, overlayText, scale, framebuffer);
            ItemHelper.write(framebuffer, file);
        });
    }

    private static class_276 createRenderContext(int width, int height) {
        class_6367 framebuffer = new class_6367(width, height, true, class_310.field_1703);
        framebuffer.method_1236(1.0f, 1.0f, 1.0f, 0.0f);
        return framebuffer;
    }

    private static void renderToFramebuffer(class_1799 stack, String text, float scale, class_276 framebuffer) {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.viewport((int)0, (int)0, (int)framebuffer.field_1480, (int)framebuffer.field_1477);
        framebuffer.method_1235(true);
        class_4599 renderBuffers = minecraft.method_22940();
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)framebuffer.field_1480 / scale, (float)framebuffer.field_1477 / scale, 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        RenderSystem.disableDepthTest();
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushMatrix();
        poseStack.identity();
        poseStack.translate(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        class_4597.class_4598 bufferSource = renderBuffers.method_23000();
        class_332 guiGraphics = new class_332(minecraft, bufferSource);
        guiGraphics.method_51445(stack, 0, 0);
        if (stack.method_7947() > 1 && text == null) {
            text = String.valueOf(stack.method_7947());
        }
        if (text != null) {
            guiGraphics.method_51432(class_310.method_1551().field_1772, stack, 0, 0, text);
        }
        guiGraphics.method_51452();
        poseStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        framebuffer.method_1240();
        minecraft.method_1522().method_1235(true);
    }

    private static class_1011 takeScreenshot(class_276 renderTarget) {
        class_1011 nativeImage = new class_1011(renderTarget.field_1482, renderTarget.field_1481, false);
        RenderSystem.bindTexture((int)renderTarget.method_30277());
        nativeImage.method_4327(0, false);
        nativeImage.method_4319();
        return nativeImage;
    }

    private static void write(class_276 framebuffer, File file2) {
        class_1011 img = ItemHelper.takeScreenshot(framebuffer);
        class_156.method_27958().execute(() -> {
            try {
                img.method_4325(file2);
            }
            catch (Exception exception) {
                WunderLib.LOGGER.warn("Couldn't save screenshot", exception);
            }
            finally {
                img.close();
            }
        });
    }
}

