/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.network;

import de.ambertation.wunderlib.network.ClientBoundNetworkPayload;
import de.ambertation.wunderlib.network.NetworkPayload;
import de.ambertation.wunderlib.network.PacketHandler;
import de.ambertation.wunderlib.network.SendToClientAdapter;
import de.ambertation.wunderlib.utils.EnvHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;

public class ClientBoundPacketHandler<T extends ClientBoundNetworkPayload<T>>
extends PacketHandler<T> {
    static List<ClientBoundPacketHandler<?>> packetHandlers = new LinkedList();
    private static SendToClientAdapter sendToClientAdapter;

    @ApiStatus.Internal
    static void registerAdapter(SendToClientAdapter adapter) {
        sendToClientAdapter = adapter;
        for (ClientBoundPacketHandler<?> packetHandler : packetHandlers) {
            adapter.setupConnectionHandler(packetHandler);
        }
        packetHandlers.clear();
    }

    public ClientBoundPacketHandler(class_2960 channel, NetworkPayload.NetworkPayloadFactory<T> factory) {
        super(channel, factory);
    }

    public static <T extends ClientBoundNetworkPayload<T>> void register(ClientBoundPacketHandler<T> packetHandler) {
        PayloadTypeRegistry.playS2C().register(packetHandler.CHANNEL, packetHandler.STREAM_CODEC);
        if (sendToClientAdapter != null) {
            sendToClientAdapter.setupConnectionHandler(packetHandler);
        } else {
            packetHandlers.add(packetHandler);
        }
    }

    public static <T extends ClientBoundNetworkPayload<T>> ClientBoundPacketHandler<T> register(class_2960 channel, NetworkPayload.NetworkPayloadFactory<T> factory) {
        ClientBoundPacketHandler<T> packetHandler = new ClientBoundPacketHandler<T>(channel, factory);
        ClientBoundPacketHandler.register(packetHandler);
        return packetHandler;
    }

    public static <T extends ClientBoundNetworkPayload<T>> void sendToClient(class_3222 player, T payload) {
        if (!EnvHelper.isClient()) {
            payload.prepareOnServer(player);
            ServerPlayNetworking.send((class_3222)player, payload);
        }
    }

    public static <T extends ClientBoundNetworkPayload<T>> void sendToClient(class_3218 serverLevel, T payload) {
        if (!EnvHelper.isClient()) {
            ClientBoundPacketHandler.sendToClient(serverLevel.method_18456(), payload);
        }
    }

    public static <T extends ClientBoundNetworkPayload<T>> void sendToClient(Collection<class_3222> players, T payload) {
        if (!EnvHelper.isClient()) {
            players.forEach(player -> {
                payload.prepareOnServer((class_3222)player);
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            });
        }
    }
}

