/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import java.util.Objects;
import net.minecraft.class_2540;

public final class Quaternion {
    public static final Quaternion IDENTITY = new Quaternion(1.0, Float3.ZERO);
    public static final Quaternion ZERO = new Quaternion(0.0, Float3.ZERO);
    public static final MapCodec<Quaternion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("w").forGetter(o -> Float.valueOf((float)o.w)), (App)Codec.FLOAT.fieldOf("i").forGetter(o -> Float.valueOf((float)o.v.x)), (App)Codec.FLOAT.fieldOf("j").forGetter(o -> Float.valueOf((float)o.v.y)), (App)Codec.FLOAT.fieldOf("k").forGetter(o -> Float.valueOf((float)o.v.z))).apply((Applicative)instance, Quaternion::of));
    public final double w;
    public final Float3 v;

    public Quaternion(double real, Float3 imaginary) {
        this.w = real;
        this.v = imaginary;
    }

    public static Quaternion of(double w, double i, double j, double k) {
        return new Quaternion(w, Float3.of(i, j, k));
    }

    public static Quaternion of(double real, Float3 imaginary) {
        return new Quaternion(real, imaginary);
    }

    public static Quaternion of(Float3 imaginary) {
        return new Quaternion(0.0, imaginary);
    }

    public static Quaternion between(Float3 start, Float3 target) {
        double angle = start.angleTo(target);
        Float3 axis = start.cross(target).normalized();
        return Quaternion.ofAxisAngle(axis, angle);
    }

    public static Quaternion ofAxisAngle(Float3 normalizedAxis, double angle) {
        return new Quaternion(Math.cos(angle /= 2.0), normalizedAxis.mul(Math.sin(angle)));
    }

    public Float3 toEuler() {
        double sinr_cosp = 2.0 * (this.w * this.v.x + this.v.y * this.v.z);
        double cosr_cosp = 1.0 - 2.0 * (this.v.x * this.v.x + this.v.y * this.v.y);
        double x = Math.atan2(sinr_cosp, cosr_cosp);
        double sinp = 2.0 * (this.w * this.v.y - this.v.z * this.v.x);
        double y = Math.abs(sinp) >= 1.0 ? 1.5707963267948966 * Math.signum(sinp) : Math.asin(sinp);
        double siny_cosp = 2.0 * (this.w * this.v.z + this.v.x * this.v.y);
        double cosy_cosp = 1.0 - 2.0 * (this.v.y * this.v.y + this.v.z * this.v.z);
        double z = Math.atan2(siny_cosp, cosy_cosp);
        return Float3.of(x, y, z);
    }

    public Quaternion conjugate() {
        return new Quaternion(this.w, this.v.mul(-1.0));
    }

    public Quaternion mul(Quaternion q) {
        double w = this.w * q.w - this.v.x * q.v.x - this.v.y * q.v.y - this.v.z * q.v.z;
        double x = this.w * q.v.x + this.v.x * q.w + this.v.y * q.v.z - this.v.z * q.v.y;
        double y = this.w * q.v.y - this.v.x * q.v.z + this.v.y * q.w + this.v.z * q.v.x;
        double z = this.w * q.v.z + this.v.x * q.v.y - this.v.y * q.v.x + this.v.z * q.w;
        return new Quaternion(w, Float3.of(x, y, z));
    }

    public Quaternion mul(Float3 v) {
        return this.mul(Quaternion.of(v));
    }

    public Quaternion mul(double d) {
        return new Quaternion(this.w * d, this.v.mul(d));
    }

    public Quaternion div(double d) {
        return new Quaternion(this.w / d, this.v.div(d));
    }

    public double dot(Quaternion q) {
        return this.w * q.w + this.v.dot(q.v);
    }

    public Quaternion add(Quaternion q) {
        return new Quaternion(this.w + q.w, this.v.add(q.v));
    }

    public Quaternion sub(Quaternion q) {
        return new Quaternion(this.w - q.w, this.v.sub(q.v));
    }

    public double lengthSquare() {
        return this.w * this.w + this.v.lengthSquare();
    }

    public double length() {
        return Math.sqrt(this.lengthSquare());
    }

    public Quaternion normalized() {
        double len = this.lengthSquare();
        if (len < 1.0E-10) {
            return ZERO;
        }
        return this.div(Math.sqrt(len));
    }

    public Quaternion inverted() {
        double lenSquare = this.lengthSquare();
        if (lenSquare < 1.0E-10) {
            return ZERO;
        }
        return new Quaternion(this.w / lenSquare, this.v.div(-lenSquare));
    }

    public Float3 rotate(Float3 p) {
        return this.mul((Float3)p).mul((Quaternion)this.inverted()).v;
    }

    public Float3 unRotate(Float3 p) {
        return this.inverted().mul((Float3)p).mul((Quaternion)this).v;
    }

    public boolean isUnit() {
        return Math.abs(this.length() - 1.0) > 1.0E-10;
    }

    public boolean isImaginary() {
        return Math.abs(this.w) < 1.0E-10;
    }

    public boolean isReal() {
        return this.v.lengthSquare() < 1.0E-10;
    }

    public Matrix4 asMatrix() {
        return Matrix4.ofRotation(this.normalized());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quaternion that = (Quaternion)o;
        return Math.abs(that.w - this.w) < 1.0E-10 && this.v.equals(that.v);
    }

    public int hashCode() {
        return Objects.hash(this.w, this.v);
    }

    public String toString() {
        return "(" + Float3.toString(this.w) + " + " + Float3.toString(this.v.x) + "i + " + Float3.toString(this.v.y) + "j + " + Float3.toString(this.v.z) + "k)";
    }

    public void serializeToNetwork(class_2540 buf) {
        buf.method_52940(this.w);
        this.v.serializeToNetwork(buf);
    }

    public static Quaternion deserializeFromNetwork(class_2540 buf) {
        double w = buf.readDouble();
        Float3 v = Float3.deserializeFromNetwork(buf);
        return Quaternion.of(w, v);
    }
}

