/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.trait.IAttunementItem;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.ShardItem;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAttunedShardItem
extends ShardItem
implements IAttunementItem {
    public AbstractAttunedShardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public boolean method_7886(class_1799 itemStack) {
        Optional<Waystone> waystoneAttunedTo = this.getWaystoneAttunedTo(null, null, itemStack);
        return waystoneAttunedTo.map(Waystone::isValid).orElse(false);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> list, class_1836 flag) {
        super.method_7851(stack, context, list, flag);
        Waystone attunedWaystone = this.getWaystoneAttunedTo(null, null, stack).orElse(InvalidWaystone.INSTANCE);
        if (!attunedWaystone.isValid()) {
            class_5250 textComponent = class_2561.method_43471((String)"tooltip.waystones.attuned_shard.attunement_lost");
            textComponent.method_27692(class_124.field_1080);
            list.add((class_2561)textComponent);
            return;
        }
        if (attunedWaystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE)) {
            list.add(WarpPlateBlock.getGalacticName(attunedWaystone));
        } else {
            list.add((class_2561)attunedWaystone.getName().method_27661().method_27692(class_124.field_1076));
        }
        list.add((class_2561)class_2561.method_43471((String)"tooltip.waystones.attuned_shard.plug_into_warp_plate"));
    }

    @Override
    public Optional<Waystone> getWaystoneAttunedTo(MinecraftServer server, class_1657 player, class_1799 itemStack) {
        return Optional.ofNullable((UUID)itemStack.method_57824((class_9331)ModComponents.attunement.get())).map(attunement -> new WaystoneProxy(server, (UUID)attunement));
    }

    @Override
    public void setWaystoneAttunedTo(class_1799 itemStack, @Nullable Waystone waystone) {
        if (waystone != null) {
            itemStack.method_57379((class_9331)ModComponents.attunement.get(), (Object)waystone.getWaystoneUid());
        } else {
            itemStack.method_57381((class_9331)ModComponents.attunement.get());
        }
    }
}

