/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.illusivesoulworks.veinmining.VeinMiningConstants;
import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class BlockGroupsResourceListener
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static BlockGroupsResourceListener INSTANCE;
    private List<Set<String>> groups = new ArrayList<Set<String>>();

    public BlockGroupsResourceListener() {
        super(GSON, "veinmining");
    }

    protected void apply(@Nonnull Map<class_2960, JsonElement> object, @Nonnull class_3300 resourceManager, @Nonnull class_3695 profilerFiller) {
        LinkedHashMap sorted = new LinkedHashMap();
        resourceManager.method_29213().forEach(packResources -> {
            Set namespaces = packResources.method_14406(class_3264.field_14190);
            namespaces.forEach(namespace -> packResources.method_14408(class_3264.field_14190, namespace, "veinmining", (resourceLocation, inputStreamIoSupplier) -> {
                class_2960 rl = class_2960.method_60655((String)namespace, (String)"groups");
                JsonElement el = (JsonElement)object.get(rl);
                if (el != null) {
                    sorted.put(rl, el);
                }
            }));
        });
        ArrayList<Set<String>> blocks = new ArrayList<Set<String>>();
        for (Map.Entry entry : sorted.entrySet()) {
            class_2960 resourcelocation = (class_2960)entry.getKey();
            try {
                BlockGroupsResourceListener.fromJson(blocks, class_3518.method_15295((JsonElement)((JsonElement)entry.getValue()), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                VeinMiningConstants.LOG.error("Parsing error loading veinmining groups {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.groups = blocks;
        VeinMiningEvents.reloadDatapack();
    }

    public List<Set<String>> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    private static void fromJson(List<Set<String>> blocks, JsonObject jsonObject) throws IllegalArgumentException, JsonParseException {
        boolean replace = class_3518.method_15258((JsonObject)jsonObject, (String)"replace", (boolean)false);
        JsonArray groups = class_3518.method_15292((JsonObject)jsonObject, (String)"groups", (JsonArray)new JsonArray());
        if (replace) {
            blocks.clear();
        }
        for (JsonElement element : groups) {
            if (!element.isJsonArray()) continue;
            JsonArray jsonArray = element.getAsJsonArray();
            HashSet<String> newBlocks = new HashSet<String>();
            for (JsonElement element1 : jsonArray) {
                if (!(element1 instanceof JsonPrimitive)) continue;
                String block = element1.getAsString();
                newBlocks.add(block);
            }
            blocks.add(newBlocks);
        }
    }
}

