/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.text;

import com.daqem.uilib.client.gui.text.AbstractText;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class ScrollingText
extends AbstractText<ScrollingText> {
    private Direction direction = Direction.LEFT;
    private float speed = 0.5f;
    private int delay = 50;
    private boolean defaultCentered = false;
    private int delayCounter = 0;
    private float scrollCounter = 0.0f;
    private boolean s2sSide = false;
    private int s2sDelay = 0;

    public ScrollingText(class_327 font, class_2561 text, int x, int y) {
        super(font, text, x, y);
    }

    public ScrollingText(class_327 font, class_2561 text, int x, int y, int width, int height) {
        super(font, text, x, y, width, height);
    }

    public ScrollingText(class_327 font, class_2561 text, int x, int y, Direction direction) {
        super(font, text, x, y);
        this.direction = direction;
    }

    public ScrollingText(class_327 font, class_2561 text, int x, int y, int width, int height, Direction direction) {
        super(font, text, x, y, width, height);
        this.direction = direction;
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        int xOffset = 0;
        int yOffset = 0;
        int textWidth = this.getFont().method_27525((class_5348)this.getText());
        int spaceWidth = textWidth - this.getWidth();
        if (this.defaultCentered && textWidth < this.getWidth()) {
            xOffset = (this.getWidth() - textWidth) / 2;
        } else if (this.delayCounter < this.delay) {
            ++this.delayCounter;
        } else {
            switch (this.direction.ordinal()) {
                case 0: {
                    xOffset = (int)(-this.scrollCounter);
                    this.scrollCounter += this.speed;
                    if (this.scrollCounter >= (float)this.getFont().method_27525((class_5348)this.getText())) {
                        this.scrollCounter = -this.getWidth();
                    }
                    if (this.scrollCounter != 0.0f) break;
                    this.delayCounter = 0;
                    break;
                }
                case 1: {
                    xOffset = (int)this.scrollCounter;
                    this.scrollCounter += this.speed;
                    if (this.scrollCounter >= (float)this.getFont().method_27525((class_5348)this.getText())) {
                        this.scrollCounter = -this.getWidth();
                    }
                    if (this.scrollCounter != 0.0f) break;
                    this.delayCounter = 0;
                    break;
                }
                case 2: {
                    yOffset = (int)(-this.scrollCounter);
                    this.scrollCounter += this.speed;
                    Objects.requireNonNull(this.getFont());
                    if (this.scrollCounter >= 9.0f) {
                        this.scrollCounter = -this.getHeight();
                    }
                    if (this.scrollCounter != 0.0f) break;
                    this.delayCounter = 0;
                    break;
                }
                case 3: {
                    yOffset = (int)this.scrollCounter;
                    this.scrollCounter += this.speed;
                    Objects.requireNonNull(this.getFont());
                    if (this.scrollCounter >= 9.0f) {
                        this.scrollCounter = -this.getHeight();
                    }
                    if (this.scrollCounter != 0.0f) break;
                    this.delayCounter = 0;
                    break;
                }
                case 4: {
                    xOffset = (int)(-this.scrollCounter);
                    if (this.s2sDelay < this.delay) {
                        ++this.s2sDelay;
                        break;
                    }
                    this.scrollCounter += this.s2sSide ? -this.speed : this.speed;
                    if (!this.s2sSide && this.scrollCounter >= (float)spaceWidth) {
                        this.s2sSide = true;
                        this.s2sDelay = 0;
                        break;
                    }
                    if (!this.s2sSide || !(this.scrollCounter <= 0.0f)) break;
                    this.s2sSide = false;
                    this.s2sDelay = 0;
                }
            }
        }
        graphics.method_44379(this.getTotalX(), this.getTotalY(), this.getTotalX() + this.getWidth(), this.getTotalY() + this.getHeight());
        graphics.method_51439(this.getFont(), this.getText(), xOffset, yOffset, this.getTextColor(), this.isShadow());
        graphics.method_44380();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean isDefaultCentered() {
        return this.defaultCentered;
    }

    public void setDefaultCentered(boolean defaultCentered) {
        this.defaultCentered = defaultCentered;
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        SIDE_TO_SIDE;

    }
}

