/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.text;

import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.event.OnCharTypedEvent;
import com.daqem.uilib.api.client.gui.component.event.OnClickEvent;
import com.daqem.uilib.api.client.gui.component.event.OnDragEvent;
import com.daqem.uilib.api.client.gui.component.event.OnHoverEvent;
import com.daqem.uilib.api.client.gui.component.event.OnKeyPressedEvent;
import com.daqem.uilib.api.client.gui.component.event.OnMouseReleaseEvent;
import com.daqem.uilib.api.client.gui.component.event.OnScrollEvent;
import com.daqem.uilib.api.client.gui.text.IText;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractText<T extends AbstractText<T>>
implements IText<T> {
    private class_327 font;
    private class_2561 text;
    @Nullable
    private IComponent<?> parent;
    private int x;
    private int y;
    private int width;
    private int height;
    private int textColor;
    private boolean shadow;
    private boolean visible;
    private boolean bold;
    private boolean italic;
    private boolean underlined;
    private boolean strikethrough;
    private boolean obfuscated;
    private boolean horizontalCenter;
    private boolean verticalCenter;
    @Nullable
    private OnClickEvent<T> onClickEvent;
    @Nullable
    private OnHoverEvent<T> onHoverEvent;
    @Nullable
    private OnDragEvent<T> onDragEvent;
    @Nullable
    private OnScrollEvent<T> onScrollEvent;
    @Nullable
    private OnKeyPressedEvent<T> onKeyPressedEvent;
    @Nullable
    private OnCharTypedEvent<T> onCharTypedEvent;
    @Nullable
    private OnMouseReleaseEvent<T> onMouseReleaseEvent;
    @Nullable
    private T hoverState;

    public AbstractText(class_327 font, class_2561 text) {
        int n = font.method_27525((class_5348)text);
        Objects.requireNonNull(font);
        this(font, text, 0, 0, n, 9);
    }

    public AbstractText(class_327 font, class_2561 text, int x, int y) {
        int n = font.method_27525((class_5348)text);
        Objects.requireNonNull(font);
        this(font, text, x, y, n, 9);
    }

    public AbstractText(class_327 font, class_2561 text, int x, int y, int width, int height) {
        this.textColor = -1;
        this.visible = true;
        this.font = font;
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.hoverState = (AbstractText)this.getClone();
    }

    @Override
    public class_327 getFont() {
        return this.font;
    }

    @Override
    public class_2561 getText() {
        return this.text;
    }

    @Override
    @Nullable
    public IComponent<?> getParent() {
        return this.parent;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getTotalX() {
        if (this.getParent() != null) {
            return this.getParent().getTotalX() + this.getX();
        }
        return this.getX();
    }

    @Override
    public int getTotalY() {
        if (this.getParent() != null) {
            return this.getParent().getTotalY() + this.getY();
        }
        return this.getY();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public int getTextColor() {
        return this.textColor;
    }

    @Override
    public boolean isShadow() {
        return this.shadow;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return this.italic;
    }

    @Override
    public boolean isUnderlined() {
        return this.underlined;
    }

    @Override
    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    @Override
    public boolean isObfuscated() {
        return this.obfuscated;
    }

    @Override
    public boolean isHorizontalCenter() {
        return this.horizontalCenter;
    }

    @Override
    public boolean isVerticalCenter() {
        return this.verticalCenter;
    }

    @Override
    public void setFont(class_327 font) {
        this.font = font;
    }

    @Override
    public void setText(class_2561 text) {
        this.text = text;
    }

    @Override
    public void setParent(IComponent<?> parent) {
        this.parent = parent;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setTextColor(int color) {
        this.textColor = color;
    }

    @Override
    public void setTextColor(class_124 chatFormatting) {
        Integer color = chatFormatting.method_532();
        if (color != null) {
            this.textColor = color;
        }
    }

    @Override
    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
    }

    @Override
    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    @Override
    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
    }

    @Override
    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    @Override
    public void setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    @Override
    public void setHorizontalCenter(boolean horizontalCenter) {
        this.horizontalCenter = horizontalCenter;
    }

    @Override
    public void setVerticalCenter(boolean verticalCenter) {
        this.verticalCenter = verticalCenter;
    }

    @Override
    public void setCenter(boolean horizontalCenter, boolean verticalCenter) {
        this.horizontalCenter = horizontalCenter;
        this.verticalCenter = verticalCenter;
    }

    @Override
    public void startRenderable() {
    }

    @Override
    public void resizeScreenRepositionRenderable(int width, int height) {
    }

    @Override
    public void renderBase(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            float f;
            graphics.method_51448().method_22903();
            class_4587 class_45872 = graphics.method_51448();
            float f2 = (float)this.x + (this.isHorizontalCenter() ? (float)this.getWidth() / 2.0f - (float)this.getFont().method_27525((class_5348)this.getText()) / 2.0f : 0.0f);
            float f3 = this.y;
            if (this.isVerticalCenter()) {
                float f4 = (float)this.getHeight() / 2.0f;
                Objects.requireNonNull(this.getFont());
                f = f4 - 9.0f / 2.0f;
            } else {
                f = 0.0f;
            }
            class_45872.method_46416(f2, f3 + f, 0.0f);
            class_2583 style = this.getText().method_10866().method_36139(this.getTextColor()).method_10982(Boolean.valueOf(this.isBold())).method_10978(Boolean.valueOf(this.isItalic())).method_30938(Boolean.valueOf(this.isUnderlined())).method_36140(Boolean.valueOf(this.isStrikethrough())).method_36141(Boolean.valueOf(this.isObfuscated()));
            this.setText((class_2561)this.getText().method_27661().method_10862(style));
            this.render(graphics, mouseX, mouseY, delta);
            graphics.method_51448().method_22909();
        }
    }

    @Override
    @Nullable
    public Object getClone() {
        try {
            AbstractText clone = (AbstractText)super.clone();
            if (this.getText() != null) {
                clone.setText((class_2561)this.getText().method_27661());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public OnClickEvent<T> getOnClickEvent() {
        return this.onClickEvent;
    }

    @Override
    public void setOnClickEvent(@Nullable OnClickEvent<T> onClickEvent) {
        this.onClickEvent = onClickEvent;
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight());
    }

    @Override
    public boolean isTotalHovered(double mouseX, double mouseY) {
        return this.isHovered(mouseX, mouseY);
    }

    @Override
    @Nullable
    public OnHoverEvent<T> getOnHoverEvent() {
        return this.onHoverEvent;
    }

    @Override
    public void setOnHoverEvent(@Nullable OnHoverEvent<T> onHoverEvent) {
        this.onHoverEvent = onHoverEvent;
    }

    @Override
    public void setHoverState(@Nullable T component) {
        this.hoverState = component;
    }

    @Override
    @Nullable
    public T getHoverState() {
        return this.hoverState;
    }

    @Override
    @Nullable
    public OnDragEvent<T> getOnDragEvent() {
        return this.onDragEvent;
    }

    @Override
    public void setOnDragEvent(@Nullable OnDragEvent<T> onDragEvent) {
        this.onDragEvent = onDragEvent;
    }

    @Override
    @Nullable
    public OnScrollEvent<T> getOnScrollEvent() {
        return this.onScrollEvent;
    }

    @Override
    public void setOnScrollEvent(@Nullable OnScrollEvent<T> onScrollEvent) {
        this.onScrollEvent = onScrollEvent;
    }

    @Override
    @Nullable
    public OnKeyPressedEvent<T> getOnKeyPressedEvent() {
        return this.onKeyPressedEvent;
    }

    @Override
    public void setOnKeyPressedEvent(@Nullable OnKeyPressedEvent<T> onKeyPressedEvent) {
        this.onKeyPressedEvent = onKeyPressedEvent;
    }

    @Override
    @Nullable
    public OnCharTypedEvent<T> getOnCharTypedEvent() {
        return this.onCharTypedEvent;
    }

    @Override
    public void setOnCharTypedEvent(@Nullable OnCharTypedEvent<T> onCharTypedEvent) {
        this.onCharTypedEvent = onCharTypedEvent;
    }

    @Override
    @Nullable
    public OnMouseReleaseEvent<T> getOnMouseReleaseEvent() {
        return this.onMouseReleaseEvent;
    }

    @Override
    public void setOnMouseReleaseEvent(@Nullable OnMouseReleaseEvent<T> onMouseReleaseEvent) {
        this.onMouseReleaseEvent = onMouseReleaseEvent;
    }
}

