/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.tab;

import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.event.OnChange;
import com.daqem.uilib.api.client.gui.component.tab.ITabInformation;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.arrow.ArrowButtonComponent;
import com.daqem.uilib.client.gui.component.arrow.ArrowComponent;
import com.daqem.uilib.client.gui.component.tab.TabComponent;
import com.daqem.uilib.client.gui.texture.Textures;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_332;

public class TabsContainerComponent
extends AbstractComponent<TabsContainerComponent> {
    public static final int TAB_SPACING = 4;
    private final List<TabComponent> tabComponents;
    private final ArrowButtonComponent leftArrow;
    private final ArrowButtonComponent rightArrow;
    private final int maxTabsPerPage;
    private int page;
    private final OnChange<TabComponent> onTabChange;

    public TabsContainerComponent(int x, int y, List<? extends ITabInformation> tabInformationList, int maxTabsPerPage, OnChange<TabComponent> onTabChange) {
        super(null, x, y, Math.max(0, Math.min(maxTabsPerPage, tabInformationList.size()) * 32 - 4), 28);
        int buttonSize = 20;
        int buttonSpacing = 4;
        this.leftArrow = new ArrowButtonComponent(Textures.MINECRAFT_BUTTON, -24, 4, 20, 20, ArrowComponent.Direction.LEFT, 8, -1, 3);
        this.rightArrow = new ArrowButtonComponent(Textures.MINECRAFT_BUTTON, this.getWidth() + 4, 4, 20, 20, ArrowComponent.Direction.RIGHT, 8, -1, 3);
        this.maxTabsPerPage = maxTabsPerPage;
        this.onTabChange = onTabChange;
        this.page = 0;
        this.tabComponents = tabInformationList.stream().map(tabInformation -> {
            int index = tabInformationList.indexOf(tabInformation);
            return new TabComponent(index % maxTabsPerPage * 32, 0, (ITabInformation)tabInformation);
        }).toList();
        this.tabComponents.forEach(tabComponent -> tabComponent.setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            this.deselectAll();
            tabComponent.setSelected(true);
            this.onTabChange.onChange((TabComponent)tabComponent);
            return false;
        }));
        this.assignTabsForPage(false);
        this.addChildren(this.leftArrow, this.rightArrow);
        this.leftArrow.setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            if (this.page > 0) {
                --this.page;
                this.assignTabsForPage(true);
            }
            return false;
        });
        this.rightArrow.setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            if (this.page < tabInformationList.size() / maxTabsPerPage) {
                ++this.page;
                this.assignTabsForPage(true);
            }
            return false;
        });
    }

    private void assignTabsForPage(boolean callOnChange) {
        this.tabComponents.forEach(tabComponent -> {
            int index = this.tabComponents.indexOf(tabComponent);
            int page = index / this.maxTabsPerPage;
            if (page == this.page) {
                this.addChild((IComponent<?>)tabComponent);
            } else {
                this.removeChild((IComponent<?>)tabComponent);
            }
        });
        this.deselectAll();
        Optional<IComponent> firstTab = this.getChildren().stream().filter(child -> child instanceof TabComponent).findFirst();
        firstTab.ifPresent(tab -> ((TabComponent)tab).setSelected(true));
        if (callOnChange) {
            this.onTabChange.onChange(firstTab.orElse(null));
        }
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.leftArrow.setTexture(this.leftArrow.isTotalHovered(mouseX, mouseY) ? Textures.MINECRAFT_BUTTON_HOVERED : Textures.MINECRAFT_BUTTON);
        this.rightArrow.setTexture(this.rightArrow.isTotalHovered(mouseX, mouseY) ? Textures.MINECRAFT_BUTTON_HOVERED : Textures.MINECRAFT_BUTTON);
        if (this.page == 0 || this.page == this.tabComponents.size() / this.maxTabsPerPage) {
            if (this.page == 0) {
                this.removeChild(this.leftArrow);
                if (this.tabComponents.size() > this.maxTabsPerPage && !this.getChildren().contains(this.rightArrow)) {
                    this.addChild(this.rightArrow);
                }
            }
            if (this.page == (this.tabComponents.size() - 1) / this.maxTabsPerPage) {
                this.removeChild(this.rightArrow);
                if (this.tabComponents.size() > this.maxTabsPerPage && !this.getChildren().contains(this.leftArrow)) {
                    this.addChild(this.leftArrow);
                }
            }
        } else {
            if (!this.getChildren().contains(this.leftArrow)) {
                this.addChild(this.leftArrow);
            }
            if (!this.getChildren().contains(this.rightArrow)) {
                this.addChild(this.rightArrow);
            }
        }
    }

    public void deselectAll() {
        this.tabComponents.forEach(tabComponent -> tabComponent.setSelected(false));
    }

    public List<TabComponent> getTabComponents() {
        return this.tabComponents;
    }

    public int getMaxTabsPerPage() {
        return this.maxTabsPerPage;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }
}

