/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.scroll;

import com.daqem.uilib.api.client.gui.component.scroll.ScrollOrientation;
import com.daqem.uilib.api.client.gui.component.scroll.ScrollType;
import com.daqem.uilib.api.client.gui.texture.ITexture;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.AbstractNineSlicedComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollBarComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollContentComponent;
import java.util.Optional;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ScrollPanelComponent
extends AbstractNineSlicedComponent<ScrollPanelComponent> {
    private ScrollOrientation scrollOrientation;
    private ScrollType scrollType = ScrollType.SMOOTH;
    @Nullable
    private ScrollContentComponent scrollContentComponent;
    @Nullable
    private ScrollBarComponent scrollBarComponent;
    private double scrollSpeed = 10.0;

    public ScrollPanelComponent(ITexture texture, int x, int y, int width, int height, ScrollOrientation scrollOrientation) {
        this(texture, x, y, width, height, scrollOrientation, null, null);
    }

    public ScrollPanelComponent(ITexture texture, int x, int y, int width, int height, ScrollOrientation scrollOrientation, @Nullable ScrollContentComponent scrollContentComponent) {
        this(texture, x, y, width, height, scrollOrientation, scrollContentComponent, null);
    }

    public ScrollPanelComponent(ITexture texture, int x, int y, int width, int height, ScrollOrientation scrollOrientation, @Nullable ScrollBarComponent scrollBarComponent) {
        this(texture, x, y, width, height, scrollOrientation, null, scrollBarComponent);
    }

    public ScrollPanelComponent(ITexture texture, int x, int y, int width, int height, ScrollOrientation scrollOrientation, @Nullable ScrollContentComponent scrollContentComponent, @Nullable ScrollBarComponent scrollBarComponent) {
        super(texture, x, y, width, height);
        this.scrollOrientation = scrollOrientation;
        this.scrollContentComponent = scrollContentComponent;
        this.scrollBarComponent = scrollBarComponent;
        if (scrollContentComponent != null) {
            scrollContentComponent.setParent(this, false);
        }
        if (scrollBarComponent != null) {
            scrollBarComponent.setParent(this, false);
        }
    }

    @Override
    public void startRenderable() {
        super.startRenderable();
        this.setOnScrollEvent(this::handleScroll);
        this.getScrollBar().ifPresent(ScrollBarComponent::startRenderable);
        this.getScrollContentComponent().ifPresent(AbstractComponent::startRenderable);
    }

    private boolean handleScroll(ScrollPanelComponent scrolledObject, class_437 screen, double mouseX, double mouseY, double amountX, double amountY) {
        this.getScrollBar().ifPresent(s -> s.scroll(scrolledObject, amountX, amountY));
        this.getScrollContentComponent().ifPresent(s -> s.scroll(scrolledObject, amountX, amountY));
        return false;
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderScrollbar(graphics, mouseX, mouseY, delta);
        this.renderScrollContent(graphics, mouseX, mouseY, delta);
    }

    private void renderScrollContent(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.getScrollContentComponent().ifPresent(scrollContentComponent -> {
            graphics.method_44379(this.getTotalX(), this.getTotalY(), this.getTotalX() + this.getWidth(), this.getTotalY() + this.getHeight());
            scrollContentComponent.renderBase(graphics, mouseX, mouseY, delta);
            graphics.method_44380();
        });
    }

    private void renderScrollbar(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.getScrollBar().ifPresent(scrollBarComponent -> {
            this.setScrollWheelLength((ScrollBarComponent)scrollBarComponent);
            scrollBarComponent.renderBase(graphics, mouseX, mouseY, delta);
        });
    }

    private void setScrollWheelLength(ScrollBarComponent scrollBarComponent) {
        int contentSize = this.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.getOrientation().isHorizontal() ? scrollContentComponent.getWidth() : scrollContentComponent.getHeight()).orElse(0);
        scrollBarComponent.setScrollWheelLength(contentSize);
    }

    public int getOffScreenContentLength() {
        return this.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.getOrientation().isHorizontal() ? scrollContentComponent.getWidth() - this.getWidth() : scrollContentComponent.getHeight() - this.getHeight()).orElse(0);
    }

    public void setScrollBar(@Nullable ScrollBarComponent scrollBarComponent) {
        this.scrollBarComponent = scrollBarComponent;
        if (scrollBarComponent != null) {
            scrollBarComponent.setParent(this, false);
        }
    }

    public Optional<ScrollBarComponent> getScrollBar() {
        return Optional.ofNullable(this.scrollBarComponent);
    }

    public void removeScrollBar() {
        this.scrollBarComponent = null;
    }

    public Optional<ScrollContentComponent> getScrollContentComponent() {
        return Optional.ofNullable(this.scrollContentComponent);
    }

    public void setScrollContentComponent(@Nullable ScrollContentComponent scrollContentComponent) {
        this.scrollContentComponent = scrollContentComponent;
        if (scrollContentComponent != null) {
            scrollContentComponent.setParent(this, false);
        }
    }

    public void removeScrollContentComponent() {
        this.scrollContentComponent = null;
    }

    public ScrollOrientation getScrollOrientation() {
        return this.scrollOrientation;
    }

    public void setScrollOrientation(ScrollOrientation scrollOrientation) {
        this.scrollOrientation = scrollOrientation;
    }

    public ScrollType getScrollType() {
        return this.scrollType;
    }

    public void setScrollType(ScrollType scrollType) {
        this.scrollType = scrollType;
    }

    public double getScrollSpeed() {
        return this.scrollSpeed;
    }

    public void setScrollSpeed(double scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    @Override
    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (this.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.preformOnClickEvent(mouseX, mouseY, button)).orElse(false).booleanValue()) {
            return true;
        }
        if (this.getScrollBar().map(scrollBarComponent -> {
            if (scrollBarComponent.getScrollWheel().map(scrollWheelComponent -> scrollWheelComponent.preformOnClickEvent(mouseX, mouseY, button)).orElse(false).booleanValue()) {
                return true;
            }
            return scrollBarComponent.preformOnClickEvent(mouseX, mouseY, button);
        }).orElse(false).booleanValue()) {
            return true;
        }
        return super.preformOnClickEvent(mouseX, mouseY, button);
    }

    @Override
    public void preformOnHoverEvent(double mouseX, double mouseY, float delta) {
        this.getScrollContentComponent().ifPresent(scrollContentComponent -> scrollContentComponent.preformOnHoverEvent(mouseX, mouseY, delta));
        this.getScrollBar().ifPresent(scrollBarComponent -> {
            scrollBarComponent.preformOnHoverEvent(mouseX, mouseY, delta);
            scrollBarComponent.getScrollWheel().ifPresent(scrollWheelComponent -> scrollWheelComponent.preformOnHoverEvent(mouseX, mouseY, delta));
        });
        super.preformOnHoverEvent(mouseX, mouseY, delta);
    }

    @Override
    public boolean preformOnScrollEvent(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.preformOnScrollEvent(mouseX, mouseY, amountX, amountY)).orElse(false).booleanValue()) {
            return true;
        }
        if (this.getScrollBar().map(scrollBarComponent -> {
            if (scrollBarComponent.getScrollWheel().map(scrollWheelComponent -> scrollWheelComponent.preformOnScrollEvent(mouseX, mouseY, amountX, amountY)).orElse(false).booleanValue()) {
                return true;
            }
            return scrollBarComponent.preformOnScrollEvent(mouseX, mouseY, amountX, amountY);
        }).orElse(false).booleanValue()) {
            return true;
        }
        return super.preformOnScrollEvent(mouseX, mouseY, amountX, amountY);
    }

    @Override
    public boolean preformOnDragEvent(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY)).orElse(false).booleanValue()) {
            return true;
        }
        if (this.getScrollBar().map(scrollBarComponent -> {
            if (scrollBarComponent.getScrollWheel().map(scrollWheelComponent -> scrollWheelComponent.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY)).orElse(false).booleanValue()) {
                return true;
            }
            return scrollBarComponent.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY);
        }).orElse(false).booleanValue()) {
            return true;
        }
        return super.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean preformOnKeyPressedEvent(int keyCode, int scanCode, int modifiers) {
        if (this.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.preformOnKeyPressedEvent(keyCode, scanCode, modifiers)).orElse(false).booleanValue()) {
            return true;
        }
        if (this.getScrollBar().map(scrollBarComponent -> {
            if (scrollBarComponent.getScrollWheel().map(scrollWheelComponent -> scrollWheelComponent.preformOnKeyPressedEvent(keyCode, scanCode, modifiers)).orElse(false).booleanValue()) {
                return true;
            }
            return scrollBarComponent.preformOnKeyPressedEvent(keyCode, scanCode, modifiers);
        }).orElse(false).booleanValue()) {
            return true;
        }
        return super.preformOnKeyPressedEvent(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean preformOnCharTypedEvent(char typedChar, int modifiers) {
        if (this.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.preformOnCharTypedEvent(typedChar, modifiers)).orElse(false).booleanValue()) {
            return true;
        }
        if (this.getScrollBar().map(scrollBarComponent -> {
            if (scrollBarComponent.getScrollWheel().map(scrollWheelComponent -> scrollWheelComponent.preformOnCharTypedEvent(typedChar, modifiers)).orElse(false).booleanValue()) {
                return true;
            }
            return scrollBarComponent.preformOnCharTypedEvent(typedChar, modifiers);
        }).orElse(false).booleanValue()) {
            return true;
        }
        return super.preformOnCharTypedEvent(typedChar, modifiers);
    }

    @Override
    public boolean preformOnMouseReleaseEvent(double mouseX, double mouseY, int button) {
        if (this.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.preformOnMouseReleaseEvent(mouseX, mouseY, button)).orElse(false).booleanValue()) {
            return true;
        }
        if (this.getScrollBar().map(scrollBarComponent -> {
            if (scrollBarComponent.getScrollWheel().map(scrollWheelComponent -> scrollWheelComponent.preformOnMouseReleaseEvent(mouseX, mouseY, button)).orElse(false).booleanValue()) {
                return true;
            }
            return scrollBarComponent.preformOnMouseReleaseEvent(mouseX, mouseY, button);
        }).orElse(false).booleanValue()) {
            return true;
        }
        return super.preformOnMouseReleaseEvent(mouseX, mouseY, button);
    }

    @Override
    public void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.getScrollContentComponent().ifPresent(scrollContentComponent -> scrollContentComponent.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta));
        this.getScrollBar().ifPresent(scrollBarComponent -> {
            scrollBarComponent.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta);
            scrollBarComponent.getScrollWheel().ifPresent(scrollWheelComponent -> scrollWheelComponent.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta));
        });
        super.renderTooltips(guiGraphics, mouseX, mouseY, delta);
    }
}

