/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.scroll;

import com.daqem.uilib.api.client.gui.IRenderable;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.scroll.IScrollContent;
import com.daqem.uilib.api.client.gui.component.scroll.ScrollOrientation;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollPanelComponent;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ScrollContentComponent
extends AbstractComponent<ScrollContentComponent>
implements IScrollContent {
    private int contentSpacing;
    private ScrollOrientation orientation;
    private int previousHeight = 0;

    public ScrollContentComponent(int x, int y, int contentSpacing, ScrollOrientation orientation) {
        super(null, x, y, 0, 0);
        this.contentSpacing = contentSpacing;
        this.orientation = orientation;
    }

    @Override
    public int getHeight() {
        if (this.getOrientation().isHorizontal()) {
            return this.componentMax(IRenderable::getHeight);
        }
        return this.componentSum(IRenderable::getHeight);
    }

    @Override
    public int getWidth() {
        if (this.getOrientation().isHorizontal()) {
            return this.componentSum(IRenderable::getWidth);
        }
        return this.componentMax(IRenderable::getWidth);
    }

    @Override
    public int getContentSpacing() {
        return this.contentSpacing;
    }

    @Override
    public void setContentSpacing(int contentSpacing) {
        this.contentSpacing = contentSpacing;
    }

    @Override
    public ScrollOrientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(ScrollOrientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        List<IComponent<?>> children = this.getChildren();
        IComponent<?> previousComponent = null;
        for (IComponent<?> component : children) {
            if (this.getOrientation().isHorizontal()) {
                int offsetX = previousComponent != null ? previousComponent.getX() + previousComponent.getWidth() + this.getContentSpacing() : 0;
                component.setX(offsetX);
            } else {
                int offsetY = previousComponent != null ? previousComponent.getY() + previousComponent.getHeight() + this.getContentSpacing() : 0;
                component.setY(offsetY);
            }
            component.setZ(10);
            previousComponent = component;
        }
    }

    @Override
    public void renderTooltipsBase(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        IComponent<?> iComponent = this.getParent();
        if (iComponent instanceof ScrollPanelComponent) {
            ScrollPanelComponent scrollPanel = (ScrollPanelComponent)iComponent;
            if (scrollPanel.isTotalHovered(mouseX, mouseY)) {
                super.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta);
            }
        } else {
            super.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    private int componentSum(Function<IComponent<?>, Integer> getSize) {
        return this.getChildren().stream().mapToInt(getSize::apply).sum() + (this.getChildren().size() - 1) * this.getContentSpacing();
    }

    private int componentMax(Function<IComponent<?>, Integer> getSize) {
        return this.getChildren().stream().mapToInt(getSize::apply).max().orElse(0);
    }

    public void scroll(ScrollPanelComponent scrolledObject, double amountX, double amountY) {
        amountY = -amountY;
        boolean min = false;
        if (scrolledObject.getScrollOrientation().isHorizontal()) {
            int max = this.getWidth() - scrolledObject.getWidth();
            if (max < 0) {
                max = 0;
            }
            this.setX((int)class_3532.method_15350((double)((double)this.getX() - amountY * scrolledObject.getScrollSpeed()), (double)(-max), (double)((double)min)));
        } else {
            int max = this.getHeight() - scrolledObject.getHeight();
            if (max < 0) {
                max = 0;
            }
            this.setY((int)class_3532.method_15350((double)((double)this.getY() - amountY * scrolledObject.getScrollSpeed()), (double)(-max), (double)((double)min)));
        }
    }

    public void updateContentPositionBasedOnPercentage(ScrollPanelComponent scrollPanelComponent, double percentage) {
        boolean min = false;
        if (scrollPanelComponent.getScrollOrientation().isHorizontal()) {
            int max = this.getWidth() - scrollPanelComponent.getWidth();
            double value = (double)(this.getWidth() - scrollPanelComponent.getWidth()) * (percentage / 100.0);
            this.setX((int)class_3532.method_15350((double)(-value), (double)(-max), (double)((double)min)));
        } else {
            int max = this.getHeight() - scrollPanelComponent.getHeight();
            double value = (double)(this.getHeight() - scrollPanelComponent.getHeight()) * (percentage / 100.0);
            this.setY((int)class_3532.method_15350((double)(-value), (double)(-max), (double)((double)min)));
        }
    }

    @Override
    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (this.handleClickEvent(this.getChildren(), mouseX, mouseY, button)) {
            return true;
        }
        return super.preformOnClickEvent(mouseX, mouseY, button);
    }

    private boolean handleClickEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button) {
        for (IComponent<?> component : components) {
            if (this.handleClickEvent(component.getChildren(), mouseX, mouseY, button)) {
                return true;
            }
            if (!component.preformOnClickEvent(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void preformOnHoverEvent(double mouseX, double mouseY, float delta) {
        this.handleHoverEvent(this.getChildren(), mouseX, mouseY, delta);
        super.preformOnHoverEvent(mouseX, mouseY, delta);
    }

    private void handleHoverEvent(List<IComponent<?>> components, double mouseX, double mouseY, float delta) {
        for (IComponent<?> component : components) {
            this.handleHoverEvent(component.getChildren(), mouseX, mouseY, delta);
            component.preformOnHoverEvent(mouseX, mouseY, delta);
        }
    }

    @Override
    public boolean preformOnScrollEvent(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.handleScrollEvent(this.getChildren(), mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        return super.preformOnScrollEvent(mouseX, mouseY, amountX, amountY);
    }

    private boolean handleScrollEvent(List<IComponent<?>> components, double mouseX, double mouseY, double amountX, double amountY) {
        for (IComponent<?> component : components) {
            if (this.handleScrollEvent(component.getChildren(), mouseX, mouseY, amountX, amountY)) {
                return true;
            }
            if (!component.preformOnScrollEvent(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preformOnDragEvent(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.handleDragEvent(this.getChildren(), mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY);
    }

    private boolean handleDragEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (IComponent<?> component : components) {
            if (this.handleDragEvent(component.getChildren(), mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (!component.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preformOnKeyPressedEvent(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPressEvent(this.getChildren(), keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.preformOnKeyPressedEvent(keyCode, scanCode, modifiers);
    }

    private boolean handleKeyPressEvent(List<IComponent<?>> components, int keyCode, int scanCode, int modifiers) {
        for (IComponent<?> component : components) {
            if (this.handleKeyPressEvent(component.getChildren(), keyCode, scanCode, modifiers)) {
                return true;
            }
            if (!component.preformOnKeyPressedEvent(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preformOnCharTypedEvent(char typedChar, int modifiers) {
        if (this.handleCharTypedEvent(this.getChildren(), typedChar, modifiers)) {
            return true;
        }
        return super.preformOnCharTypedEvent(typedChar, modifiers);
    }

    private boolean handleCharTypedEvent(List<IComponent<?>> components, char typedChar, int modifiers) {
        for (IComponent<?> component : components) {
            if (this.handleCharTypedEvent(component.getChildren(), typedChar, modifiers)) {
                return true;
            }
            if (!component.preformOnCharTypedEvent(typedChar, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preformOnMouseReleaseEvent(double mouseX, double mouseY, int button) {
        if (this.handleMouseReleaseEvent(this.getChildren(), mouseX, mouseY, button)) {
            return true;
        }
        return super.preformOnMouseReleaseEvent(mouseX, mouseY, button);
    }

    private boolean handleMouseReleaseEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button) {
        for (IComponent<?> component : components) {
            if (this.handleMouseReleaseEvent(component.getChildren(), mouseX, mouseY, button)) {
                return true;
            }
            if (!component.preformOnMouseReleaseEvent(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }
}

