/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.scroll;

import com.daqem.uilib.api.client.gui.background.IBackground;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.scroll.ScrollOrientation;
import com.daqem.uilib.client.gui.background.Backgrounds;
import com.daqem.uilib.client.gui.color.ColorManipulator;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.AbstractNineSlicedComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollPanelComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollWheelComponent;
import com.daqem.uilib.client.gui.texture.Textures;
import java.util.Optional;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ScrollBarComponent
extends AbstractNineSlicedComponent<ScrollBarComponent> {
    @Nullable
    private ScrollWheelComponent scrollWheelComponent;
    @Nullable
    private IBackground<?> background;
    private ScrollOrientation orientation;
    private boolean centerBackground = true;

    public ScrollBarComponent(int x, int y, int width, int height, ScrollOrientation orientation) {
        this(x, y, width, height, orientation, new ScrollWheelComponent(Textures.SCROLL_WHEEL, 0, 0, orientation.isHorizontal() ? width : height));
    }

    public ScrollBarComponent(int x, int y, int width, int height, ScrollOrientation orientation, @Nullable ScrollWheelComponent scrollWheelComponent) {
        super(null, x, y, width, height);
        this.scrollWheelComponent = scrollWheelComponent;
        this.orientation = orientation;
        this.background = Backgrounds.getSolidScrollBarBackground(this);
        this.setZ(1);
    }

    @Override
    public void startRenderable() {
        super.startRenderable();
        this.setOnScrollEvent(this::handleScroll);
        this.setOnDragEvent(this::handleDrag);
        this.getScrollWheel().ifPresent(AbstractComponent::startRenderable);
    }

    private boolean handleScroll(ScrollBarComponent scrollBarComponent, class_437 screen, double mouseX, double mouseY, double amountX, double amountY) {
        IComponent<?> iComponent = this.getParent();
        if (iComponent instanceof ScrollPanelComponent) {
            ScrollPanelComponent parent = (ScrollPanelComponent)iComponent;
            this.scroll(parent, amountX, amountY);
            parent.getScrollContentComponent().ifPresent(s -> s.scroll(parent, amountX, amountY));
        }
        return false;
    }

    private boolean handleDrag(ScrollBarComponent scrollBarComponent, class_437 screen, double mouseX, double mouseY, int button, double dragX, double dragY) {
        IComponent<?> iComponent = this.getParent();
        if (iComponent instanceof ScrollPanelComponent) {
            ScrollPanelComponent parent = (ScrollPanelComponent)iComponent;
            this.getScrollWheel().ifPresent(scrollWheelComponent -> {
                double dragPercentage = this.getDragPercentage(mouseX, mouseY, (ScrollWheelComponent)scrollWheelComponent);
                int scrollValue = (int)((double)scrollWheelComponent.getMaxValue(parent) / 100.0 * dragPercentage);
                scrollWheelComponent.setScrollValue(scrollValue);
                this.updateScrollBarPositionBasedOnPercentage(parent);
                parent.getScrollContentComponent().ifPresent(s -> s.updateContentPositionBasedOnPercentage(parent, dragPercentage));
            });
        }
        return false;
    }

    private double getDragPercentage(double mouseX, double mouseY, ScrollWheelComponent scrollWheelComponent) {
        double offset;
        boolean isHorizontal = this.getOrientation().isHorizontal();
        int scrollWheelDimension = scrollWheelComponent.getDimension(isHorizontal);
        int scrollBarLength = this.getDimension(isHorizontal);
        double mousePosition = isHorizontal ? (mouseX -= (double)this.getTotalX()) : (mouseY -= (double)this.getTotalY());
        double newPosition = mousePosition - (offset = (double)scrollWheelDimension / 2.0);
        if (newPosition < 0.0) {
            newPosition = 0.0;
        }
        if (newPosition > (double)(scrollBarLength - scrollWheelDimension)) {
            newPosition = scrollBarLength - scrollWheelDimension;
        }
        return class_3532.method_15350((double)(newPosition / (double)(scrollBarLength - scrollWheelDimension) * 100.0), (double)0.0, (double)100.0);
    }

    private int getDimension(boolean isHorizontal) {
        return isHorizontal ? this.getWidth() : this.getHeight();
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_51448().method_22903();
        if (this.background != null) {
            if (this.centerBackground) {
                graphics.method_51448().method_46416((float)(this.getWidth() - this.background.getWidth()) / 2.0f, (float)(this.getHeight() - this.background.getHeight()) / 2.0f, (float)this.getZ());
            }
            this.background.renderBase(graphics, mouseX, mouseY, delta);
        }
        graphics.method_51448().method_22909();
        if (this.scrollWheelComponent != null) {
            this.scrollWheelComponent.renderBase(graphics, mouseX, mouseY, delta);
        }
    }

    public Optional<ScrollWheelComponent> getScrollWheel() {
        return Optional.ofNullable(this.scrollWheelComponent);
    }

    public void setScrollBar(@Nullable ScrollWheelComponent scrollWheelComponent) {
        this.scrollWheelComponent = scrollWheelComponent;
    }

    public void setBackground(@Nullable IBackground<?> background) {
        this.background = background;
    }

    @Nullable
    public IBackground<?> getBackground() {
        return this.background;
    }

    public void removeBackground() {
        this.background = null;
    }

    public ScrollOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ScrollOrientation orientation) {
        this.orientation = orientation;
    }

    public boolean isCenterBackground() {
        return this.centerBackground;
    }

    public void setCenterBackground(boolean centerBackground) {
        this.centerBackground = centerBackground;
    }

    public void scroll(ScrollPanelComponent scrolledObject, double amountX, double amountY) {
        double finalAmountY = amountY = -amountY;
        this.getScrollWheel().ifPresent(scrollWheelComponent -> {
            scrollWheelComponent.scroll(scrolledObject, amountX, finalAmountY);
            this.updateScrollBarPositionBasedOnPercentage(scrolledObject);
        });
    }

    public void updateScrollBarPositionBasedOnPercentage(ScrollPanelComponent scrolledObject) {
        this.getScrollWheel().ifPresent(scrollWheelComponent -> {
            int value = scrollWheelComponent.getScrollValue();
            int maxValue = scrollWheelComponent.getMaxValue(scrolledObject);
            if (scrolledObject.getScrollOrientation().isHorizontal()) {
                scrollWheelComponent.setX((int)((double)(this.getWidth() - scrollWheelComponent.getWidth()) * ((double)value / (double)maxValue)));
            } else {
                scrollWheelComponent.setY((int)((double)(this.getHeight() - scrollWheelComponent.getHeight()) * ((double)value / (double)maxValue)));
            }
        });
    }

    public void setScrollWheelLength(int contentLength) {
        this.getScrollWheel().ifPresent(scrollWheelComponent -> {
            boolean isHorizontal = this.getOrientation().isHorizontal();
            int totalBarDimension = isHorizontal ? this.getWidth() : this.getHeight();
            int dimension = Math.max(9, (int)((float)totalBarDimension / (float)contentLength * (float)totalBarDimension));
            if (dimension >= totalBarDimension) {
                dimension = totalBarDimension;
                scrollWheelComponent.setColorManipulator(ColorManipulator.GRAY);
            } else {
                scrollWheelComponent.setColorManipulator(ColorManipulator.WHITE);
            }
            if (isHorizontal) {
                scrollWheelComponent.setWidth(dimension);
            } else {
                scrollWheelComponent.setHeight(dimension);
            }
        });
    }
}

