/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.io;

import com.daqem.uilib.api.client.gui.component.io.IIOComponent;
import com.daqem.uilib.api.client.gui.component.io.IInputValidatable;
import com.daqem.uilib.client.gui.component.AbstractSpriteComponent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class TextBoxComponent
extends AbstractSpriteComponent<TextBoxComponent>
implements IIOComponent<TextBoxComponent>,
IInputValidatable {
    private static final LinkedList<class_2960> DEFAULT_SPRITES = new LinkedList<class_2960>(List.of(class_2960.method_60656((String)"widget/text_field"), class_2960.method_60656((String)"widget/text_field_highlighted"), class_2960.method_60655((String)"uilib", (String)"widget/text_field_error")));
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    public static final int DEFAULT_TEXT_COLOR = 0xE0E0E0;
    private static final int CURSOR_BLINK_INTERVAL_MS = 300;
    private final class_327 font;
    private String value;
    private int maxLength = 32;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private List<class_2561> validationErrors = new ArrayList<class_2561>();
    private BiFunction<String, Integer, class_5481> formatter = (string, integer) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);
    @Nullable
    private class_2561 hint;
    private long focusedTime = class_156.method_658();

    public TextBoxComponent(int x, int y, int width, int height, String value) {
        this(DEFAULT_SPRITES, x, y, width, height, value);
    }

    public TextBoxComponent(LinkedList<class_2960> sprites, int x, int y, int width, int height, String value) {
        super(sprites, x, y, width, height);
        this.value = value;
        this.font = class_310.method_1551().field_1772;
        this.setInputValidationErrors(this.validateInput(value));
    }

    public void setResponder(@Nullable Consumer<String> consumer) {
        this.responder = consumer;
    }

    public void setFormatter(BiFunction<String, Integer, class_5481> biFunction) {
        this.formatter = biFunction;
    }

    public void setValue(String string) {
        if (!this.filter.test(string)) {
            return;
        }
        this.value = string.length() > this.maxLength ? string.substring(0, this.maxLength) : string;
        this.moveCursorToEnd(false);
        this.setHighlightPos(this.cursorPos);
        this.onValueChange(string);
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> predicate) {
        this.filter = predicate;
    }

    public void insertText(String string) {
        String string3;
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k <= 0) {
            return;
        }
        String string2 = class_3544.method_57180((String)string);
        int l = string2.length();
        if (k < l) {
            if (Character.isHighSurrogate(string2.charAt(k - 1))) {
                --k;
            }
            string2 = string2.substring(0, k);
            l = k;
        }
        if (!this.filter.test(string3 = new StringBuilder(this.value).replace(i, j, string2).toString())) {
            return;
        }
        this.value = string3;
        this.setCursorPosition(i + l);
        this.setHighlightPos(this.cursorPos);
        this.onValueChange(this.value);
    }

    private void onValueChange(String string) {
        if (this.responder != null) {
            this.responder.accept(string);
        }
        this.setInputValidationErrors(this.validateInput(string));
    }

    private void deleteText(int i) {
        if (class_437.method_25441()) {
            this.deleteWords(i);
        } else {
            this.deleteChars(i);
        }
    }

    public void deleteWords(int i) {
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        this.deleteCharsToPos(this.getWordPosition(i));
    }

    public void deleteChars(int i) {
        this.deleteCharsToPos(this.getCursorPos(i));
    }

    public void deleteCharsToPos(int i) {
        int k;
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        int j = Math.min(i, this.cursorPos);
        if (j == (k = Math.max(i, this.cursorPos))) {
            return;
        }
        String string = new StringBuilder(this.value).delete(j, k).toString();
        if (!this.filter.test(string)) {
            return;
        }
        this.value = string;
        this.moveCursorTo(j, false);
    }

    public int getWordPosition(int i) {
        return this.getWordPosition(i, this.getCursorPosition());
    }

    private int getWordPosition(int i, int j) {
        return this.getWordPosition(i, j, true);
    }

    private int getWordPosition(int i, int j, boolean bl) {
        int k = j;
        boolean bl2 = i < 0;
        int l = Math.abs(i);
        for (int m = 0; m < l; ++m) {
            if (bl2) {
                while (bl && k > 0 && this.value.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.value.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int n = this.value.length();
            if ((k = this.value.indexOf(32, k)) == -1) {
                k = n;
                continue;
            }
            while (bl && k < n && this.value.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void moveCursor(int i, boolean bl) {
        this.moveCursorTo(this.getCursorPos(i), bl);
    }

    private int getCursorPos(int i) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)i);
    }

    public void moveCursorTo(int i, boolean bl) {
        this.setCursorPosition(i);
        if (!bl) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int i) {
        this.cursorPos = class_3532.method_15340((int)i, (int)0, (int)this.value.length());
        this.scrollTo(this.cursorPos);
    }

    public void moveCursorToStart(boolean bl) {
        this.moveCursorTo(0, bl);
    }

    public void moveCursorToEnd(boolean bl) {
        this.moveCursorTo(this.value.length(), bl);
    }

    @Override
    public boolean preformOnKeyPressedEvent(int keyCode, int scanCode, int modifiers) {
        if (!this.isVisible() || !this.isFocused()) {
            return false;
        }
        switch (keyCode) {
            case 263: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(-1), class_437.method_25442());
                } else {
                    this.moveCursor(-1, class_437.method_25442());
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(1), class_437.method_25442());
                } else {
                    this.moveCursor(1, class_437.method_25442());
                }
                return true;
            }
            case 259: {
                if (this.isEditable) {
                    this.deleteText(-1);
                }
                return true;
            }
            case 261: {
                if (this.isEditable) {
                    this.deleteText(1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart(class_437.method_25442());
                return true;
            }
            case 269: {
                this.moveCursorToEnd(class_437.method_25442());
                return true;
            }
        }
        if (class_437.method_25439((int)keyCode)) {
            this.moveCursorToEnd(false);
            this.setHighlightPos(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.isEditable()) {
                this.insertText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            if (this.isEditable()) {
                this.insertText("");
            }
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.isFocused() && this.isEditable();
    }

    @Override
    public boolean preformOnCharTypedEvent(char typedChar, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (class_3544.method_57175((char)typedChar)) {
            if (this.isEditable) {
                this.insertText(Character.toString(typedChar));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.isTotalHovered(mouseX, mouseY)) {
            this.setFocused(true);
            int i = class_3532.method_15357((double)mouseX) - this.getTotalX();
            if (this.bordered) {
                i -= 4;
            }
            String string = this.font.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.font.method_27523(string, i).length() + this.displayPos, class_437.method_25442());
        }
        return super.preformOnClickEvent(mouseX, mouseY, button);
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isBordered()) {
            class_2960 resourceLocation = this.hasInputValidationErrors() ? this.getSprite(2) : (this.isFocused() ? this.getSprite(1) : this.getSprite(0));
            guiGraphics.method_52706(resourceLocation, 0, 0, this.getWidth(), this.getHeight());
        }
        int k = this.isEditable ? this.textColor : this.textColorUneditable;
        int l = this.cursorPos - this.displayPos;
        String string = this.font.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
        boolean bl = l >= 0 && l <= string.length();
        boolean bl2 = this.isFocused() && (class_156.method_658() - this.focusedTime) / 300L % 2L == 0L && bl;
        int m = this.bordered ? 4 : 0;
        int n = this.bordered ? (this.getHeight() - 8) / 2 : 0;
        int o = m;
        int p = class_3532.method_15340((int)(this.highlightPos - this.displayPos), (int)0, (int)string.length());
        if (!string.isEmpty()) {
            String string2 = bl ? string.substring(0, l) : string;
            o = guiGraphics.method_35720(this.font, this.formatter.apply(string2, this.displayPos), o, n, k);
        }
        boolean bl3 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        int q = o;
        if (!bl) {
            q = l > 0 ? m + this.getWidth() : m;
        } else if (bl3) {
            --q;
            --o;
        }
        if (!string.isEmpty() && bl && l < string.length()) {
            guiGraphics.method_35720(this.font, this.formatter.apply(string.substring(l), this.cursorPos), o, n, k);
        }
        if (this.hint != null && string.isEmpty() && !this.isFocused()) {
            guiGraphics.method_27535(this.font, this.hint, o, n, k);
        }
        if (!bl3 && this.suggestion != null) {
            guiGraphics.method_25303(this.font, this.suggestion, q - 1, n, -8355712);
        }
        if (bl2) {
            if (bl3) {
                class_1921 class_19212 = class_1921.method_51785();
                Objects.requireNonNull(this.font);
                guiGraphics.method_51739(class_19212, q, n - 1, q + 1, n + 1 + 9, -3092272);
            } else {
                guiGraphics.method_25303(this.font, CURSOR_APPEND_CHARACTER, q, n, k);
            }
        }
        if (p != l) {
            int r = m + this.font.method_1727(string.substring(0, p));
            Objects.requireNonNull(this.font);
            this.renderHighlight(guiGraphics, q, n - 1, r - 1, n + 1 + 9);
        }
    }

    @Override
    public void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            this.renderInputValidationErrorsTooltip(guiGraphics, mouseX, mouseY);
        }
        super.renderTooltips(guiGraphics, mouseX, mouseY, delta);
    }

    private void renderHighlight(class_332 guiGraphics, int i, int j, int k, int l) {
        int m;
        if (i < k) {
            m = i;
            i = k;
            k = m;
        }
        if (j < l) {
            m = j;
            j = l;
            l = m;
        }
        if (k > this.getWidth()) {
            k = this.getWidth();
        }
        if (i > this.getWidth()) {
            i = this.getWidth();
        }
        guiGraphics.method_51739(class_1921.method_51786(), i, j, k, l, -16776961);
    }

    public void setMaxLength(int i) {
        this.maxLength = i;
        if (this.value.length() > i) {
            this.value = this.value.substring(0, i);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bl) {
        this.bordered = bl;
    }

    public void setTextColor(int i) {
        this.textColor = i;
    }

    public void setTextColorUneditable(int i) {
        this.textColorUneditable = i;
    }

    @Override
    public void setFocused(boolean bl) {
        if (!this.canLoseFocus && !bl) {
            return;
        }
        super.setFocused(bl);
        if (bl) {
            this.focusedTime = class_156.method_658();
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.getWidth() - 8 : this.getWidth();
    }

    public void setHighlightPos(int i) {
        this.highlightPos = class_3532.method_15340((int)i, (int)0, (int)this.value.length());
        this.scrollTo(this.highlightPos);
    }

    private void scrollTo(int i) {
        if (this.font == null) {
            return;
        }
        this.displayPos = Math.min(this.displayPos, this.value.length());
        int j = this.getInnerWidth();
        String string = this.font.method_27523(this.value.substring(this.displayPos), j);
        int k = string.length() + this.displayPos;
        if (i == this.displayPos) {
            this.displayPos -= this.font.method_27524(this.value, j, true).length();
        }
        if (i > k) {
            this.displayPos += i - k;
        } else if (i <= this.displayPos) {
            this.displayPos -= this.displayPos - i;
        }
        this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)this.value.length());
    }

    public void setCanLoseFocus(boolean bl) {
        this.canLoseFocus = bl;
    }

    public void setSuggestion(@Nullable String string) {
        this.suggestion = string;
    }

    public int getScreenX(int i) {
        if (i > this.value.length()) {
            return this.getTotalX();
        }
        return this.getTotalX() + this.font.method_1727(this.value.substring(0, i));
    }

    public void setHint(@Nullable class_2561 component) {
        this.hint = component;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public List<class_2561> getInputValidationErrors() {
        return this.validationErrors;
    }

    @Override
    public void setInputValidationErrors(List<class_2561> errors) {
        this.validationErrors = errors;
    }
}

