/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.io;

import com.daqem.uilib.api.client.gui.component.io.IIOComponent;
import com.daqem.uilib.client.gui.component.AbstractSpriteComponent;
import com.daqem.uilib.client.gui.component.io.IOComponentEntry;
import com.daqem.uilib.client.gui.text.ScrollingText;
import com.daqem.uilib.client.util.SoundManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class SliderComponent<T>
extends AbstractSpriteComponent<SliderComponent<T>>
implements IIOComponent<SliderComponent<T>> {
    private final boolean initialized;
    private double doubleValue = 0.0;
    private final List<IOComponentEntry<T>> values;
    private T value;
    private class_2561 prefix;
    private int border = 2;
    private static final LinkedList<class_2960> DEFAULT_SPRITES = new LinkedList<class_2960>(List.of(class_2960.method_60656((String)"widget/slider"), class_2960.method_60656((String)"widget/slider_handle"), class_2960.method_60656((String)"widget/slider_handle_highlighted")));

    public SliderComponent(int x, int y, int width, int height, List<IOComponentEntry<T>> values, T initialValue, class_2561 prefix) {
        this(DEFAULT_SPRITES, x, y, width, height, values, initialValue, prefix);
    }

    public SliderComponent(LinkedList<class_2960> sprites, int x, int y, int width, int height, List<IOComponentEntry<T>> values, T initialValue, class_2561 prefix) {
        super(sprites, x, y, width, height);
        this.values = values;
        this.prefix = prefix;
        this.setValue(initialValue);
        class_327 font = class_310.method_1551().field_1772;
        class_5250 class_52502 = class_2561.method_43473();
        Objects.requireNonNull(font);
        int n = (height - 9 + 1) / 2;
        Objects.requireNonNull(font);
        ScrollingText text = new ScrollingText(font, (class_2561)class_52502, this.border, n, width - this.border * 2, 9, ScrollingText.Direction.SIDE_TO_SIDE);
        text.setDefaultCentered(true);
        this.setText(text);
        this.setDoubleValue(class_3532.method_15350((double)this.doubleValue, (double)0.0, (double)1.0));
        this.initialized = true;
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        class_2960 handleSprite = this.getSprite(1);
        if (this.isTotalHovered(mouseX, mouseY) || this.isFocused()) {
            handleSprite = this.getSprite(2);
        }
        graphics.method_52706(this.getSprite(0), 0, 0, this.getWidth(), this.getHeight());
        graphics.method_52706(handleSprite, (int)(this.doubleValue * (double)(this.getWidth() - 8)), 0, 8, this.getHeight());
    }

    @Override
    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
        }
        return super.preformOnClickEvent(mouseX, mouseY, button);
    }

    @Override
    public boolean preformOnDragEvent(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
        }
        return super.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean preformOnMouseReleaseEvent(double mouseX, double mouseY, int button) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            SoundManager.playUIClick();
        }
        return super.preformOnMouseReleaseEvent(mouseX, mouseY, button);
    }

    private void setValueFromMouse(double d) {
        this.setDoubleValue((d - (double)(this.getTotalX() + 4)) / (double)(this.getWidth() - 8));
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        double oldValue = this.doubleValue;
        this.doubleValue = class_3532.method_15350((double)doubleValue, (double)0.0, (double)1.0);
        if (oldValue != this.doubleValue) {
            this.applyValue();
        }
        if (this.getText() != null) {
            this.getText().setText(this.updateMessage());
        }
        if (this.initialized) {
            this.setFocused(true);
        }
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.doubleValue = (double)this.getValueIndex() / (double)(this.values.size() - 1);
        if (this.getText() != null) {
            this.getText().setText(this.updateMessage());
        }
    }

    public IOComponentEntry<T> getEntry() {
        return this.values.stream().filter(entry -> entry.value().equals(this.value)).findFirst().orElse(null);
    }

    @Override
    public String getStringValue() {
        return this.getEntry().stringValue();
    }

    public void applyValue() {
        int size = this.values.size();
        int index = (int)Math.round(this.doubleValue * (double)(size - 1));
        this.value = this.getValueAt(index);
    }

    public int getValueIndex() {
        int index = 0;
        for (IOComponentEntry<T> t : this.values) {
            if (t.value().equals(this.value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public T getValueAt(int index) {
        return this.values.get(index).value();
    }

    public class_2561 updateMessage() {
        return !this.prefix.getString().isEmpty() ? class_2561.method_43473().method_10852(this.prefix).method_27693(": ").method_10852(this.getEntry().component()) : this.getEntry().component();
    }
}

