/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.io;

import com.daqem.uilib.api.client.gui.component.io.IIOComponent;
import com.daqem.uilib.api.client.gui.component.io.IInputValidatable;
import com.daqem.uilib.client.gui.component.io.AbstractScrollComponent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7530;

public class MultiLineTextBoxComponent
extends AbstractScrollComponent<MultiLineTextBoxComponent>
implements IIOComponent<MultiLineTextBoxComponent>,
IInputValidatable {
    protected static final LinkedList<class_2960> DEFAULT_SPRITES = new LinkedList<class_2960>(List.of(class_2960.method_60656((String)"widget/text_field"), class_2960.method_60656((String)"widget/text_field_highlighted"), class_2960.method_60655((String)"uilib", (String)"widget/text_field_error"), class_2960.method_60656((String)"widget/scroller")));
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    private static final int TEXT_COLOR = -2039584;
    private static final int CURSOR_BLINK_INTERVAL_MS = 300;
    private final class_327 font;
    private final class_7530 textField;
    private long focusedTime = class_156.method_658();
    private List<class_2561> validationErrors = new ArrayList<class_2561>();

    public MultiLineTextBoxComponent(int x, int y, int width, int height) {
        this(DEFAULT_SPRITES, x, y, width, height);
    }

    public MultiLineTextBoxComponent(LinkedList<class_2960> sprites, int x, int y, int width, int height) {
        this(sprites, x, y, width, height, "");
    }

    public MultiLineTextBoxComponent(LinkedList<class_2960> sprites, int x, int y, int width, int height, String value) {
        super(sprites, x, y, width, height);
        this.font = class_310.method_1551().field_1772;
        this.textField = new class_7530(this.font, width - this.totalInnerPadding());
        this.textField.method_44414(value);
        this.textField.method_44413(this::scrollToCursor);
        this.setInputValidationErrors(this.validateInput(value));
    }

    public void setCharacterLimit(int i) {
        this.textField.method_44411(i);
    }

    public void setValueListener(Consumer<String> consumer) {
        this.textField.method_44415(consumer);
    }

    public void setValue(String string) {
        this.textField.method_44414(string);
    }

    public String getValue() {
        return this.textField.method_44421();
    }

    @Override
    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (this.withinContentAreaPoint(mouseX, mouseY) && button == 0) {
            this.textField.method_44417(class_437.method_25442());
            this.setFocused(true);
            this.seekCursorScreen(mouseX, mouseY);
            return true;
        }
        return super.preformOnClickEvent(mouseX, mouseY, button);
    }

    @Override
    public boolean preformOnDragEvent(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.withinContentAreaPoint(mouseX, mouseY) && button == 0) {
            this.textField.method_44417(true);
            this.seekCursorScreen(mouseX, mouseY);
            this.textField.method_44417(class_437.method_25442());
            return true;
        }
        return false;
    }

    @Override
    public boolean preformOnKeyPressedEvent(int keyCode, int scanCode, int modifiers) {
        if (!this.isVisible() || !this.isFocused()) {
            return false;
        }
        return this.textField.method_44428(keyCode);
    }

    @Override
    public boolean preformOnCharTypedEvent(char typedChar, int modifiers) {
        if (!(this.isVisible() && this.isFocused() && class_3544.method_57175((char)typedChar))) {
            return false;
        }
        this.textField.method_44420(Character.toString(typedChar));
        this.setInputValidationErrors(this.validateInput(this.getValue()));
        return true;
    }

    @Override
    protected void renderContents(class_332 guiGraphics, int i, int j, float f) {
        String string = this.textField.method_44421();
        if (string.isEmpty() && !this.isFocused()) {
            return;
        }
        int k = this.textField.method_44424();
        boolean bl = this.isFocused() && (class_156.method_658() - this.focusedTime) / 300L % 2L == 0L;
        boolean bl2 = k < string.length();
        int l = 0;
        int m = 0;
        int n = this.innerPadding();
        for (class_7530.class_7531 stringView : this.textField.method_44434()) {
            Objects.requireNonNull(this.font);
            boolean bl3 = this.withinContentAreaTopBottom(n, n + 9);
            if (bl && bl2 && k >= stringView.comp_862() && k <= stringView.comp_863()) {
                if (bl3) {
                    l = guiGraphics.method_25303(this.font, string.substring(stringView.comp_862(), k), this.innerPadding(), n, -2039584) - 1;
                    Objects.requireNonNull(this.font);
                    guiGraphics.method_25294(l, n - 1, l + 1, n + 1 + 9, -3092272);
                    guiGraphics.method_25303(this.font, string.substring(k, stringView.comp_863()), l, n, -2039584);
                }
            } else {
                if (bl3) {
                    l = guiGraphics.method_25303(this.font, string.substring(stringView.comp_862(), stringView.comp_863()), this.innerPadding(), n, -2039584) - 1;
                }
                m = n;
            }
            Objects.requireNonNull(this.font);
            n += 9;
        }
        if (bl && !bl2) {
            Objects.requireNonNull(this.font);
            if (this.withinContentAreaTopBottom(m, m + 9)) {
                guiGraphics.method_25303(this.font, CURSOR_APPEND_CHARACTER, l, m, -3092272);
            }
        }
        if (this.textField.method_44435()) {
            class_7530.class_7531 stringView2 = this.textField.method_44427();
            int o = this.innerPadding();
            n = this.innerPadding();
            for (class_7530.class_7531 stringView3 : this.textField.method_44434()) {
                if (stringView2.comp_862() > stringView3.comp_863()) {
                    Objects.requireNonNull(this.font);
                    n += 9;
                    continue;
                }
                if (stringView3.comp_862() > stringView2.comp_863()) break;
                Objects.requireNonNull(this.font);
                if (this.withinContentAreaTopBottom(n, n + 9)) {
                    int p = this.font.method_1727(string.substring(stringView3.comp_862(), Math.max(stringView2.comp_862(), stringView3.comp_862())));
                    int q = stringView2.comp_863() > stringView3.comp_863() ? this.getWidth() - this.innerPadding() : this.font.method_1727(string.substring(stringView3.comp_862(), stringView2.comp_863()));
                    Objects.requireNonNull(this.font);
                    this.renderHighlight(guiGraphics, o + p, n, o + q, n + 9);
                }
                Objects.requireNonNull(this.font);
                n += 9;
            }
        }
    }

    @Override
    public void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            this.renderInputValidationErrorsTooltip(guiGraphics, mouseX, mouseY);
        }
        super.renderTooltips(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    protected void renderDecorations(class_332 guiGraphics) {
        super.renderDecorations(guiGraphics);
        if (this.textField.method_44418()) {
            int i = this.textField.method_44409();
            class_5250 component = class_2561.method_43469((String)"gui.multiLineEditBox.character_limit", (Object[])new Object[]{this.textField.method_44421().length(), i});
            guiGraphics.method_27535(this.font, (class_2561)component, this.getWidth() - this.font.method_27525((class_5348)component), this.getHeight() + this.innerPadding(), 0xA0A0A0);
        }
    }

    @Override
    protected class_2960 getBackgroundSprite() {
        return this.hasInputValidationErrors() ? this.getSprite(2) : (this.isFocused() ? this.getSprite(1) : this.getSprite(0));
    }

    @Override
    protected class_2960 getScrollWheelSprite() {
        return this.getSprite(3);
    }

    @Override
    public int getInnerHeight() {
        Objects.requireNonNull(this.font);
        return 9 * this.textField.method_44430();
    }

    @Override
    protected boolean scrollbarVisible() {
        return (double)this.textField.method_44430() > this.getDisplayableLineCount();
    }

    @Override
    protected double scrollRate() {
        Objects.requireNonNull(this.font);
        return 9.0 / 2.0;
    }

    private void renderHighlight(class_332 guiGraphics, int i, int j, int k, int l) {
        guiGraphics.method_51739(class_1921.method_51786(), i, j, k, l, -16776961);
    }

    private void scrollToCursor() {
        double d = this.scrollAmount();
        Objects.requireNonNull(this.font);
        class_7530.class_7531 stringView = this.textField.method_44422((int)(d / 9.0));
        if (this.textField.method_44424() <= stringView.comp_862()) {
            int n = this.textField.method_44432();
            Objects.requireNonNull(this.font);
            d = n * 9;
        } else {
            double d2 = d + (double)this.getHeight();
            Objects.requireNonNull(this.font);
            class_7530.class_7531 stringView2 = this.textField.method_44422((int)(d2 / 9.0) - 1);
            if (this.textField.method_44424() > stringView2.comp_863()) {
                int n = this.textField.method_44432();
                Objects.requireNonNull(this.font);
                int n2 = n * 9 - this.getHeight();
                Objects.requireNonNull(this.font);
                d = n2 + 9 + this.totalInnerPadding();
            }
        }
        this.setScrollAmount(d);
    }

    private double getDisplayableLineCount() {
        double d = this.getHeight() - this.totalInnerPadding();
        Objects.requireNonNull(this.font);
        return d / 9.0;
    }

    private void seekCursorScreen(double d, double e) {
        double f = d - (double)this.getTotalX() - (double)this.innerPadding();
        double g = e - (double)this.getTotalY() - (double)this.innerPadding() + this.scrollAmount();
        this.textField.method_44410(f, g);
    }

    @Override
    public void setFocused(boolean bl) {
        super.setFocused(bl);
        if (bl) {
            this.focusedTime = class_156.method_658();
        }
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public List<class_2561> getInputValidationErrors() {
        return this.validationErrors;
    }

    @Override
    public void setInputValidationErrors(List<class_2561> errors) {
        this.validationErrors = errors;
    }
}

