/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.io;

import com.daqem.uilib.api.client.gui.component.io.IIOComponent;
import com.daqem.uilib.client.gui.component.AbstractSpriteComponent;
import com.daqem.uilib.client.gui.component.io.IOComponentEntry;
import com.daqem.uilib.client.gui.text.ScrollingText;
import com.daqem.uilib.client.util.SoundManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class CycleButtonComponent<T>
extends AbstractSpriteComponent<CycleButtonComponent<T>>
implements IIOComponent<CycleButtonComponent<T>> {
    private static final LinkedList<class_2960> DEFAULT_SPRITES = new LinkedList<class_2960>(List.of(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted")));
    private final List<IOComponentEntry<T>> values;
    private T value;
    private class_2561 prefix;
    private boolean enabled = true;
    private int border = 2;

    public CycleButtonComponent(int x, int y, int width, int height, List<IOComponentEntry<T>> values, T initialValue, class_2561 prefix) {
        this(DEFAULT_SPRITES, x, y, width, height, values, initialValue, prefix);
    }

    public CycleButtonComponent(LinkedList<class_2960> sprites, int x, int y, int width, int height, List<IOComponentEntry<T>> values, T initialValue, class_2561 prefix) {
        super(sprites, x, y, width, height);
        this.values = values;
        this.value = initialValue;
        this.prefix = prefix;
        class_327 font = class_310.method_1551().field_1772;
        class_2561 class_25612 = this.getTextFromValue(this.value);
        Objects.requireNonNull(font);
        int n = (height - 9 + 1) / 2;
        Objects.requireNonNull(font);
        ScrollingText text = new ScrollingText(font, class_25612, this.border, n, width - this.border * 2, 9, ScrollingText.Direction.SIDE_TO_SIDE);
        text.setDefaultCentered(true);
        text.setShadow(true);
        this.setText(text);
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        class_2960 sprite = this.getSprite(0);
        if (!this.enabled) {
            sprite = this.getSprite(1);
        } else if (this.isTotalHovered(mouseX, mouseY) || this.isFocused()) {
            sprite = this.getSprite(2);
        }
        graphics.method_52706(sprite, 0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (!this.enabled) {
            return false;
        }
        boolean returnValue = false;
        if (this.isTotalHovered(mouseX, mouseY)) {
            this.cycleValue();
            this.setFocused(true);
            returnValue = true;
        }
        if (!returnValue && super.preformOnClickEvent(mouseX, mouseY, button)) {
            returnValue = true;
        }
        if (returnValue) {
            SoundManager.playUIClick();
        }
        return returnValue;
    }

    public class_2561 getTextFromValue(T value) {
        class_2561 component = this.values.stream().filter(entry -> entry.value().equals(value)).map(IOComponentEntry::component).findFirst().orElse((class_2561)class_2561.method_43473());
        return !this.prefix.getString().isEmpty() ? class_2561.method_43473().method_10852(this.prefix).method_27693(": ").method_10852(component) : component;
    }

    public void cycleValue() {
        this.setValue(this.getNextValue());
    }

    public T getNextValue() {
        int index = this.getValueIndex();
        if (index == -1) {
            return null;
        }
        int nextIndex = (index + 1) % this.values.size();
        return this.values.get(nextIndex).value();
    }

    public int getValueIndex() {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.get(i).value().equals(this.value)) continue;
            return i;
        }
        return -1;
    }

    public T getValue() {
        return this.value;
    }

    public IOComponentEntry<T> getEntry() {
        return this.values.get(this.getValueIndex());
    }

    public void setValue(T value) {
        this.value = value;
        if (this.getText() != null) {
            this.getText().setText(this.getTextFromValue(value));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public class_2561 getPrefix() {
        return this.prefix;
    }

    public void setPrefix(class_2561 prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getStringValue() {
        return this.getEntry().stringValue();
    }
}

