/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.io;

import com.daqem.uilib.api.client.gui.component.event.OnClickEvent;
import com.daqem.uilib.client.gui.component.AbstractSpriteComponent;
import com.daqem.uilib.client.gui.text.ScrollingText;
import com.daqem.uilib.client.util.SoundManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class ButtonComponent
extends AbstractSpriteComponent<ButtonComponent> {
    private static final LinkedList<class_2960> DEFAULT_SPRITES = new LinkedList<class_2960>(List.of(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted")));
    private boolean enabled = true;
    private int border = 2;

    public ButtonComponent(int x, int y, int width, int height, class_2561 component) {
        this(x, y, width, height, component, null);
    }

    public ButtonComponent(int x, int y, int width, int height, class_2561 component, OnClickEvent<ButtonComponent> onClickEvent) {
        this(DEFAULT_SPRITES, x, y, width, height, component, onClickEvent);
    }

    public ButtonComponent(LinkedList<class_2960> sprites, int x, int y, int width, int height, class_2561 component) {
        this(sprites, x, y, width, height, component, null);
    }

    public ButtonComponent(LinkedList<class_2960> sprites, int x, int y, int width, int height, class_2561 component, OnClickEvent<ButtonComponent> onClickEvent) {
        super(sprites, x, y, width, height);
        this.setOnClickEvent(onClickEvent);
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        int n = (height - 9 + 1) / 2;
        Objects.requireNonNull(font);
        ScrollingText text = new ScrollingText(font, component, this.border, n, width - this.border * 2, 9, ScrollingText.Direction.SIDE_TO_SIDE);
        text.setDefaultCentered(true);
        text.setShadow(true);
        this.setText(text);
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        class_2960 sprite = this.getSprite(0);
        if (!this.enabled) {
            sprite = this.getSprite(1);
        } else if (this.isTotalHovered(mouseX, mouseY)) {
            sprite = this.getSprite(2);
        }
        graphics.method_52706(sprite, 0, 0, this.getWidth(), this.getHeight());
        if (this.getText() != null) {
            int textColor = this.enabled ? 0xFFFFFF : 0xA0A0A0;
            this.getText().setTextColor(textColor);
        }
    }

    @Override
    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (this.enabled && super.preformOnClickEvent(mouseX, mouseY, button)) {
            SoundManager.playUIClick();
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }
}

