/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.advancement;

import com.daqem.uilib.api.client.gui.component.advancement.IAdvancementTree;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.component.advancement.AdvancementBackgroundComponent;
import com.daqem.uilib.client.gui.component.advancement.AdvancementTreeContainerComponent;
import com.daqem.uilib.client.gui.component.advancement.AdvancementWindowComponent;
import com.daqem.uilib.client.gui.component.tab.TabsContainerComponent;
import com.daqem.uilib.client.gui.text.Text;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class AdvancementsComponent
extends AbstractComponent<AdvancementsComponent> {
    private static final int WIDTH = 320;
    private static final int HEIGHT = 180;
    private static final int WINDOW_BORDER_TOP = 18;
    private static final int WINDOW_BORDER_BOTTOM = 9;
    private static final int WINDOW_BORDER_LEFT = 9;
    private static final int WINDOW_BORDER_RIGHT = 9;
    private IAdvancementTree selectedTree;
    private final AdvancementWindowComponent windowComponent;
    private final TabsContainerComponent tabsContainerComponent;
    private AdvancementBackgroundComponent backgroundComponent;
    private AdvancementTreeContainerComponent treeContainerComponent;
    private TextComponent titleComponent;
    private float backgroundFade = 0.0f;

    public AdvancementsComponent(List<IAdvancementTree> advancementTrees) {
        super(null, 0, 0, 320, 180);
        this.selectedTree = advancementTrees.get(0);
        this.refreshAdvancementTree();
        this.windowComponent = new AdvancementWindowComponent(0, 0, this.getWidth(), this.getHeight());
        this.tabsContainerComponent = new TabsContainerComponent(2, -24, advancementTrees, 10, changedObject -> {
            this.removeChild(this.backgroundComponent);
            this.removeChild(this.treeContainerComponent);
            this.selectedTree = (IAdvancementTree)changedObject.getTabInformation();
            this.refreshAdvancementTree();
        });
        this.addChildren(this.windowComponent, this.tabsContainerComponent);
    }

    public void refreshAdvancementTree() {
        this.backgroundComponent = new AdvancementBackgroundComponent(9, 18, this.getWidth() - 9 - 9, this.getHeight() - 18 - 9, this.selectedTree);
        this.treeContainerComponent = new AdvancementTreeContainerComponent(9, 18, this.getWidth() - 9 - 9, this.getHeight() - 18 - 9, this.selectedTree);
        Text title = new Text(class_310.method_1551().field_1772, this.selectedTree.getName());
        title.setTextColor(0x404040);
        this.titleComponent = new TextComponent(8, 6, title);
        this.backgroundComponent.setRenderBeforeParent(true);
        this.treeContainerComponent.setRenderBeforeParent(true);
        this.addChildren(this.backgroundComponent, this.treeContainerComponent, this.titleComponent);
        this.titleComponent.setZ(2);
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
    }

    @Override
    public void renderTooltipsBase(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.getX(), (float)this.getY(), 200.0f);
        this.backgroundFade = this.treeContainerComponent.getTreeComponent().getAllAdvancementComponents().stream().anyMatch(advancementComponent -> advancementComponent.isTotalHovered(mouseX, mouseY)) ? class_3532.method_15363((float)(this.backgroundFade + 0.04f), (float)0.0f, (float)0.25f) : class_3532.method_15363((float)(this.backgroundFade - 0.06f), (float)0.0f, (float)0.25f);
        guiGraphics.method_25294(this.backgroundComponent.getX(), this.backgroundComponent.getY(), this.backgroundComponent.getX() + this.backgroundComponent.getWidth(), this.backgroundComponent.getY() + this.backgroundComponent.getHeight(), (int)(this.backgroundFade * 255.0f) << 24);
        guiGraphics.method_51448().method_22909();
        if (this.backgroundComponent.isTotalHovered(mouseX, mouseY)) {
            super.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta);
        }
        this.tabsContainerComponent.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta);
    }
}

