/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.advancement;

import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.advancement.IAdvancement;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.advancement.AdvancementHoverComponent;
import com.daqem.uilib.client.gui.component.advancement.AdvancementIconComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_455;
import org.jetbrains.annotations.Nullable;

public class AdvancementComponent
extends AbstractComponent<AdvancementComponent> {
    public static final int SIZE = 26;
    public static final int SPACING = 2;
    @Nullable
    private final AdvancementComponent parent;
    private final AdvancementComponent previousSibling;
    private final int childIndex;
    private AdvancementComponent ancestor;
    @Nullable
    private AdvancementComponent thread;
    private final AdvancementIconComponent iconComponent;
    private final AdvancementHoverComponent hoverComponent;
    private float mod;
    private float change;
    private float shift;
    private float posX;
    private float posY;

    public AdvancementComponent(IAdvancement advancement, @Nullable AdvancementComponent parent, AdvancementComponent previousSibling, int childIndex, int x) {
        super(null, x, -1, 26, 26);
        this.parent = parent;
        this.addChildren(this.getAdvancementChildren(advancement));
        this.previousSibling = previousSibling;
        this.childIndex = childIndex;
        this.ancestor = this;
        class_455 widgetType = advancement.isObtained() ? class_455.field_2701 : class_455.field_2699;
        this.iconComponent = new AdvancementIconComponent(0, 0, advancement.getIcon(), widgetType, advancement.getFrameType());
        this.hoverComponent = new AdvancementHoverComponent(0, 0, class_310.method_1551().field_1772, advancement.getIcon(), advancement.getName(), advancement.getDescription(), widgetType, advancement.getFrameType());
        this.addChildren(this.iconComponent);
    }

    @Override
    public void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.iconComponent.isTotalHovered(mouseX, mouseY)) {
            this.hoverComponent.renderBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public AdvancementHoverComponent getHoverComponent() {
        return this.hoverComponent;
    }

    public AdvancementIconComponent getIconComponent() {
        return this.iconComponent;
    }

    private List<IComponent<?>> getAdvancementChildren(IAdvancement advancement) {
        ArrayList children = new ArrayList();
        AdvancementComponent previousSibling = null;
        for (IAdvancement child : advancement.getChildren()) {
            AdvancementComponent advancementComponent;
            previousSibling = advancementComponent = new AdvancementComponent(child, this, previousSibling, children.size(), (int)(this.posX + 1.0f));
            children.add(advancementComponent);
        }
        return children;
    }

    private List<AdvancementComponent> getAdvancementChildren() {
        return this.getChildren().stream().filter(AdvancementComponent.class::isInstance).map(AdvancementComponent.class::cast).toList();
    }

    public List<AdvancementComponent> getAllAdvancementChildren() {
        ArrayList<AdvancementComponent> advancementComponents = new ArrayList<AdvancementComponent>();
        advancementComponents.add(this);
        for (AdvancementComponent advancementComponent : this.getAdvancementChildren()) {
            advancementComponents.addAll(advancementComponent.getAllAdvancementChildren());
        }
        return advancementComponents;
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        for (AdvancementComponent advancementChild : this.getAdvancementChildren()) {
            this.drawConnectivity(graphics, 1, 0, advancementChild.getX() + 1, advancementChild.getY(), false);
        }
        for (AdvancementComponent advancementChild : this.getAdvancementChildren()) {
            this.drawConnectivity(graphics, 1, 0, advancementChild.getX() + 1, advancementChild.getY(), true);
        }
    }

    public void firstWalk() {
        if (this.getAdvancementChildren().isEmpty()) {
            this.posY = this.previousSibling != null ? this.previousSibling.posY + 1.0f : 0.0f;
        } else {
            AdvancementComponent treeNodePosition = null;
            for (AdvancementComponent treeNodePosition2 : this.getAdvancementChildren()) {
                treeNodePosition2.firstWalk();
                treeNodePosition = treeNodePosition2.apportion(treeNodePosition == null ? treeNodePosition2 : treeNodePosition);
            }
            this.executeShifts();
            float f = (this.getAdvancementChildren().get((int)0).posY + this.getAdvancementChildren().get((int)(this.getAdvancementChildren().size() - 1)).posY) / 2.0f;
            if (this.previousSibling != null) {
                this.posY = this.previousSibling.posY + 1.0f;
                this.mod = this.posY - f;
            } else {
                this.posY = f;
            }
        }
    }

    public float secondWalk(float f, int i, float g) {
        this.posY += f;
        this.posX = i;
        if (this.posY < g) {
            g = this.posY;
        }
        for (AdvancementComponent treeNodePosition : this.getAdvancementChildren()) {
            g = treeNodePosition.secondWalk(f + this.mod, i + 1, g);
        }
        return g;
    }

    public void thirdWalk(float f) {
        this.posY += f;
        for (AdvancementComponent treeNodePosition : this.getAdvancementChildren()) {
            treeNodePosition.thirdWalk(f);
        }
    }

    public void finalizePosition() {
        this.posY -= this.parent == null ? 0.0f : this.getTotalPosY() - this.posY;
        this.setX(28);
        this.setY((int)(this.posY * 28.0f));
        if (this.parent == null) {
            this.setX(this.getX() - 26 - 2);
        }
        if (!this.getAdvancementChildren().isEmpty()) {
            for (AdvancementComponent treeNodePosition : this.getAdvancementChildren()) {
                treeNodePosition.finalizePosition();
            }
        }
    }

    private float getTotalPosY() {
        return this.posY + (this.parent == null ? 0.0f : this.parent.getTotalPosY());
    }

    private void executeShifts() {
        float f = 0.0f;
        float g = 0.0f;
        for (int i = this.getAdvancementChildren().size() - 1; i >= 0; --i) {
            AdvancementComponent treeNodePosition = this.getAdvancementChildren().get(i);
            treeNodePosition.posY += f;
            treeNodePosition.mod += f;
            f += treeNodePosition.shift + (g += treeNodePosition.change);
        }
    }

    private AdvancementComponent apportion(AdvancementComponent treeNodePosition) {
        if (this.previousSibling != null && this.parent != null) {
            AdvancementComponent treeNodePosition2 = this;
            AdvancementComponent treeNodePosition3 = this;
            AdvancementComponent treeNodePosition4 = this.previousSibling;
            AdvancementComponent treeNodePosition5 = this.parent.getAdvancementChildren().get(0);
            float f = this.mod;
            float g = this.mod;
            float h = treeNodePosition4.mod;
            float i = treeNodePosition5.mod;
            while (treeNodePosition4.nextOrThread() != null && treeNodePosition2.previousOrThread() != null) {
                treeNodePosition4 = treeNodePosition4.nextOrThread();
                treeNodePosition2 = treeNodePosition2.previousOrThread();
                treeNodePosition5 = treeNodePosition5.previousOrThread();
                treeNodePosition3 = treeNodePosition3.nextOrThread();
                Objects.requireNonNull(treeNodePosition3).ancestor = this;
                float j = Objects.requireNonNull(treeNodePosition4).posY + h - (Objects.requireNonNull(treeNodePosition2).posY + f) + 1.0f;
                if (j > 0.0f) {
                    treeNodePosition4.getAncestor(this, treeNodePosition).moveSubtree(this, j);
                    f += j;
                    g += j;
                }
                h += treeNodePosition4.mod;
                f += treeNodePosition2.mod;
                i += Objects.requireNonNull(treeNodePosition5).mod;
                g += treeNodePosition3.mod;
            }
            if (treeNodePosition4.nextOrThread() != null && treeNodePosition3.nextOrThread() == null) {
                treeNodePosition3.thread = treeNodePosition4.nextOrThread();
                treeNodePosition3.mod += h - g;
            } else {
                if (treeNodePosition2.previousOrThread() != null && treeNodePosition5.previousOrThread() == null) {
                    treeNodePosition5.thread = treeNodePosition2.previousOrThread();
                    treeNodePosition5.mod += f - i;
                }
                treeNodePosition = this;
            }
        }
        return treeNodePosition;
    }

    @Nullable
    private AdvancementComponent previousOrThread() {
        if (this.thread != null) {
            return this.thread;
        }
        return !this.getAdvancementChildren().isEmpty() ? this.getAdvancementChildren().get(0) : null;
    }

    @Nullable
    private AdvancementComponent nextOrThread() {
        if (this.thread != null) {
            return this.thread;
        }
        return !this.getAdvancementChildren().isEmpty() ? this.getAdvancementChildren().get(this.getAdvancementChildren().size() - 1) : null;
    }

    private AdvancementComponent getAncestor(AdvancementComponent treeNodePosition, AdvancementComponent treeNodePosition2) {
        return this.ancestor != null && Objects.requireNonNull(treeNodePosition.parent).getAdvancementChildren().contains(this.ancestor) ? this.ancestor : treeNodePosition2;
    }

    private void moveSubtree(AdvancementComponent treeNodePosition, float f) {
        float g = treeNodePosition.childIndex - this.childIndex;
        if (g != 0.0f) {
            treeNodePosition.change -= f / g;
            this.change += f / g;
        }
        treeNodePosition.shift += f;
        treeNodePosition.posY += f;
        treeNodePosition.mod += f;
    }

    private void drawConnectivity(class_332 guiGraphics, int xFrom, int yFrom, int xTo, int yTo, boolean isWhite) {
        int color;
        int spacing = 2;
        int centerHeight = 12;
        int xOffset = 24;
        int xFromOffset = xFrom + xOffset;
        int xToOffset = xTo - 2;
        int yFromCenter = yFrom + centerHeight;
        int yToCenter = yTo + centerHeight;
        int n = color = isWhite ? -1 : -16777216;
        if (isWhite) {
            guiGraphics.method_25292(xFromOffset, xFromOffset + spacing, yFromCenter, color);
            guiGraphics.method_25301(xFromOffset + spacing, yFromCenter, yToCenter, color);
            guiGraphics.method_25292(xToOffset, xToOffset + spacing, yToCenter, color);
        } else {
            guiGraphics.method_25292(xFromOffset, xToOffset + 1, yFromCenter - 1, color);
            guiGraphics.method_25292(xFromOffset, xToOffset + 1, yFromCenter, color);
            guiGraphics.method_25292(xFromOffset, xToOffset + 1, yFromCenter + 1, color);
            guiGraphics.method_25301(xToOffset - 1, yToCenter, yFromCenter, color);
            guiGraphics.method_25301(xToOffset + 1, yToCenter, yFromCenter, color);
            guiGraphics.method_25292(xToOffset - 1, xToOffset + spacing, yToCenter - 1, color);
            guiGraphics.method_25292(xToOffset - 1, xToOffset + spacing, yToCenter, color);
            guiGraphics.method_25292(xToOffset - 1, xToOffset + spacing, yToCenter + 1, color);
        }
    }
}

