/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.background;

import com.daqem.uilib.api.client.gui.background.IBackground;
import com.daqem.uilib.api.client.gui.color.IColorManipulator;
import com.daqem.uilib.api.client.gui.component.event.OnCharTypedEvent;
import com.daqem.uilib.api.client.gui.component.event.OnClickEvent;
import com.daqem.uilib.api.client.gui.component.event.OnDragEvent;
import com.daqem.uilib.api.client.gui.component.event.OnHoverEvent;
import com.daqem.uilib.api.client.gui.component.event.OnKeyPressedEvent;
import com.daqem.uilib.api.client.gui.component.event.OnMouseReleaseEvent;
import com.daqem.uilib.api.client.gui.component.event.OnScrollEvent;
import com.daqem.uilib.client.gui.color.ColorManipulator;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBackground<T extends AbstractBackground<T>>
implements IBackground<T> {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean visible = true;
    private IColorManipulator colorManipulator = new ColorManipulator();
    @Nullable
    private OnClickEvent<T> onClickEvent;
    @Nullable
    private OnHoverEvent<T> onHoverEvent;
    @Nullable
    private OnDragEvent<T> onDragEvent;
    @Nullable
    private OnScrollEvent<T> onScrollEvent;
    @Nullable
    private OnKeyPressedEvent<T> onKeyPressedEvent;
    @Nullable
    private OnCharTypedEvent<T> onCharTypedEvent;
    @Nullable
    private OnMouseReleaseEvent<T> onMouseReleaseEvent;
    @Nullable
    private T hoverState;

    public AbstractBackground(int width, int height) {
        this(0, 0, width, height);
    }

    public AbstractBackground(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.hoverState = (AbstractBackground)this.getClone();
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getTotalX() {
        return this.getX();
    }

    @Override
    public int getTotalY() {
        return this.getY();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public IColorManipulator getColorManipulator() {
        return this.colorManipulator;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setColorManipulator(IColorManipulator colorManipulator) {
        this.colorManipulator = colorManipulator;
    }

    @Override
    public void startRenderable() {
    }

    @Override
    public void resizeScreenRepositionRenderable(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void renderBase(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.getX(), (float)this.getY(), -1.0f);
        guiGraphics.method_51422(this.colorManipulator.getRed(), this.colorManipulator.getGreen(), this.colorManipulator.getBlue(), this.colorManipulator.getOpacity());
        this.render(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.method_51448().method_22909();
    }

    @Override
    @Nullable
    public Object getClone() {
        try {
            AbstractBackground clone = (AbstractBackground)this.clone();
            clone.setColorManipulator((IColorManipulator)this.getColorManipulator().getClone());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public OnClickEvent<T> getOnClickEvent() {
        return this.onClickEvent;
    }

    @Override
    public void setOnClickEvent(@Nullable OnClickEvent<T> onClickEvent) {
        this.onClickEvent = onClickEvent;
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight());
    }

    @Override
    public boolean isTotalHovered(double mouseX, double mouseY) {
        return this.isHovered(mouseX, mouseY);
    }

    @Override
    @Nullable
    public OnHoverEvent<T> getOnHoverEvent() {
        return this.onHoverEvent;
    }

    @Override
    public void setOnHoverEvent(@Nullable OnHoverEvent<T> onHoverEvent) {
        this.onHoverEvent = onHoverEvent;
    }

    @Override
    public void setHoverState(@Nullable T hoverState) {
        this.hoverState = hoverState;
    }

    @Override
    @Nullable
    public T getHoverState() {
        return this.hoverState;
    }

    @Override
    @Nullable
    public OnDragEvent<T> getOnDragEvent() {
        return this.onDragEvent;
    }

    @Override
    public void setOnDragEvent(@Nullable OnDragEvent<T> onDragEvent) {
        this.onDragEvent = onDragEvent;
    }

    @Override
    @Nullable
    public OnScrollEvent<T> getOnScrollEvent() {
        return this.onScrollEvent;
    }

    @Override
    public void setOnScrollEvent(@Nullable OnScrollEvent<T> onScrollEvent) {
        this.onScrollEvent = onScrollEvent;
    }

    @Override
    @Nullable
    public OnKeyPressedEvent<T> getOnKeyPressedEvent() {
        return this.onKeyPressedEvent;
    }

    @Override
    public void setOnKeyPressedEvent(@Nullable OnKeyPressedEvent<T> onKeyPressedEvent) {
        this.onKeyPressedEvent = onKeyPressedEvent;
    }

    @Override
    @Nullable
    public OnCharTypedEvent<T> getOnCharTypedEvent() {
        return this.onCharTypedEvent;
    }

    @Override
    public void setOnCharTypedEvent(@Nullable OnCharTypedEvent<T> onCharTypedEvent) {
        this.onCharTypedEvent = onCharTypedEvent;
    }

    @Override
    @Nullable
    public OnMouseReleaseEvent<T> getOnMouseReleaseEvent() {
        return this.onMouseReleaseEvent;
    }

    @Override
    public void setOnMouseReleaseEvent(@Nullable OnMouseReleaseEvent<T> onMouseReleaseEvent) {
        this.onMouseReleaseEvent = onMouseReleaseEvent;
    }
}

