/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui;

import com.daqem.uilib.api.client.gui.IRenderable;
import com.daqem.uilib.api.client.gui.IScreen;
import com.daqem.uilib.api.client.gui.IScreenAccessor;
import com.daqem.uilib.api.client.gui.background.IBackground;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.client.gui.background.Backgrounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends class_437
implements IScreen {
    private final List<IComponent<?>> components = new ArrayList();
    @Nullable
    private IComponent<?> focusedComponent;
    @Nullable
    private IBackground<?> background = Backgrounds.getDefaultBackground(this.getWidth(), this.getHeight());
    private boolean isPauseScreen = false;

    protected AbstractScreen(class_2561 title) {
        super(title);
    }

    protected AbstractScreen(String title) {
        super((class_2561)class_2561.method_43470((String)title));
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.getAccessor().uilib$isInitialized()) {
            this.startScreen();
            if (this.getBackground() != null) {
                this.getBackground().startRenderable();
            }
            this.getComponents().forEach(IRenderable::startRenderable);
        } else {
            this.onResizeScreenRepositionComponents(this.field_22789, this.field_22790);
            if (this.getBackground() != null) {
                this.getBackground().resizeScreenRepositionRenderable(this.field_22789, this.field_22790);
            }
            this.getComponents().forEach(component -> component.resizeScreenRepositionRenderable(this.field_22789, this.field_22790));
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.checkHovering(mouseX, mouseY, delta);
        this.method_25420(guiGraphics, mouseX, mouseY, delta);
        this.renderComponents(guiGraphics, mouseX, mouseY, delta);
        this.onTickScreen(guiGraphics, mouseX, mouseY, delta);
        for (class_4068 renderable : this.getAccessor().uilib$getRenderables()) {
            renderable.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        this.renderTooltips(guiGraphics, mouseX, mouseY, delta);
    }

    private void checkHovering(int mouseX, int mouseY, float delta) {
        this.handleHoverEvent(this.components, mouseX, mouseY, delta);
    }

    private void handleHoverEvent(List<IComponent<?>> components, int mouseX, int mouseY, float delta) {
        for (IComponent<?> component : components) {
            this.handleHoverEvent(component.getChildren(), mouseX, mouseY, delta);
            component.preformOnHoverEvent(mouseX, mouseY, delta);
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.background != null) {
            this.background.renderBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void renderComponents(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        for (IComponent<?> component : new ArrayList(this.components)) {
            component.renderBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        for (IComponent<?> component : new ArrayList(this.components)) {
            component.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public int getWidth() {
        return this.field_22789;
    }

    @Override
    public int getHeight() {
        return this.field_22790;
    }

    @Override
    public class_327 getFont() {
        return this.field_22793;
    }

    @Override
    public List<IComponent<?>> getComponents() {
        return this.components;
    }

    @Override
    @Nullable
    public IComponent<?> getFocusedComponent() {
        return this.focusedComponent;
    }

    @Override
    public void setFocusedComponent(@Nullable IComponent<?> focusedComponent) {
        this.focusedComponent = focusedComponent;
    }

    @Override
    public void addComponent(IComponent<?> component) {
        this.components.add(component);
    }

    @Override
    public void addComponents(IComponent<?> ... components) {
        this.components.addAll(List.of(components));
    }

    @Override
    public void removeComponent(IComponent<?> component) {
        this.components.remove(component);
    }

    @Override
    @Nullable
    public IBackground<?> getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(@Nullable IBackground<?> background) {
        this.background = background;
    }

    @Override
    public void onResizeScreenRepositionComponents(int width, int height) {
        this.repositionComponents(this.components, width, height);
    }

    private void repositionComponents(List<IComponent<?>> components, int width, int height) {
        for (IComponent<?> component : new ArrayList(components)) {
            AbstractScreen.centerComponent(width, height, component);
            this.repositionComponents(component.getChildren(), width - component.getX(), height - component.getY());
        }
    }

    private static void centerComponent(int width, int height, IComponent<?> component) {
        if (component.isCenteredHorizontally()) {
            component.setX(width / 2 - component.getWidth() / 2);
        }
        if (component.isCenteredVertically()) {
            component.setY(height / 2 - component.getHeight() / 2);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.handleClickEvent(this.components, mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private boolean handleClickEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button) {
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleClickEvent(component.getChildren(), mouseX, mouseY, button)) {
                return true;
            }
            if (!component.preformOnClickEvent(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.handleDragEvent(this.components, mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    private boolean handleDragEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleDragEvent(component.getChildren(), mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (!component.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.handleScrollEvent(this.components, mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    private boolean handleScrollEvent(List<IComponent<?>> components, double mouseX, double mouseY, double amountX, double amountY) {
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleScrollEvent(component.getChildren(), mouseX, mouseY, amountX, amountY)) {
                return true;
            }
            if (!component.preformOnScrollEvent(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPressedEvent(this.components, keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean handleKeyPressedEvent(List<IComponent<?>> components, int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleKeyPressedEvent(component.getChildren(), keyCode, scanCode, modifiers)) {
                handled = true;
                break;
            }
            if (!component.preformOnKeyPressedEvent(keyCode, scanCode, modifiers)) continue;
            handled = true;
            break;
        }
        return handled;
    }

    public boolean method_25400(char c, int i) {
        if (this.handleCharEvent(this.components, c, i)) {
            return true;
        }
        return super.method_25400(c, i);
    }

    private boolean handleCharEvent(List<IComponent<?>> components, char c, int i) {
        boolean handled = false;
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleCharEvent(component.getChildren(), c, i)) {
                handled = true;
                break;
            }
            if (!component.preformOnCharTypedEvent(c, i)) continue;
            handled = true;
            break;
        }
        return handled;
    }

    public boolean method_25406(double d, double e, int i) {
        if (this.handleMouseReleaseEvent(this.components, d, e, i)) {
            return true;
        }
        return super.method_25406(d, e, i);
    }

    private boolean handleMouseReleaseEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button) {
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleMouseReleaseEvent(component.getChildren(), mouseX, mouseY, button)) {
                return true;
            }
            if (!component.preformOnMouseReleaseEvent(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25421() {
        return this.isPauseScreen;
    }

    @Override
    public void setPauseScreen(boolean pauseScreen) {
        this.isPauseScreen = pauseScreen;
    }

    @Override
    public IScreenAccessor getAccessor() {
        return (IScreenAccessor)((Object)this);
    }
}

