/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client.gui.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.api.ISimpleGuiContainerLayout;
import net.blay09.mods.trashslot.api.SlotRenderStyle;
import net.blay09.mods.trashslot.api.Snap;
import net.minecraft.class_465;
import net.minecraft.class_768;

public class SimpleGuiContainerLayout
implements IGuiContainerLayout,
ISimpleGuiContainerLayout {
    public static final IGuiContainerLayout DEFAULT = (IGuiContainerLayout)((Object)new SimpleGuiContainerLayout().enableDefaultCollision().enableDefaultSnaps());
    public static final IGuiContainerLayout DEFAULT_ENABLED = (IGuiContainerLayout)((Object)new SimpleGuiContainerLayout().enableDefaultCollision().enableDefaultSnaps().setEnabledByDefault());
    private final List<class_768> collisionAreas = new ArrayList<class_768>();
    private final List<Snap> snaps = new ArrayList<Snap>();
    private boolean defaultCollision;
    private boolean defaultSnaps;
    private boolean enabledByDefault;

    @Override
    public ISimpleGuiContainerLayout addCollisionArea(int x, int y, int width, int height) {
        this.collisionAreas.add(new class_768(x, y, width, height));
        return this;
    }

    @Override
    public ISimpleGuiContainerLayout addVerticalSnap(int x) {
        this.snaps.add(new Snap(Snap.Type.VERTICAL, x, 0));
        return this;
    }

    @Override
    public ISimpleGuiContainerLayout addHorizontalSnap(int y) {
        this.snaps.add(new Snap(Snap.Type.HORIZONTAL, 0, y));
        return this;
    }

    @Override
    public ISimpleGuiContainerLayout addSnappingPoint(int x, int y) {
        this.snaps.add(new Snap(Snap.Type.FIXED, x, y));
        return this;
    }

    @Override
    public ISimpleGuiContainerLayout enableDefaultCollision() {
        this.defaultCollision = true;
        return this;
    }

    @Override
    public ISimpleGuiContainerLayout enableDefaultSnaps() {
        this.defaultSnaps = true;
        return this;
    }

    @Override
    public ISimpleGuiContainerLayout setEnabledByDefault() {
        this.enabledByDefault = true;
        return this;
    }

    @Override
    public List<class_768> getCollisionAreas(class_465<?> screen) {
        if (!this.defaultCollision) {
            return this.collisionAreas;
        }
        ArrayList list = Lists.newArrayList(this.collisionAreas);
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
        list.add(new class_768(screenAccessor.getLeftPos(), screenAccessor.getTopPos(), screenAccessor.getImageWidth(), screenAccessor.getImageHeight()));
        return list;
    }

    @Override
    public List<Snap> getSnaps(class_465<?> screen, SlotRenderStyle renderStyle) {
        if (!this.defaultSnaps) {
            return this.snaps;
        }
        ArrayList list = Lists.newArrayList(this.snaps);
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
        list.add(new Snap(Snap.Type.HORIZONTAL, 0, screenAccessor.getTopPos()));
        list.add(new Snap(Snap.Type.HORIZONTAL, 0, screenAccessor.getTopPos() + screenAccessor.getImageHeight() - renderStyle.getHeight()));
        list.add(new Snap(Snap.Type.VERTICAL, screenAccessor.getLeftPos(), 0));
        list.add(new Snap(Snap.Type.VERTICAL, screenAccessor.getLeftPos() + screenAccessor.getImageWidth() - renderStyle.getWidth(), 0));
        return list;
    }

    @Override
    public SlotRenderStyle getSlotRenderStyle(class_465<?> screen, int slotX, int slotY) {
        int slotBottom;
        int slotRight;
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
        if (slotY == screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
            slotRight = slotX + SlotRenderStyle.LONE.getWidth();
            if (slotX == screenAccessor.getLeftPos()) {
                return SlotRenderStyle.ATTACH_BOTTOM_LEFT;
            }
            if (slotRight == screenAccessor.getLeftPos() + screenAccessor.getImageWidth()) {
                return SlotRenderStyle.ATTACH_BOTTOM_RIGHT;
            }
            if (slotX >= screenAccessor.getLeftPos() && slotRight < screenAccessor.getLeftPos() + screenAccessor.getImageWidth()) {
                return SlotRenderStyle.ATTACH_BOTTOM_CENTER;
            }
        }
        if (slotY + SlotRenderStyle.LONE.getHeight() == screenAccessor.getTopPos()) {
            slotRight = slotX + SlotRenderStyle.LONE.getWidth();
            if (slotX == screenAccessor.getLeftPos()) {
                return SlotRenderStyle.ATTACH_TOP_LEFT;
            }
            if (slotRight == screenAccessor.getLeftPos() + screenAccessor.getImageWidth()) {
                return SlotRenderStyle.ATTACH_TOP_RIGHT;
            }
            if (slotX >= screenAccessor.getLeftPos() && slotRight < screenAccessor.getLeftPos() + screenAccessor.getImageWidth()) {
                return SlotRenderStyle.ATTACH_TOP_CENTER;
            }
        }
        if (slotX + SlotRenderStyle.LONE.getWidth() == screenAccessor.getLeftPos()) {
            slotBottom = slotY + SlotRenderStyle.LONE.getHeight();
            if (slotY == screenAccessor.getTopPos()) {
                return SlotRenderStyle.ATTACH_LEFT_TOP;
            }
            if (slotBottom == screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
                return SlotRenderStyle.ATTACH_LEFT_BOTTOM;
            }
            if (slotY >= screenAccessor.getTopPos() && slotBottom < screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
                return SlotRenderStyle.ATTACH_LEFT_CENTER;
            }
        }
        if (slotX == screenAccessor.getLeftPos() + screenAccessor.getImageWidth()) {
            slotBottom = slotY + SlotRenderStyle.LONE.getHeight();
            if (slotY == screenAccessor.getTopPos()) {
                return SlotRenderStyle.ATTACH_RIGHT_TOP;
            }
            if (slotBottom == screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
                return SlotRenderStyle.ATTACH_RIGHT_BOTTOM;
            }
            if (slotY >= screenAccessor.getTopPos() && slotBottom < screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
                return SlotRenderStyle.ATTACH_RIGHT_CENTER;
            }
        }
        return SlotRenderStyle.LONE;
    }

    @Override
    public int getDefaultSlotX(class_465<?> screen) {
        return ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2 - SlotRenderStyle.LONE.getWidth();
    }

    @Override
    public int getDefaultSlotY(class_465<?> screen) {
        return ((AbstractContainerScreenAccessor)screen).getImageHeight() / 2;
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    @Override
    public int getSlotOffsetX(class_465<?> screen, SlotRenderStyle renderStyle) {
        return 0;
    }

    @Override
    public int getSlotOffsetY(class_465<?> screen, SlotRenderStyle renderStyle) {
        return 0;
    }
}

