/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client.gui;

import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.SlotAccessor;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.api.SlotRenderStyle;
import net.blay09.mods.trashslot.api.Snap;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.TrashSlotGuiHandler;
import net.blay09.mods.trashslot.client.TrashSlotSlot;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.config.TrashSlotConfig;
import net.minecraft.class_1735;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_768;

public class TrashSlotComponent {
    private static final class_2960 texture = class_2960.method_60655((String)"trashslot", (String)"textures/gui/slot.png");
    private static final int SNAP_SIZE = 7;
    private final class_465<?> screen;
    private final IGuiContainerLayout layout;
    private final ContainerSettings settings;
    private final TrashSlotSlot trashSlot;
    private SlotRenderStyle renderStyle = SlotRenderStyle.LONE;
    private boolean wasMouseDown;
    private boolean isDragging;
    private int dragStartX;
    private int dragStartY;

    public TrashSlotComponent(class_465<?> screen, IGuiContainerLayout layout, ContainerSettings settings, TrashSlotSlot trashSlot) {
        this.screen = screen;
        this.layout = layout;
        this.settings = settings;
        this.trashSlot = trashSlot;
    }

    public boolean isInside(int mouseX, int mouseY) {
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle);
        return mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.renderStyle.getRenderWidth() && mouseY < renderY + this.renderStyle.getRenderHeight();
    }

    public void update(int mouseX, int mouseY) {
        boolean isMouseOver;
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle);
        boolean bl = isMouseOver = mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.renderStyle.getRenderWidth() && mouseY < renderY + this.renderStyle.getRenderHeight();
        if (TrashSlotGuiHandler.isLeftMouseDown()) {
            if (!(this.isDragging || !isMouseOver || this.wasMouseDown || this.settings.isLocked() || !class_310.method_1551().field_1724.field_7512.method_34255().method_7960() || this.trashSlot.method_7681() && ((AbstractContainerScreenAccessor)this.screen).callIsHovering((class_1735)this.trashSlot, (double)mouseX, (double)mouseY))) {
                this.dragStartX = renderX - mouseX;
                this.dragStartY = renderY - mouseY;
                this.isDragging = true;
            }
            this.wasMouseDown = true;
        } else {
            if (this.isDragging) {
                TrashSlotSaveState.save();
                this.isDragging = false;
            }
            this.wasMouseDown = false;
        }
        if (this.isDragging) {
            int targetX = mouseX + this.dragStartX;
            int targetY = mouseY + this.dragStartY;
            for (class_768 collisionArea : this.layout.getCollisionAreas(this.screen)) {
                int targetRight = targetX + this.renderStyle.getWidth();
                int targetBottom = targetY + this.renderStyle.getHeight();
                int rectRight = collisionArea.method_3321() + collisionArea.method_3319();
                int rectBottom = collisionArea.method_3322() + collisionArea.method_3320();
                if (targetRight < collisionArea.method_3321() || targetX >= rectRight || targetBottom < collisionArea.method_3322() || targetY >= rectBottom) continue;
                int distLeft = targetRight - collisionArea.method_3321();
                int distRight = rectRight - targetX;
                int distTop = targetBottom - collisionArea.method_3322();
                int distBottom = rectBottom - targetY;
                if (anchoredX >= collisionArea.method_3321() && anchoredX < collisionArea.method_3321() + collisionArea.method_3319()) {
                    targetY = distTop < distBottom ? collisionArea.method_3322() - this.renderStyle.getHeight() : collisionArea.method_3322() + collisionArea.method_3320();
                    continue;
                }
                targetX = distLeft < distRight ? collisionArea.method_3321() - this.renderStyle.getWidth() : collisionArea.method_3321() + collisionArea.method_3319();
            }
            if (!class_437.method_25442()) {
                int bestSnapDist = Integer.MAX_VALUE;
                Snap bestSnap = null;
                for (Snap snap : this.layout.getSnaps(this.screen, this.renderStyle)) {
                    int dist = Integer.MAX_VALUE;
                    switch (snap.getType()) {
                        case HORIZONTAL: {
                            dist = Math.abs(snap.getY() - targetY);
                            break;
                        }
                        case VERTICAL: {
                            dist = Math.abs(snap.getX() - targetX);
                            break;
                        }
                        case FIXED: {
                            int distX = snap.getX() - targetX;
                            int distY = snap.getY() - targetY;
                            dist = (int)Math.sqrt(distX * distX + distY * distY);
                        }
                    }
                    if (dist >= 7 || dist >= bestSnapDist) continue;
                    bestSnap = snap;
                    bestSnapDist = dist;
                }
                if (bestSnap != null) {
                    if (bestSnap.getType() == Snap.Type.VERTICAL || bestSnap.getType() == Snap.Type.FIXED) {
                        targetX = bestSnap.getX();
                    }
                    if (bestSnap.getType() == Snap.Type.HORIZONTAL || bestSnap.getType() == Snap.Type.FIXED) {
                        targetY = bestSnap.getY();
                    }
                }
            }
            targetX = class_3532.method_15340((int)targetX, (int)0, (int)(this.screen.field_22789 - this.renderStyle.getRenderWidth()));
            targetY = class_3532.method_15340((int)targetY, (int)0, (int)(this.screen.field_22790 - this.renderStyle.getRenderHeight()));
            this.settings.setSlotX(this.getUnanchoredX(targetX));
            this.settings.setSlotY(this.getUnanchoredY(targetY));
        }
    }

    public void drawBackground(class_332 guiGraphics) {
        int renderX = this.getAnchoredX();
        int renderY = this.getAnchoredY();
        this.renderStyle = this.layout.getSlotRenderStyle(this.screen, renderX, renderY);
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)this.screen;
        ((SlotAccessor)this.trashSlot).setX(renderX - screenAccessor.getLeftPos() + this.renderStyle.getSlotOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle));
        ((SlotAccessor)this.trashSlot).setY(renderY - screenAccessor.getTopPos() + this.renderStyle.getSlotOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle));
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 1.0f);
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        renderX += this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle);
        renderY += this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle);
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        int texOffsetX = 0;
        if (deletionProvider == null || !deletionProvider.canUndeleteLast()) {
            texOffsetX = 64;
        }
        switch (this.renderStyle) {
            case LONE: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX, 56, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                break;
            }
            case ATTACH_BOTTOM_CENTER: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 50, 29, 4, 4);
                guiGraphics.method_25302(texture, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 54, 29, 4, 4);
                break;
            }
            case ATTACH_BOTTOM_LEFT: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 54, 29, 4, 4);
                break;
            }
            case ATTACH_BOTTOM_RIGHT: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 50, 29, 4, 4);
                break;
            }
            case ATTACH_TOP_CENTER: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 25, 4, 4);
                guiGraphics.method_25302(texture, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 25, 4, 4);
                break;
            }
            case ATTACH_TOP_LEFT: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 25, 4, 4);
                break;
            }
            case ATTACH_TOP_RIGHT: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 25, 4, 4);
                break;
            }
            case ATTACH_LEFT_CENTER: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 50, 33, 4, 4);
                guiGraphics.method_25302(texture, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 37, 4, 4);
                break;
            }
            case ATTACH_LEFT_TOP: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 37, 4, 4);
                break;
            }
            case ATTACH_LEFT_BOTTOM: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 50, 33, 4, 4);
                break;
            }
            case ATTACH_RIGHT_CENTER: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 54, 33, 4, 4);
                guiGraphics.method_25302(texture, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 37, 4, 4);
                break;
            }
            case ATTACH_RIGHT_TOP: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 37, 4, 4);
                break;
            }
            case ATTACH_RIGHT_BOTTOM: {
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                guiGraphics.method_25302(texture, renderX, renderY, texOffsetX + 54, 33, 4, 4);
            }
        }
        poseStack.method_22909();
    }

    private int getAnchoredX() {
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)this.screen;
        return class_3532.method_15340((int)(this.settings.getSlotX() + screenAccessor.getLeftPos() + (int)((float)screenAccessor.getImageWidth() * this.settings.getAnchorX())), (int)0, (int)(this.screen.field_22789 - this.renderStyle.getRenderWidth()));
    }

    private int getUnanchoredX(int x) {
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)this.screen;
        return x - screenAccessor.getLeftPos() - (int)((float)screenAccessor.getImageWidth() * this.settings.getAnchorX());
    }

    private int getAnchoredY() {
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)this.screen;
        return class_3532.method_15340((int)(this.settings.getSlotY() + screenAccessor.getTopPos() + (int)((float)screenAccessor.getImageHeight() * this.settings.getAnchorY())), (int)0, (int)(this.screen.field_22789 - this.renderStyle.getRenderWidth()));
    }

    private int getUnanchoredY(int y) {
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)this.screen;
        return y - screenAccessor.getTopPos() - (int)((float)screenAccessor.getImageHeight() * this.settings.getAnchorY());
    }

    public boolean isVisible() {
        return this.settings.isEnabled();
    }

    public class_768 getRectangle() {
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle);
        return new class_768(renderX, renderY, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
    }
}

