/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.compression;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryPartHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import net.p3pp3rf1y.sophisticatedcore.util.TriPredicate;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import org.apache.commons.lang3.function.TriFunction;

public class CompressionInventoryPart
implements IInventoryPartHandler {
    public static final String NAME = "compression";
    public static final Pair<class_2960, class_2960> EMPTY_COMPRESSION_SLOT = new Pair((Object)class_1723.field_21668, (Object)SophisticatedStorage.getRL("item/empty_compression_slot"));
    private final InventoryHandler parent;
    private final SlotRange slotRange;
    private final Supplier<MemorySettingsCategory> getMemorySettings;
    private final Runnable recipeChangeListener = () -> this.calculateStacks(false);
    private Map<Integer, SlotDefinition> slotDefinitions = new HashMap<Integer, SlotDefinition>();
    private final Map<Integer, class_1799> calculatedStacks = new HashMap<Integer, class_1799>();

    public CompressionInventoryPart(InventoryHandler parent, SlotRange slotRange, Supplier<MemorySettingsCategory> getMemorySettings) {
        this.parent = parent;
        this.slotRange = slotRange;
        this.getMemorySettings = getMemorySettings;
        RecipeHelper.addRecipeChangeListener((Runnable)this.recipeChangeListener);
    }

    public void onInit() {
        this.calculateStacks(true);
    }

    private void calculateStacks(boolean initial) {
        this.clearCollections();
        Map<Integer, class_1799> existingStacks = this.getExistingStacks();
        if (existingStacks.isEmpty()) {
            return;
        }
        int lastNonEmptySlot = this.getLastNonEmptySlot(existingStacks);
        this.setSlotDefinitions(this.getSlotDefinitions(existingStacks.get(lastNonEmptySlot), lastNonEmptySlot, existingStacks), initial);
        this.compactInternalSlots();
        this.updateCalculatedStacks();
    }

    private void setSlotDefinitions(Map<Integer, SlotDefinition> definitions, boolean initial) {
        this.slotDefinitions = definitions;
        if (initial) {
            this.parent.initFilterItems();
        } else {
            this.parent.onFilterItemsChanged();
            this.slotDefinitions.forEach((slot, definition) -> this.parent.triggerOnChangeListeners(slot.intValue()));
        }
    }

    private Integer getLastNonEmptySlot(Map<Integer, class_1799> existingStacks) {
        for (int slot = this.slotRange.firstSlot() + this.slotRange.numberOfSlots() - 1; slot >= this.slotRange.firstSlot(); --slot) {
            if (!existingStacks.containsKey(slot)) continue;
            return slot;
        }
        return -1;
    }

    private Map<Integer, SlotDefinition> getSlotDefinitions(class_1799 firstItem, int lastSlot, Map<Integer, class_1799> existingStacks) {
        HashMap<Integer, SlotDefinition> ret = new HashMap<Integer, SlotDefinition>();
        this.addPreviousItems(ret, lastSlot, firstItem);
        class_1799 prevItem = firstItem;
        for (int slot = lastSlot; slot >= this.slotRange.firstSlot(); --slot) {
            if (existingStacks.containsKey(slot) && !class_1799.method_31577((class_1799)existingStacks.get(slot), (class_1799)prevItem)) {
                ret.clear();
                break;
            }
            Optional<RecipeHelper.CompactingShape> compressionShape = this.getCompressionShape(prevItem);
            if (!compressionShape.isPresent()) {
                ret.put(slot, new SlotDefinition(prevItem, 1, true));
                break;
            }
            RecipeHelper.CompactingShape shape = compressionShape.get();
            ret.put(slot, new SlotDefinition(prevItem, shape.getNumberOfIngredients(), true));
            prevItem = RecipeHelper.getCompactingResult((class_1799)prevItem, (RecipeHelper.CompactingShape)shape).getResult();
        }
        this.updateSlotLimits(ret);
        this.updateInaccessibleAndCompressible(ret, existingStacks);
        return ret;
    }

    private void updateSlotLimits(Map<Integer, SlotDefinition> definitions) {
        int totalLimit = 0;
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            if (!definitions.containsKey(slot) || !definitions.get(slot).isAccessible()) continue;
            totalLimit = MathHelper.intMaxCappedAddition((int)this.parent.getBaseStackLimit(definitions.get((Object)Integer.valueOf((int)slot)).item), (int)MathHelper.intMaxCappedMultiply((int)definitions.get((Object)Integer.valueOf((int)slot)).prevSlotMultiplier, (int)totalLimit));
            definitions.get(slot).setSlotLimit(totalLimit);
        }
    }

    private void updateCalculatedStacks() {
        int totalCalculated = 0;
        boolean prevFull = false;
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            if (!slotDefinition.isAccessible()) continue;
            if (!slotDefinition.isCompressible()) {
                this.calculatedStacks.put(slot, this.parent.getSlotStack(slot).method_7972());
                continue;
            }
            int internalCount = this.parent.getSlotStack(slot).method_7947();
            totalCalculated = Integer.MAX_VALUE / slotDefinition.prevSlotMultiplier() < totalCalculated ? Integer.MAX_VALUE : totalCalculated * slotDefinition.prevSlotMultiplier();
            totalCalculated = Integer.MAX_VALUE - internalCount < totalCalculated ? Integer.MAX_VALUE : totalCalculated + internalCount;
            class_1799 calculatedStack = slotDefinition.item().method_46651(totalCalculated);
            int internalLimit = this.parent.getBaseStackLimit(calculatedStack);
            int maxStackSize = calculatedStack.method_7914();
            if (Integer.MAX_VALUE - totalCalculated < maxStackSize) {
                calculatedStack.method_7939(Integer.MAX_VALUE - (prevFull ? Math.min(maxStackSize, internalLimit - internalCount) : maxStackSize));
            }
            this.calculatedStacks.put(slot, calculatedStack);
            prevFull = internalLimit <= internalCount;
        }
    }

    private void compactInternalSlots() {
        HashMap<Integer, Integer> toUpdate = new HashMap<Integer, Integer>();
        for (int slot = this.slotRange.firstSlot() + 1; slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            int prevStackCount;
            class_1799 slotStack = this.parent.getSlotStack(slot);
            int multiplier = this.getPrevSlotMultiplier(slot);
            if (slotStack.method_7960() || multiplier < 2) continue;
            int prevSlot = slot - 1;
            class_1799 prevStack = this.parent.getSlotStack(prevSlot);
            int stackLimit = this.parent.getBaseStackLimit(prevStack);
            int availableSpace = stackLimit - (prevStackCount = toUpdate.containsKey(prevSlot) ? ((Integer)toUpdate.get(prevSlot)).intValue() : prevStack.method_7947());
            int countToInsert = Math.min(availableSpace, slotStack.method_7947() / multiplier);
            if (countToInsert <= 0) continue;
            toUpdate.put(prevSlot, prevStackCount + countToInsert);
            toUpdate.put(slot, slotStack.method_7947() - countToInsert * multiplier);
        }
        this.updateInternalStacksWithCounts(toUpdate);
    }

    private void updateInaccessibleAndCompressible(Map<Integer, SlotDefinition> definitions, Map<Integer, class_1799> existingStacks) {
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            definitions.computeIfAbsent(slot, s -> {
                if (existingStacks.containsKey(s)) {
                    return new SlotDefinition((class_1799)existingStacks.get(s), 1, true);
                }
                return SlotDefinition.inaccesible();
            });
            if (!definitions.get(slot).isAccessible()) continue;
            boolean uncompressibledFromNext = definitions.containsKey(slot - 1) && definitions.get(slot - 1).isAccessible() && definitions.get(slot).prevSlotMultiplier() > 1;
            boolean compressibleFromPrevious = definitions.containsKey(slot + 1) && definitions.get(slot + 1).isAccessible() && definitions.get(slot + 1).prevSlotMultiplier() > 1;
            definitions.get(slot).setCompressible(uncompressibledFromNext || compressibleFromPrevious);
        }
    }

    private void clearCollections() {
        this.slotDefinitions.clear();
        this.calculatedStacks.clear();
        this.parent.onFilterItemsChanged();
    }

    private Optional<RecipeHelper.CompactingShape> getCompressionShape(class_1799 stack) {
        Set compactingShapes = RecipeHelper.getItemCompactingShapes((class_1799)stack);
        if (compactingShapes.contains(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE)) {
            return Optional.of(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE);
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE)) {
            return Optional.of(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE);
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.THREE_BY_THREE)) {
            class_1792 compressedItem = RecipeHelper.getCompactingResult((class_1799)stack, (RecipeHelper.CompactingShape)RecipeHelper.CompactingShape.THREE_BY_THREE).getResult().method_7909();
            return this.getDecompressionResultFromConfig(compressedItem).isPresent() ? Optional.of(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) : Optional.empty();
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            class_1792 compressedItem = RecipeHelper.getCompactingResult((class_1799)stack, (RecipeHelper.CompactingShape)RecipeHelper.CompactingShape.TWO_BY_TWO).getResult().method_7909();
            return this.getDecompressionResultFromConfig(compressedItem).isPresent() ? Optional.of(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) : Optional.empty();
        }
        return Optional.empty();
    }

    private void addPreviousItems(Map<Integer, SlotDefinition> slotDefinitions, int firstFilledSlot, class_1799 firstFilledItem) {
        class_1799 currentItem = firstFilledItem;
        for (int slot = firstFilledSlot + 1; slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            RecipeHelper.UncompactingResult uncompactingResult = RecipeHelper.getUncompactingResult((class_1799)currentItem);
            if (uncompactingResult.getCompactUsingShape() == RecipeHelper.CompactingShape.NONE) {
                Optional<RecipeHelper.UncompactingResult> decompressionResult = this.getDecompressionResultFromConfig(currentItem.method_7909());
                if (decompressionResult.isEmpty()) break;
                uncompactingResult = decompressionResult.get();
            }
            slotDefinitions.put(slot, new SlotDefinition(uncompactingResult.getResult(), uncompactingResult.getCompactUsingShape() == RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE ? 4 : 9, true));
            currentItem = uncompactingResult.getResult();
        }
    }

    Optional<RecipeHelper.UncompactingResult> getDecompressionResultFromConfig(class_1792 currentItem) {
        return Config.SERVER.compressionUpgrade.getDecompressionResult(currentItem);
    }

    private Map<Integer, class_1799> getExistingStacks() {
        LinkedHashMap<Integer, class_1799> existingStacks = new LinkedHashMap<Integer, class_1799>();
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            class_1799 slotStack = this.parent.getSlotStack(slot);
            if (slotStack.method_7960()) continue;
            existingStacks.put(slot, slotStack);
        }
        if (existingStacks.isEmpty()) {
            MemorySettingsCategory memorySettings = this.getMemorySettings.get();
            for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
                int finalSlot = slot;
                memorySettings.getSlotFilterStack(slot, true).ifPresent(stack -> existingStacks.put(finalSlot, (class_1799)stack));
            }
        }
        return existingStacks;
    }

    public int getSlotLimit(int slot) {
        return this.slotDefinitions.containsKey(slot) ? this.slotDefinitions.get(slot).slotLimit() : this.parent.getBaseSlotLimit();
    }

    public int getStackLimit(int slot, class_1799 stack) {
        if (!this.slotDefinitions.containsKey(slot)) {
            return this.parent.getBaseStackLimit(stack);
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return this.getStackLimit(slotDefinition);
    }

    private int getStackLimit(SlotDefinition slotDefinition) {
        if (!slotDefinition.isAccessible()) {
            return 0;
        }
        return slotDefinition.slotLimit();
    }

    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate, s -> s.method_7960() ? 64 : s.method_7914());
    }

    private class_1799 extractItem(int slot, int amount, boolean simulate, ToIntFunction<class_1799> getLimit) {
        if (!this.slotDefinitions.containsKey(slot) || !this.slotDefinitions.get(slot).isAccessible()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(this.calculatedStacks.get(slot).method_7947(), amount);
        if (toExtract > 0) {
            class_1799 result;
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            class_1799 slotStack = this.parent.getSlotStack(slot);
            toExtract = Math.min(toExtract, getLimit.applyAsInt(slotStack));
            class_1799 class_17992 = result = slotDefinition.isCompressible() ? slotDefinition.item().method_46651(toExtract) : slotStack.method_46651(toExtract);
            if (!simulate) {
                if (slotDefinition.isCompressible()) {
                    this.extractFromCalculated(slot, toExtract);
                    this.extractFromInternal(slot, toExtract);
                } else {
                    slotStack.method_7934(toExtract);
                    this.calculatedStacks.put(slot, slotStack.method_7972());
                    this.parent.setSlotStack(slot, slotStack);
                }
                this.removeDefinitionsIfEmpty(slot);
            }
            return result;
        }
        return class_1799.field_8037;
    }

    private void removeDefinitionsIfEmpty(int slotTriggeringChange) {
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            if (this.parent.getSlotStack(slot).method_7960() && !this.getMemorySettings.get().getSlotFilterStack(slot, false).isPresent()) continue;
            return;
        }
        this.clearCollections();
        this.parent.triggerOnChangeListeners(slotTriggeringChange);
    }

    private void extractFromInternal(int slotToStartFrom, int amountToExtract) {
        HashMap<Integer, Integer> toUpdate = new HashMap<Integer, Integer>();
        int decompressedAmountToInsert = 0;
        int totalMultiplier = 1;
        while (amountToExtract > 0) {
            class_1799 slotStack = this.parent.getSlotStack(slotToStartFrom);
            if (totalMultiplier == 1) {
                int toRemove = Math.min(amountToExtract, slotStack.method_7947());
                toUpdate.put(slotToStartFrom, slotStack.method_7947() - toRemove);
                amountToExtract -= toRemove;
            } else {
                int ceiledAmount = (int)Math.ceil((double)amountToExtract / (double)totalMultiplier);
                int toRemove = Math.min(ceiledAmount, slotStack.method_7947());
                toUpdate.put(slotToStartFrom, slotStack.method_7947() - toRemove);
                int totalToRemove = toRemove * totalMultiplier;
                if (totalToRemove > amountToExtract) {
                    decompressedAmountToInsert = totalToRemove - amountToExtract;
                    break;
                }
                amountToExtract -= totalToRemove;
            }
            totalMultiplier *= this.getPrevSlotMultiplier(slotToStartFrom);
            --slotToStartFrom;
        }
        while (decompressedAmountToInsert > 0) {
            int toInsert;
            if ((toInsert = decompressedAmountToInsert / (totalMultiplier /= this.getPrevSlotMultiplier(++slotToStartFrom))) <= 0) continue;
            toUpdate.put(slotToStartFrom, toUpdate.getOrDefault(slotToStartFrom, 0) + toInsert);
            decompressedAmountToInsert -= toInsert * totalMultiplier;
        }
        this.updateInternalStacksWithCounts(toUpdate);
    }

    private int getPrevSlotMultiplier(int slot) {
        return this.slotDefinitions.get((Object)Integer.valueOf((int)slot)).prevSlotMultiplier;
    }

    private void updateInternalStacksWithCounts(Map<Integer, Integer> toUpdate) {
        toUpdate.forEach((s, count) -> {
            class_1799 slotStack = this.parent.getSlotStack(s.intValue());
            if (slotStack.method_7947() != count.intValue()) {
                if (count == 0) {
                    this.parent.setSlotStack(s.intValue(), class_1799.field_8037);
                } else if (slotStack.method_7960()) {
                    this.parent.setSlotStack(s.intValue(), this.slotDefinitions.get(s).item().method_46651(count.intValue()));
                } else {
                    slotStack.method_7939(count.intValue());
                    this.parent.setSlotStack(s.intValue(), slotStack);
                }
            }
        });
    }

    private void extractFromCalculated(int slot, int extractCount) {
        this.extractFromCalculatedThisAndPreviousStacks(extractCount, slot);
        this.extractFromCalculatedThisAndStacksAfter(extractCount, slot + 1);
    }

    private void extractFromCalculatedThisAndPreviousStacks(int extractCount, int slotCalculated) {
        int countBeforeChange = -1;
        int multiplier = 1;
        while (extractCount != 0 && this.calculatedStacks.containsKey(slotCalculated)) {
            class_1799 calculatedStack = this.calculatedStacks.get(slotCalculated);
            if (countBeforeChange > 0 && countBeforeChange / multiplier > calculatedStack.method_7947() && (extractCount = calculatedStack.method_7947() - (countBeforeChange - extractCount * multiplier) / multiplier) <= 0) break;
            countBeforeChange = calculatedStack.method_7947();
            int toSet = this.getCountChangeLeavingSpaceBeforeMaxInt(countBeforeChange - extractCount, slotCalculated, calculatedStack);
            calculatedStack.method_7939(toSet);
            this.calculatedStacks.put(slotCalculated, calculatedStack);
            multiplier = this.getPrevSlotMultiplier(slotCalculated);
            extractCount = countBeforeChange / multiplier - calculatedStack.method_7947() / multiplier;
            --slotCalculated;
        }
    }

    private int getCountChangeLeavingSpaceBeforeMaxInt(int countCalculated, int slotCalculated, class_1799 calculatedStack) {
        boolean hasPrevious;
        int toSet = countCalculated;
        int prevSlot = slotCalculated - 1;
        SlotDefinition prevSlotDefinition = this.slotDefinitions.get(prevSlot);
        boolean bl = hasPrevious = prevSlotDefinition != null && prevSlotDefinition.isAccessible();
        if (countCalculated > 0 && Integer.MAX_VALUE - countCalculated < calculatedStack.method_7914() && hasPrevious) {
            boolean prevSlotFull = this.getSlotLimit(prevSlot) == this.calculatedStacks.get(prevSlot).method_7947();
            int buffer = prevSlotFull ? this.getStackLimit(slotCalculated, calculatedStack) - countCalculated : calculatedStack.method_7914();
            toSet = Integer.MAX_VALUE - buffer;
        }
        return toSet;
    }

    private void extractFromCalculatedThisAndStacksAfter(int extractCount, int slot) {
        while (slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots() && this.slotDefinitions.get(slot).isAccessible()) {
            class_1799 calculatedStack = this.calculatedStacks.get(slot);
            int multiplier = this.getPrevSlotMultiplier(slot);
            int countSet = calculatedStack.method_7947() - (extractCount *= multiplier);
            countSet = this.getCountChangeLeavingSpaceBeforeMaxInt(countSet, slot, calculatedStack);
            calculatedStack.method_7939(countSet);
            this.calculatedStacks.put(slot, calculatedStack);
            ++slot;
        }
    }

    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate, TriFunction<Integer, class_1799, Boolean, class_1799> insertSuper) {
        return this.insertItem(slot, stack, simulate);
    }

    private class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        if (this.canNotBeInserted(slot, stack)) {
            return stack;
        }
        Map<Integer, SlotDefinition> definitions = this.slotDefinitions;
        if (definitions.isEmpty()) {
            definitions = this.getSlotDefinitions(stack, slot, Map.of());
        }
        int limit = this.getStackLimit(definitions.get(slot));
        int currentCalculatedCount = this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot).method_7947() : 0;
        int inserted = Math.min(Math.max(this.parent.getBaseStackLimit(stack) - this.parent.getSlotStack(slot).method_7947(), limit - currentCalculatedCount), stack.method_7947());
        if (inserted == 0) {
            return stack;
        }
        class_1799 result = stack.method_46651(stack.method_7947() - inserted);
        if (simulate) {
            return result;
        }
        if (!this.slotDefinitions.containsKey(slot)) {
            this.setSlotDefinitions(definitions, false);
            this.compactInternalSlots();
            this.updateCalculatedStacks();
        }
        if (this.slotDefinitions.get(slot).isCompressible()) {
            this.insertIntoInternalAndCalculated(slot, inserted);
        } else if (inserted > 0) {
            this.calculatedStacks.compute(slot, (s, st) -> {
                if (st == null || st.method_7960()) {
                    class_1799 copy = stack.method_7972();
                    copy.method_7939(inserted);
                    return copy;
                }
                st.method_7933(inserted);
                return st;
            });
            class_1799 slotStack = this.parent.getSlotStack(slot);
            if (slotStack.method_7960()) {
                class_1799 copy = stack.method_7972();
                copy.method_7939(inserted);
                this.parent.setSlotStack(slot, copy);
            } else {
                slotStack.method_7933(inserted);
                this.parent.setSlotStack(slot, slotStack);
            }
        }
        return result;
    }

    private boolean canNotBeInserted(int slot, class_1799 stack) {
        if (stack.method_7960()) {
            return true;
        }
        if (!this.slotDefinitions.containsKey(slot)) {
            return false;
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return !slotDefinition.isAccessible() || !class_1799.method_31577((class_1799)slotDefinition.item(), (class_1799)stack);
    }

    private void insertIntoInternalAndCalculated(int slotToStartFrom, long amountToInsert) {
        LinkedHashMap<Integer, Integer> toUpdate = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> calculatedAdditions = new LinkedHashMap<Integer, Integer>();
        int totalMultiplier = 1;
        int slot = slotToStartFrom;
        long amountToSet = amountToInsert + (long)this.parent.getSlotStack(slot).method_7947();
        while (amountToSet / ((long)totalMultiplier * (long)this.getPrevSlotMultiplier(slot)) > 0L && this.slotDefinitions.containsKey(slot - 1) && this.slotDefinitions.get(slot - 1).isAccessible()) {
            amountToSet += (long)this.parent.getSlotStack(--slot).method_7947() * (long)(totalMultiplier *= this.getPrevSlotMultiplier(slot));
        }
        long calculatedAddition = 0L;
        while (slot <= slotToStartFrom) {
            calculatedAddition *= (long)this.getPrevSlotMultiplier(slot);
            class_1799 slotStack = this.parent.getSlotStack(slot);
            int toSet = (int)Math.min(amountToSet / (long)totalMultiplier, (long)this.parent.getBaseStackLimit(slotStack));
            calculatedAdditions.put(slot, (int)Math.min(calculatedAddition += (long)(toSet - slotStack.method_7947()), Integer.MAX_VALUE));
            if (toSet > 0) {
                toUpdate.put(slot, toSet);
                amountToSet -= (long)toSet * (long)totalMultiplier;
            } else {
                toUpdate.put(slot, 0);
            }
            if (amountToSet != 0L) {
                if (!this.slotDefinitions.containsKey(slot + 1)) {
                    SophisticatedStorage.LOGGER.error("Compression inventory is in an invalid state. Slot {} is compressible, there's stack remaining to insert but slot {} is not defined.\nSlot Definitions\n{}", new Object[]{slot, slot + 1, this.slotDefinitions});
                    break;
                }
                totalMultiplier /= this.getPrevSlotMultiplier(slot + 1);
            }
            ++slot;
        }
        while (slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots() && this.slotDefinitions.containsKey(slot)) {
            calculatedAdditions.put(slot, (int)Math.min(calculatedAddition *= (long)this.getPrevSlotMultiplier(slot), Integer.MAX_VALUE));
            ++slot;
        }
        this.updateInternalStacksWithCounts(toUpdate);
        calculatedAdditions.forEach(this::addToCalculatedStack);
        toUpdate.keySet().forEach(arg_0 -> ((InventoryHandler)this.parent).triggerOnChangeListeners(arg_0));
    }

    private void addToCalculatedStack(int slot, int countToAdd) {
        if (!this.calculatedStacks.containsKey(slot) || this.calculatedStacks.get(slot).method_7960()) {
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            this.calculatedStacks.put(slot, slotDefinition.item().method_46651(countToAdd));
            return;
        }
        class_1799 currentCalculated = this.calculatedStacks.get(slot);
        int totalCalculated = Integer.MAX_VALUE - countToAdd < currentCalculated.method_7947() ? Integer.MAX_VALUE : currentCalculated.method_7947() + countToAdd;
        int previousSlot = slot - 1;
        if (totalCalculated != Integer.MAX_VALUE || !this.slotDefinitions.containsKey(previousSlot)) {
            currentCalculated.method_7939(totalCalculated);
            return;
        }
        class_1799 previousInternalStack = this.parent.getSlotStack(previousSlot);
        boolean isPreviousFull = previousInternalStack.method_7947() >= this.parent.getBaseStackLimit(previousInternalStack);
        int internalLimit = this.parent.getBaseStackLimit(currentCalculated);
        int internalCount = this.parent.getSlotStack(slot).method_7947();
        int maxStackSize = previousInternalStack.method_7914();
        int spaceBeforeMaxInt = isPreviousFull ? Math.min(maxStackSize, internalLimit - internalCount) : maxStackSize;
        currentCalculated.method_7939(Integer.MAX_VALUE - spaceBeforeMaxInt);
    }

    public void setStackInSlot(int slot, class_1799 stack, BiConsumer<Integer, class_1799> setStackInSlotSuper) {
        int currentCount;
        int n = currentCount = this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot).method_7947() : 0;
        if (currentCount < stack.method_7947()) {
            this.insertItem(slot, stack.method_46651(stack.method_7947() - currentCount), false);
        } else if (currentCount > stack.method_7947()) {
            this.extractItem(slot, currentCount - stack.method_7947(), false, s -> Integer.MAX_VALUE);
        }
    }

    public boolean isItemValid(int slot, ItemVariant resource, int count, @Nullable class_1657 player, TriPredicate<Integer, ItemVariant, Integer> isItemValidSuper) {
        if (!this.slotDefinitions.containsKey(slot)) {
            return true;
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return slotDefinition.isAccessible() && class_1799.method_31577((class_1799)slotDefinition.item(), (class_1799)resource.toStack(count));
    }

    public class_1799 getStackInSlot(int slot, IntFunction<class_1799> getStackInSlotSuper) {
        return this.slotDefinitions.containsKey(slot) && this.slotDefinitions.get(slot).isAccessible() && this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot) : class_1799.field_8037;
    }

    public boolean isSlotAccessible(int slot) {
        return !this.slotDefinitions.containsKey(slot) || this.slotDefinitions.get(slot).isAccessible();
    }

    public int getSlots() {
        return this.slotRange.numberOfSlots();
    }

    public String getName() {
        return NAME;
    }

    @Nullable
    public Pair<class_2960, class_2960> getNoItemIcon(int slot) {
        return EMPTY_COMPRESSION_SLOT;
    }

    public class_1792 getFilterItem(int slot) {
        return this.slotDefinitions.containsKey(slot) ? this.slotDefinitions.get(slot).item().method_7909() : class_1802.field_8162;
    }

    public void onSlotLimitChange() {
        this.updateSlotLimits(this.slotDefinitions);
    }

    public Set<Integer> getNoSortSlots() {
        return IntStream.rangeClosed(this.slotRange.firstSlot(), this.slotRange.firstSlot() + this.slotRange.numberOfSlots() - 1).boxed().collect(Collectors.toSet());
    }

    public void onSlotFilterChanged(int slot) {
        this.calculateStacks(false);
    }

    public boolean isFilterItem(class_1792 item) {
        for (SlotDefinition slotDefinition : this.slotDefinitions.values()) {
            if (slotDefinition.item().method_7909() != item) continue;
            return true;
        }
        return false;
    }

    public Map<class_1792, Set<Integer>> getFilterItems() {
        HashMap<class_1792, Set<Integer>> filterItems = new HashMap<class_1792, Set<Integer>>();
        for (Map.Entry<Integer, SlotDefinition> entry : this.slotDefinitions.entrySet()) {
            SlotDefinition slotDefinition = entry.getValue();
            if (!slotDefinition.isAccessible()) continue;
            filterItems.computeIfAbsent(slotDefinition.item().method_7909(), k -> new HashSet()).add(entry.getKey());
        }
        return filterItems;
    }

    private static final class SlotDefinition {
        private final class_1799 item;
        private final int prevSlotMultiplier;
        private int slotLimit;
        private final boolean isAccessible;
        private boolean isCompressible = false;

        private SlotDefinition(class_1799 item, int prevSlotMultiplier, int slotLimit, boolean isAccessible) {
            this.item = item.method_46651(1);
            this.prevSlotMultiplier = prevSlotMultiplier;
            this.slotLimit = slotLimit;
            this.isAccessible = isAccessible;
        }

        public static SlotDefinition inaccesible() {
            return new SlotDefinition(class_1799.field_8037, 0, 0, false);
        }

        public SlotDefinition(class_1799 stack, int prevSlotMultiplier, boolean isAccessible) {
            this(stack, prevSlotMultiplier, -1, isAccessible);
        }

        public void setSlotLimit(int slotLimit) {
            this.slotLimit = slotLimit;
        }

        public void setCompressible(boolean compressible) {
            this.isCompressible = compressible;
        }

        public class_1799 item() {
            return this.item;
        }

        public int prevSlotMultiplier() {
            return this.prevSlotMultiplier;
        }

        public int slotLimit() {
            return this.slotLimit;
        }

        public boolean isAccessible() {
            return this.isAccessible;
        }

        public boolean isCompressible() {
            return this.isCompressible;
        }

        public String toString() {
            return "SlotDefinition{item=" + String.valueOf(this.item) + ", prevSlotMultiplier=" + this.prevSlotMultiplier + ", slotLimit=" + this.slotLimit + ", isAccessible=" + this.isAccessible + ", isCompressible=" + this.isCompressible + "}";
        }
    }
}

