/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_4719;
import net.minecraft.class_5632;
import net.minecraft.class_7225;
import net.minecraft.class_9139;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.extensions.component.SophisticatedDataComponentHolder;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageItemClient;

public class WoodStorageBlockItem
extends StorageBlockItem {
    public static final class_9139<class_2540, class_4719> WOOD_TYPE_STREAM_CODEC = class_9139.method_56437((buf, wt) -> buf.method_10814(wt.comp_1299()), buf -> {
        class_4719 woodType = (class_4719)class_4719.field_46536.get(buf.method_19772());
        return woodType == null ? class_4719.field_21676 : woodType;
    });

    public WoodStorageBlockItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public static void setPacked(class_1799 storageStack, boolean packed) {
        storageStack.sophisticatedCore_set(ModDataComponents.PACKED, (Object)packed);
    }

    public static boolean isPacked(class_1799 storageStack) {
        return (Boolean)storageStack.sophisticatedCore_getOrDefault(ModDataComponents.PACKED, (Object)false);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltip, tooltipFlag);
        if (WoodStorageBlockItem.isPacked(stack)) {
            class_7225.class_7874 registries;
            if (tooltipFlag.method_8035() && (registries = context.method_59527()) != null) {
                StackStorageWrapper.fromStack(registries, stack).getContentsUuid().ifPresent(uuid -> tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + String.valueOf(uuid))).method_27692(class_124.field_1063)));
            }
            if (!class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43469((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
            }
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!WoodStorageBlockItem.isPacked(stack)) {
            return Optional.empty();
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return Optional.ofNullable(StorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    @Override
    public void setMainColor(class_1799 storageStack, int mainColor) {
        if (StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setMainColor(storageStack, mainColor);
    }

    @Override
    public void setAccentColor(class_1799 storageStack, int accentColor) {
        if (StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setAccentColor(storageStack, accentColor);
    }

    private void removeWoodType(class_1799 storageStack) {
        storageStack.sophisticatedCore_remove(ModDataComponents.WOOD_TYPE);
    }

    public static Optional<class_4719> getWoodType(SophisticatedDataComponentHolder componentHolder) {
        return Optional.ofNullable((class_4719)componentHolder.sophisticatedCore_get(ModDataComponents.WOOD_TYPE));
    }

    public static class_1799 setWoodType(class_1799 storageStack, class_4719 woodType) {
        storageStack.sophisticatedCore_set(ModDataComponents.WOOD_TYPE, (Object)woodType);
        return storageStack;
    }

    public class_2561 method_7864(class_1799 stack) {
        return WoodStorageBlockItem.getDisplayName(this.method_7876(), WoodStorageBlockItem.getWoodType((SophisticatedDataComponentHolder)stack).orElse(null));
    }

    public static class_2561 getDisplayName(String descriptionId, @Nullable class_4719 woodType) {
        if (woodType == null) {
            return class_2561.method_43469((String)descriptionId, (Object[])new Object[]{"", ""});
        }
        return class_2561.method_43469((String)descriptionId, (Object[])new Object[]{class_2561.method_43471((String)("wood_name.sophisticatedstorage." + woodType.comp_1299().toLowerCase(Locale.ROOT))), " "});
    }
}

