/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_9139;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;

public class StorageToolItem
extends ItemBase {
    public StorageToolItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 flag) {
        tooltipComponents.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(stack.method_7909().method_7876() + ".tooltip", null, new class_124[]{class_124.field_1063}));
        String itemName = RegistryHelper.getItemKey((class_1792)stack.method_7909()).method_12832();
        tooltipComponents.add((class_2561)class_2561.method_43469((String)(StorageTranslationHelper.INSTANCE.translItemTooltip(itemName) + ".controls"), (Object[])new Object[]{class_2561.method_43471((String)(StorageTranslationHelper.INSTANCE.translItemTooltip(itemName) + ".controls.combination")).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
    }

    public static void useOffHandOnPlaced(class_1799 tool, StorageBlockEntity be) {
        if (be.method_10997().method_8608()) {
            return;
        }
        Mode mode = StorageToolItem.getMode(tool);
        if (mode == Mode.LINK) {
            StorageToolItem.getControllerLink(tool).ifPresentOrElse(be::linkToController, () -> ((StorageBlockEntity)be).unlinkFromController());
        } else if (mode == Mode.LOCK) {
            be.toggleLock();
        }
    }

    public class_1269 onItemUseFirst(class_1799 tool, class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        class_2248 blockClicked = level.method_8320(pos).method_26204();
        Mode mode = StorageToolItem.getMode(tool);
        switch (mode.ordinal()) {
            case 0: {
                if (!this.tryLinking(pos, level, blockClicked, tool)) break;
                return class_1269.field_5812;
            }
            case 1: {
                if (!StorageToolItem.tryToggling(pos, level, ILockable.class, ILockable::toggleLock)) break;
                return class_1269.field_5812;
            }
            case 2: {
                if (!StorageToolItem.tryToggling(pos, level, ICountDisplay.class, ICountDisplay::toggleCountVisibility)) break;
                return class_1269.field_5812;
            }
            case 3: {
                if (!StorageToolItem.tryToggling(pos, level, ILockable.class, ILockable::toggleLockVisibility)) break;
                return class_1269.field_5812;
            }
            case 4: {
                if (!StorageToolItem.tryToggling(pos, level, ITierDisplay.class, ITierDisplay::toggleTierVisiblity)) break;
                return class_1269.field_5812;
            }
            case 5: {
                if (!StorageToolItem.tryToggling(pos, level, IUpgradeDisplay.class, IUpgradeDisplay::toggleUpgradesVisiblity)) break;
                return class_1269.field_5812;
            }
            case 6: {
                if (!StorageToolItem.tryToggling(pos, level, IFillLevelDisplay.class, IFillLevelDisplay::toggleFillLevelVisibility)) break;
                return class_1269.field_5812;
            }
        }
        return super.onItemUseFirst(tool, context);
    }

    private static <T> boolean tryToggling(class_2338 pos, class_1937 level, Class<T> clazz, Consumer<T> toggle) {
        return WorldHelper.getLoadedBlockEntity((class_1937)level, (class_2338)pos, clazz).map(be -> {
            if (level.method_8608()) {
                return true;
            }
            toggle.accept(be);
            return true;
        }).orElse(false);
    }

    private boolean tryLinking(class_2338 pos, class_1937 level, class_2248 blockClicked, class_1799 tool) {
        if (blockClicked == ModBlocks.CONTROLLER.get()) {
            this.setControllerLink(tool, pos);
            return true;
        }
        return WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, ILinkable.class).map(linkable -> {
            StorageToolItem.getControllerLink(tool).ifPresentOrElse(arg_0 -> ((ILinkable)linkable).linkToController(arg_0), () -> ((ILinkable)linkable).unlinkFromController());
            return true;
        }).orElse(false);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 tool;
        if (player.method_5715() && StorageToolItem.getControllerLink(tool = player.method_5998(usedHand)).isPresent()) {
            this.removeControllerLink(tool);
            return class_1271.method_22427((Object)tool);
        }
        return super.method_7836(level, player, usedHand);
    }

    private void setControllerLink(class_1799 tool, class_2338 pos) {
        tool.sophisticatedCore_set(ModDataComponents.CONTROLLER_POS, (Object)pos);
    }

    public static Optional<class_2338> getControllerLink(class_1799 tool) {
        return Optional.ofNullable((class_2338)tool.sophisticatedCore_get(ModDataComponents.CONTROLLER_POS));
    }

    private void removeControllerLink(class_1799 tool) {
        tool.sophisticatedCore_remove(ModDataComponents.CONTROLLER_POS);
    }

    public static class_2561 getOverlayMessage(class_1799 tool) {
        Mode mode = StorageToolItem.getMode(tool);
        class_1792 item = tool.method_7909();
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> StorageToolItem.getControllerLink(tool).map(controllerPos -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "linking", controllerPos.method_10263(), controllerPos.method_10264(), controllerPos.method_10260())).orElseGet(() -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "unlinking", new Object[0]));
            case 1 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_lock", new Object[0]);
            case 3 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_lock_display", new Object[0]);
            case 2 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_count_display", new Object[0]);
            case 4 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_tier_display", new Object[0]);
            case 5 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_upgrades_display", new Object[0]);
            case 6 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_fill_level_display", new Object[0]);
        };
    }

    public static Mode getMode(class_1799 tool) {
        return (Mode)((Object)tool.sophisticatedCore_getOrDefault(ModDataComponents.TOOL_MODE, (Object)Mode.LINK));
    }

    public static void cycleMode(class_1799 tool, boolean next) {
        tool.sophisticatedCore_set(ModDataComponents.TOOL_MODE, (Object)(next ? StorageToolItem.getMode(tool).next() : StorageToolItem.getMode(tool).previous()));
    }

    public static enum Mode implements class_3542
    {
        LINK,
        LOCK,
        COUNT_DISPLAY,
        LOCK_DISPLAY,
        TIER_DISPLAY,
        UPGRADES_DISPLAY,
        FILL_LEVEL_DISPLAY;

        public static final class_3542.class_7292<Mode> CODEC;
        public static final class_9139<class_2540, Mode> STREAM_CODEC;

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public Mode previous() {
            return Mode.values()[Math.floorMod(this.ordinal() - 1, Mode.values().length)];
        }

        public String method_15434() {
            return this.name();
        }

        static {
            CODEC = class_3542.method_28140(Mode::values);
            STREAM_CODEC = StreamCodecHelper.enumCodec(Mode.class);
        }
    }
}

