/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_481;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_7225;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageItemClient;

public class ShulkerBoxItem
extends StorageBlockItem
implements IStashStorageItem {
    public ShulkerBoxItem(class_2248 block) {
        this(block, new class_1792.class_1793().method_7889(1));
    }

    public ShulkerBoxItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipFlag) {
        class_7225.class_7874 registries;
        super.method_7851(stack, context, tooltip, tooltipFlag);
        if (tooltipFlag.method_8035() && (registries = context.method_59527()) != null) {
            StackStorageWrapper.fromStack(registries, stack).getContentsUuid().ifPresent(uuid -> tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + String.valueOf(uuid))).method_27692(class_124.field_1063)));
        }
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43469((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return Optional.ofNullable(StorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    public boolean method_31568() {
        return false;
    }

    public void method_33261(class_1542 itemEntity) {
        class_1937 level = itemEntity.method_37908();
        if (level.field_9236) {
            return;
        }
        class_1799 stack = itemEntity.method_6983();
        StackStorageWrapper storageWrapper = StackStorageWrapper.fromStack((class_7225.class_7874)level.method_30349(), stack);
        InventoryHelper.dropItems((SlottedStackStorage)storageWrapper.getInventoryHandler(), (class_1937)level, (double)itemEntity.method_23317(), (double)itemEntity.method_23318(), (double)itemEntity.method_23321());
        InventoryHelper.dropItems((SlottedStackStorage)storageWrapper.getUpgradeHandler(), (class_1937)level, (double)itemEntity.method_23317(), (double)itemEntity.method_23318(), (double)itemEntity.method_23321());
    }

    public Optional<class_5632> getInventoryTooltip(class_1799 stack) {
        return Optional.of(new StorageContentsTooltip(stack));
    }

    public class_1799 stash(class_7225.class_7874 registries, class_1799 storageStack, class_1799 stack, boolean simulate) {
        StackStorageWrapper wrapper = StackStorageWrapper.fromStack(registries, storageStack);
        if (wrapper.getContentsUuid().isEmpty()) {
            wrapper.setContentsUuid(UUID.randomUUID());
        }
        return wrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate);
    }

    public IStashStorageItem.StashResult getItemStashable(class_7225.class_7874 registries, class_1799 storageStack, class_1799 stack) {
        StackStorageWrapper wrapper = StackStorageWrapper.fromStack(registries, storageStack);
        if (wrapper.getInventoryForUpgradeProcessing().insertItem(stack, true).method_7947() == stack.method_7947()) {
            return IStashStorageItem.StashResult.NO_SPACE;
        }
        if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.method_7909()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
            return IStashStorageItem.StashResult.MATCH_AND_SPACE;
        }
        return IStashStorageItem.StashResult.SPACE;
    }

    public int getNumberOfInventorySlots(class_7225.class_7874 registries, class_1799 shulkerBoxStack) {
        int defaultNumberOfInventorySlots = StackStorageWrapper.fromStack(registries, shulkerBoxStack).getDefaultNumberOfInventorySlots();
        return Math.max((Integer)shulkerBoxStack.sophisticatedCore_getOrDefault(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)defaultNumberOfInventorySlots), defaultNumberOfInventorySlots);
    }

    public int getNumberOfUpgradeSlots(class_7225.class_7874 registries, class_1799 shulkerBoxStack) {
        int defaultNumberOfUpgradeSlots = StackStorageWrapper.fromStack(registries, shulkerBoxStack).getDefaultNumberOfUpgradeSlots();
        return Math.max((Integer)shulkerBoxStack.sophisticatedCore_getOrDefault(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)defaultNumberOfUpgradeSlots), defaultNumberOfUpgradeSlots);
    }

    public boolean method_31565(class_1799 storageStack, class_1735 slot, class_5536 action, class_1657 player) {
        if (this.hasCreativeScreenContainerOpen(player) || storageStack.method_7947() > 1 || !slot.method_7674(player) || slot.method_7677().method_7960() || action != class_5536.field_27014) {
            return super.method_31565(storageStack, slot, action, player);
        }
        class_1799 stackToStash = slot.method_7677();
        class_1799 stashResult = this.stash((class_7225.class_7874)player.method_37908().method_30349(), storageStack, stackToStash, true);
        if (stashResult.method_7947() != stackToStash.method_7947()) {
            int countToTake = stackToStash.method_7947() - stashResult.method_7947();
            class_1799 takeResult = slot.method_32753(countToTake, countToTake, player);
            this.stash((class_7225.class_7874)player.method_37908().method_30349(), storageStack, takeResult, false);
            return true;
        }
        return super.method_31565(storageStack, slot, action, player);
    }

    public boolean method_31566(class_1799 storageStack, class_1799 otherStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 carriedAccess) {
        if (this.hasCreativeScreenContainerOpen(player) || storageStack.method_7947() > 1 || !slot.method_7680(storageStack) || action != class_5536.field_27014) {
            return super.method_31566(storageStack, otherStack, slot, action, player, carriedAccess);
        }
        class_1799 result = this.stash((class_7225.class_7874)player.method_37908().method_30349(), storageStack, otherStack, false);
        if (result.method_7947() != otherStack.method_7947()) {
            carriedAccess.method_32332(result);
            slot.method_7673(storageStack);
            return true;
        }
        return super.method_31566(storageStack, otherStack, slot, action, player, carriedAccess);
    }

    private boolean hasCreativeScreenContainerOpen(class_1657 player) {
        return player.method_37908().method_8608() && player.field_7512 instanceof class_481.class_483;
    }
}

