/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2682;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_9694;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;

public class BarrelMaterialRecipe
extends class_1852 {
    public BarrelMaterialRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 input, class_1937 level) {
        int barrelRow = -1;
        int barrelCol = -1;
        int minRowWithBlock = Integer.MAX_VALUE;
        int minColWithBlock = Integer.MAX_VALUE;
        int maxRowWithBlock = Integer.MIN_VALUE;
        int maxColWithBlock = Integer.MIN_VALUE;
        HashMap<Integer, Integer> rowCounts = new HashMap<Integer, Integer>();
        for (int row = 0; row < input.method_59992(); ++row) {
            for (int col = 0; col < input.method_59991(); ++col) {
                class_1747 blockItem;
                class_1747 blockItem2;
                class_1799 item = input.method_59984(col + row * input.method_59991());
                if (item.method_7960()) continue;
                class_1792 class_17922 = item.method_7909();
                if (class_17922 instanceof class_1747 && (blockItem2 = (class_1747)class_17922).method_7711() instanceof BarrelBlock) {
                    if (barrelRow < 0) {
                        barrelRow = row;
                        barrelCol = col;
                        continue;
                    }
                    return false;
                }
                class_17922 = item.method_7909();
                if (class_17922 instanceof class_1747 && class_2248.method_9614((class_265)(blockItem = (class_1747)class_17922).method_7711().method_9564().method_26218((class_1922)class_2682.field_12294, class_2338.field_10980))) {
                    boolean isBottomMiddleAndBottomLeftHasBlock;
                    boolean bl = isBottomMiddleAndBottomLeftHasBlock = barrelCol == col && barrelRow < row && rowCounts.getOrDefault(row, 0) > 0;
                    if (isBottomMiddleAndBottomLeftHasBlock) {
                        return false;
                    }
                    rowCounts.compute(row, (k, v) -> v == null ? 1 : v + 1);
                    if (row < minRowWithBlock) {
                        minRowWithBlock = row;
                    }
                    if (col < minColWithBlock) {
                        minColWithBlock = col;
                    }
                    if (row > maxRowWithBlock) {
                        maxRowWithBlock = row;
                    }
                    if (col <= maxColWithBlock) continue;
                    maxColWithBlock = col;
                    continue;
                }
                return false;
            }
        }
        if (barrelRow < 0 || rowCounts.isEmpty() || minRowWithBlock < barrelRow - 1 || maxRowWithBlock > barrelRow + 1 || minColWithBlock < barrelCol - 1 || maxColWithBlock > barrelCol + 1) {
            return false;
        }
        return rowCounts.getOrDefault(barrelRow - 1, 0) <= 3 && rowCounts.getOrDefault(barrelRow, 0) <= 2 && rowCounts.getOrDefault(barrelRow + 1, 0) <= 2;
    }

    public class_1799 assemble(class_9694 input, class_7225.class_7874 registries) {
        int barrelColumn = -1;
        int barrelRow = -1;
        class_1799 barrelStackCopy = class_1799.field_8037;
        for (int row = 0; row < input.method_59992(); ++row) {
            for (int col = 0; col < input.method_59991(); ++col) {
                class_1747 blockItem;
                class_1792 class_17922;
                class_1799 item = input.method_59984(col + row * input.method_59991());
                if (item.method_7960() || barrelColumn >= 0 || !((class_17922 = item.method_7909()) instanceof class_1747) || !((blockItem = (class_1747)class_17922).method_7711() instanceof BarrelBlock)) continue;
                barrelColumn = col;
                barrelRow = row;
                barrelStackCopy = item.method_7972();
                barrelStackCopy.method_7939(1);
            }
        }
        EnumMap<BarrelMaterial, class_2960> materials = new EnumMap<BarrelMaterial, class_2960>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(barrelStackCopy));
        BarrelBlockItem.uncompactMaterials(materials);
        this.fillGridMaterials(input, barrelColumn, barrelRow, materials);
        BarrelMaterialRecipe.fillEmptyMaterialsWithDefaults(materials);
        BarrelBlockItem.compactMaterials(materials);
        BarrelBlockItem.setMaterials(barrelStackCopy, materials);
        BarrelBlockItem.removeCoveredTints(barrelStackCopy, materials);
        return barrelStackCopy;
    }

    private static void fillEmptyMaterialsWithDefaults(Map<BarrelMaterial, class_2960> materials) {
        block0: for (BarrelMaterial material : BarrelMaterial.values()) {
            if (!material.isLeaf() || materials.containsKey((Object)material)) continue;
            for (BarrelMaterial fillFromDefault : BarrelMaterial.getFillFromDefaults(material)) {
                if (!materials.containsKey((Object)fillFromDefault)) continue;
                materials.put(material, materials.get((Object)fillFromDefault));
                continue block0;
            }
        }
    }

    private void fillGridMaterials(class_9694 input, int barrelColumn, int barrelRow, Map<BarrelMaterial, class_2960> materials) {
        for (int row = 0; row < input.method_59992(); ++row) {
            for (int col = 0; col < input.method_59991(); ++col) {
                class_1792 class_17922;
                class_1799 item = input.method_59984(col + row * input.method_59991());
                if (row == barrelRow && col == barrelColumn || item.method_7960() || !((class_17922 = item.method_7909()) instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)class_17922;
                List<BarrelMaterial> barrelMaterials = this.getBarrelMaterials(row, col, barrelRow, barrelColumn);
                boolean firstMaterial = true;
                for (BarrelMaterial barrelMaterial : barrelMaterials) {
                    if (!materials.containsKey((Object)barrelMaterial) || firstMaterial) {
                        materials.put(barrelMaterial, class_7923.field_41175.method_10221((Object)blockItem.method_7711()));
                    }
                    firstMaterial = false;
                }
            }
        }
    }

    private List<BarrelMaterial> getBarrelMaterials(int row, int col, int barrelRow, int barrelColumn) {
        if (row < barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.TOP);
            }
            if (col == barrelColumn) {
                return List.of(BarrelMaterial.TOP_INNER_TRIM, BarrelMaterial.TOP, BarrelMaterial.TOP_TRIM);
            }
            return List.of(BarrelMaterial.TOP_TRIM);
        }
        if (row == barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.SIDE);
            }
            return List.of(BarrelMaterial.SIDE_TRIM);
        }
        if (col < barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM);
        }
        if (col == barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM, BarrelMaterial.BOTTOM_TRIM);
        }
        return List.of(BarrelMaterial.BOTTOM_TRIM);
    }

    public boolean method_8113(int width, int height) {
        return width * height > 1;
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModBlocks.BARREL_MATERIAL_RECIPE_SERIALIZER.get();
    }
}

