/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.registry.EmiTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.p3pp3rf1y.sophisticatedcore.compat.emi.EmiGridMenuInfo;
import net.p3pp3rf1y.sophisticatedcore.compat.emi.EmiSettingsGhostDragDropHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.emi.EmiStorageGhostDragDropHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.emi.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageSettingsScreen;
import net.p3pp3rf1y.sophisticatedstorage.compat.emi.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.emi.ShulkerBoxFromChestRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.emi.TierUpgradeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.emi.subtypes.BarrelSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.emi.subtypes.ChestSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.emi.subtypes.ShulkerBoxSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.FlatBarrelRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.crafting.BaseTierWoodenStorageIngredient;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromVanillaShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

@EmiEntrypoint
public class EmiCompat
implements EmiPlugin {
    public static Event<WorkstationCallback> WORKSTATIONS = EventFactory.createArrayBacked(WorkstationCallback.class, listeners -> consumer -> {
        for (WorkstationCallback listener : listeners) {
            listener.additionalWorkstations(consumer);
        }
    });
    private final PropertyBasedSubtypeInterpreter chestSubtypeInterpreter = new ChestSubtypeInterpreter();
    private final PropertyBasedSubtypeInterpreter barrelSubtypeInterpreter = new BarrelSubtypeInterpreter();
    private final PropertyBasedSubtypeInterpreter shulkerBoxSubtypeInterpreter = new ShulkerBoxSubtypeInterpreter();

    private Map<class_1747, PropertyBasedSubtypeInterpreter> getSubtypeIntepreters() {
        return new HashMap<class_1747, PropertyBasedSubtypeInterpreter>(){
            {
                this.put(ModBlocks.BARREL_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.COPPER_BARREL_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.IRON_BARREL_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.GOLD_BARREL_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_BARREL_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_BARREL_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.CHEST_ITEM.get(), EmiCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.COPPER_CHEST_ITEM.get(), EmiCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.IRON_CHEST_ITEM.get(), EmiCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.GOLD_CHEST_ITEM.get(), EmiCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_CHEST_ITEM.get(), EmiCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_CHEST_ITEM.get(), EmiCompat.this.chestSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_1_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_2_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_3_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_4_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get(), EmiCompat.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.SHULKER_BOX_ITEM.get(), EmiCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), EmiCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.IRON_SHULKER_BOX_ITEM.get(), EmiCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), EmiCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), EmiCompat.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get(), EmiCompat.this.shulkerBoxSubtypeInterpreter);
            }
        };
    }

    private Optional<PropertyBasedSubtypeInterpreter> getSubtypeInterpreter(Map<class_1747, PropertyBasedSubtypeInterpreter> subtypeInterpreters, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return Optional.empty();
        }
        class_1747 blockItem = (class_1747)class_17922;
        return Optional.ofNullable(subtypeInterpreters.get(blockItem));
    }

    public void register(EmiRegistry registry) {
        registry.addExclusionArea(StorageScreen.class, (screen, consumer) -> {
            screen.getUpgradeSlotsRectangle().ifPresent(r -> consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())));
            screen.getUpgradeSettingsControl().getTabRectangles().forEach(r -> consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())));
            screen.getSortButtonsRectangle().ifPresent(r -> consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())));
        });
        registry.addExclusionArea(StorageSettingsScreen.class, (screen, consumer) -> {
            if (screen == null || screen.getSettingsTabControl() == null) {
                return;
            }
            screen.getSettingsTabControl().getTabRectangles().forEach(r -> consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())));
        });
        registry.addDragDropHandler(StorageScreen.class, (EmiDragDropHandler)new EmiStorageGhostDragDropHandler());
        registry.addDragDropHandler(StorageSettingsScreen.class, (EmiDragDropHandler)new EmiSettingsGhostDragDropHandler());
        Map<class_1747, PropertyBasedSubtypeInterpreter> subtypeInterpreters = this.getSubtypeIntepreters();
        EmiCompat.registerCraftingRecipes(registry, DyeRecipesMaker.getRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (class_1799)stack)));
        EmiCompat.registerCraftingRecipes(registry, TierUpgradeRecipesMaker.getShapedCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (class_1799)stack)));
        EmiCompat.registerCraftingRecipes(registry, TierUpgradeRecipesMaker.getShapelessCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (class_1799)stack)));
        EmiCompat.registerCraftingRecipes(registry, ShulkerBoxFromChestRecipesMaker.getRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (class_1799)stack)));
        EmiCompat.registerCraftingRecipes(registry, ClientRecipeHelper.transformAllRecipesOfType((class_3956)class_3956.field_17545, ShulkerBoxFromVanillaShapelessRecipe.class, ClientRecipeHelper::copyShapelessRecipe));
        EmiCompat.registerCraftingRecipes(registry, FlatBarrelRecipesMaker.getRecipes());
        for (Supplier<class_1747> supplier : ModBlocks.WOODEN_STORAGE_INGREDIENT_ITEMS) {
            ClientRecipeHelper.getCraftingRecipeByKey((class_3956)class_3956.field_17545, (class_2960)class_7923.field_41178.method_10221((Object)((class_1792)supplier.get()))).ifPresent(r -> EmiCompat.registerRecipes(registry, List.of(r)));
        }
        Comparison barrelNbtInterpreter = Comparison.compareData(emiStack -> this.barrelSubtypeInterpreter.getSubtypeData(emiStack.getItemStack()));
        for (Supplier<class_1747> item : ModBlocks.ALL_BARREL_ITEMS) {
            registry.setDefaultComparison((Object)item.get(), barrelNbtInterpreter);
        }
        Comparison woodStorageNbtInterpreter = Comparison.compareData(emiStack -> this.chestSubtypeInterpreter.getSubtypeData(emiStack.getItemStack()));
        for (Supplier<class_1747> supplier : ModBlocks.CHEST_ITEMS) {
            registry.setDefaultComparison((Object)supplier.get(), woodStorageNbtInterpreter);
        }
        Comparison shulkerBoxNbtInterpreter = Comparison.compareData(emiStack -> this.shulkerBoxSubtypeInterpreter.getSubtypeData(emiStack.getItemStack()));
        for (Supplier<class_1747> supplier : ModBlocks.SHULKER_BOX_ITEMS) {
            registry.setDefaultComparison(supplier, shulkerBoxNbtInterpreter);
        }
        registry.addRecipeHandler(ModBlocks.STORAGE_CONTAINER_TYPE.get(), (EmiRecipeHandler)EmiGridMenuInfo.crafting());
        registry.addRecipeHandler(ModBlocks.STORAGE_CONTAINER_TYPE.get(), (EmiRecipeHandler)EmiGridMenuInfo.stonecutting());
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1935)((class_1935)ModItems.CRAFTING_UPGRADE.get())));
        registry.addWorkstation(VanillaEmiRecipeCategories.STONECUTTING, (EmiIngredient)EmiStack.of((class_1935)((class_1935)ModItems.STONECUTTER_UPGRADE.get())));
        ArrayList arrayList = new ArrayList();
        ((WorkstationCallback)WORKSTATIONS.invoker()).additionalWorkstations(arrayList::add);
        for (WorkstationEntry entry : arrayList) {
            registry.addWorkstation(new EmiRecipeCategory(entry.id, (EmiRenderable)EmiStack.of((class_1935)entry.icon)), (EmiIngredient)EmiStack.of((class_1935)entry.workstation));
        }
    }

    private static void registerCraftingRecipes(EmiRegistry registry, Collection<class_8786<class_3955>> recipes) {
        class_310 mc = class_310.method_1551();
        recipes.forEach(r -> registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(((class_3955)r.comp_1933()).method_8117().stream().map(EmiIngredient::of).toList(), EmiStack.of((class_1799)((class_3955)r.comp_1933()).method_8110((class_7225.class_7874)mc.field_1687.method_30349())), r.comp_1932().method_45138("/"))));
    }

    private static void registerRecipes(EmiRegistry registry, List<class_8786<class_3955>> recipes) {
        recipes.forEach(holder -> {
            class_1860 r = holder.comp_1933();
            class_2371 ingredients = r.method_8117();
            class_2371 ingredientsCopy = class_2371.method_37434((int)ingredients.size());
            int i = 0;
            for (class_1856 ingredient : ingredients) {
                if (ingredient.getCustomIngredient() instanceof BaseTierWoodenStorageIngredient) {
                    class_1799[] stacks = ingredient.method_8105();
                    int amount = 1;
                    if (stacks.length != 0) {
                        amount = stacks[0].method_7947();
                        for (int j = 1; j < stacks.length; ++j) {
                            if (stacks[j].method_7947() == amount) continue;
                            amount = 1;
                            break;
                        }
                    }
                    ingredientsCopy.add(i, (Object)EmiTags.getIngredient(class_1792.class, Arrays.stream(ingredient.method_8105()).map(stack -> EmiStack.of((class_1799)stack).comparison(Comparison.compareComponents())).toList(), (long)amount));
                } else {
                    ingredientsCopy.add(i, (Object)EmiIngredient.of((class_1856)ingredient));
                }
                ++i;
            }
            registry.removeRecipes(holder.comp_1932());
            registry.addRecipe((EmiRecipe)new EmiCraftingRecipe((List)ingredientsCopy, EmiStack.of((class_1799)r.method_8110(null)), class_2960.method_60655((String)holder.comp_1932().method_12836(), (String)("/" + holder.comp_1932().method_12832()))));
        });
    }

    public static interface WorkstationCallback {
        public void additionalWorkstations(Consumer<WorkstationEntry> var1);
    }

    public record WorkstationEntry(class_2960 id, class_2248 icon, class_1792 workstation) {
    }
}

