/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RenderHelper {
    private static final Cache<Integer, class_1058> SPRITE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private RenderHelper() {
    }

    public static class_1058 getSprite(class_2960 blockName, @Nullable class_2350 direction, class_5819 rand) {
        int hash = blockName.hashCode();
        class_1058 sprite = (class_1058)SPRITE_CACHE.getIfPresent((Object)(hash = hash * 31 + (direction == null ? 0 : direction.hashCode())));
        if (sprite == null) {
            sprite = RenderHelper.parseSprite(blockName, direction, rand);
            SPRITE_CACHE.put((Object)hash, (Object)sprite);
        }
        return sprite;
    }

    private static class_1058 parseSprite(class_2960 blockName, @Nullable class_2350 direction, class_5819 rand) {
        class_2680 blockState = RenderHelper.getDefaultBlockState(blockName);
        class_1058 sprite = RenderHelper.parseSpriteFromModel(blockState, direction, rand);
        if (sprite == null) {
            sprite = class_310.method_1551().method_1554().method_4744().method_4711();
        }
        return sprite;
    }

    @Nullable
    private static class_1058 parseSpriteFromModel(class_2680 blockState, @Nullable class_2350 direction, class_5819 rand) {
        class_1058 sprite = null;
        class_1087 blockModel = class_310.method_1551().method_1541().method_3349(blockState);
        try {
            List culledQuads = blockModel.method_4707(blockState, direction, rand);
            if (!culledQuads.isEmpty()) {
                return ((class_777)culledQuads.get(0)).method_35788();
            }
            for (class_777 bakedQuad : blockModel.method_4707(blockState, null, rand)) {
                if (sprite == null) {
                    sprite = bakedQuad.method_35788();
                }
                if (bakedQuad.method_3358() != direction) continue;
                return bakedQuad.method_35788();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sprite == null) {
            try {
                sprite = blockModel.method_4711();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sprite;
    }

    private static class_2680 getDefaultBlockState(class_2960 blockName) {
        return class_7923.field_41175.method_17966(blockName).map(class_2248::method_9564).orElse(class_2246.field_10124.method_9564());
    }

    static void renderQuad(class_4588 consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha) {
        RenderHelper.renderQuad(consumer, pose, normal, packedOverlay, packedLight, alpha, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    static void renderQuad(class_4588 consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha, float minU, float minV, float maxU, float maxV) {
        boolean minX = false;
        int minY = 0;
        int maxY = 1;
        boolean maxX = true;
        RenderHelper.addVertex(pose, normal, consumer, maxY, (float)minX, packedOverlay, packedLight, maxU, minV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, minY, (float)minX, packedOverlay, packedLight, maxU, maxV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, minY, (float)maxX, packedOverlay, packedLight, minU, maxV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, maxY, (float)maxX, packedOverlay, packedLight, minU, minV, alpha);
    }

    private static void addVertex(Matrix4f pose, Vector3f normal, class_4588 consumer, int pY, float pX, int packedOverlay, int packedLight, float u, float v, float alpha) {
        Vector4f pos = new Vector4f(pX, (float)pY, 0.0f, 1.0f);
        pose.transform(pos);
        int color = (int)(alpha * 255.0f) << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        consumer.method_23919(pos.x(), pos.y(), pos.z(), color, u, v, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
    }
}

