/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryBakingContext;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1090;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_809;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.client.render.SSElementsModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.SimpleCompositeModel;

public class CompositeElementsModel
extends class_793 {
    private final List<class_785> elements = new ArrayList<class_785>();

    public CompositeElementsModel(@Nullable class_2960 parentLocation, Map<String, Either<class_4730, String>> textureMap) {
        super(parentLocation, Collections.emptyList(), textureMap, Boolean.valueOf(true), null, class_809.field_4301, Collections.emptyList());
    }

    public class_1087 method_3446(class_7775 modelBaker, class_793 owner, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, boolean guiLight3d) {
        if (this.method_3431() == class_1088.field_5389) {
            class_1058 particleSprite = spriteGetter.apply(this.method_24077("particle"));
            return new class_1090(this.method_3443(), this.getOverrides(modelBaker, owner, spriteGetter), particleSprite, this.method_24298().method_24299());
        }
        SSElementsModel elementsModel = new SSElementsModel(this.method_3433());
        return elementsModel.bake((IGeometryBakingContext)this.port_lib$getCustomData(), modelBaker, spriteGetter, modelState, this.getOverrides(modelBaker, owner, spriteGetter));
    }

    public List<class_785> method_3433() {
        return this.elements;
    }

    public void method_45785(Function<class_2960, class_1100> modelGetter) {
        super.method_45785(modelGetter);
        this.copyElementsFromAllIncludedModels();
        this.copyTexturesFromAllIncludedModels();
    }

    private void copyElementsFromAllIncludedModels() {
        if (this.field_4253 != null) {
            IUnbakedGeometry iUnbakedGeometry;
            this.elements.addAll(this.field_4253.method_3433());
            if (this.field_4253.port_lib$getCustomData().hasCustomGeometry() && (iUnbakedGeometry = this.field_4253.port_lib$getCustomData().getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel simpleCompositeModel = (SimpleCompositeModel)iUnbakedGeometry;
                this.elements.addAll(simpleCompositeModel.getElements());
            }
        }
    }

    private void copyTexturesFromAllIncludedModels() {
        if (this.field_4253 != null) {
            IUnbakedGeometry iUnbakedGeometry;
            this.field_4253.field_4251.forEach(this.field_4251::putIfAbsent);
            if (this.field_4253.port_lib$getCustomData().hasCustomGeometry() && (iUnbakedGeometry = this.field_4253.port_lib$getCustomData().getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel simpleCompositeModel = (SimpleCompositeModel)iUnbakedGeometry;
                simpleCompositeModel.getTextures().forEach(this.field_4251::putIfAbsent);
            }
        }
    }

    public class_4730 method_24077(String textureName) {
        if (textureName.charAt(0) == '#') {
            textureName = textureName.substring(1);
        }
        ArrayList visitedTextureReferences = Lists.newArrayList();
        Either<class_4730, String> either;
        Optional optional;
        while (!(optional = (either = this.findTexture(textureName)).left()).isPresent()) {
            textureName = either.right().orElse("");
            if (visitedTextureReferences.contains(textureName)) {
                SophisticatedStorage.LOGGER.warn("Unable to resolve texture due to reference chain {}->{} in {}", new Object[]{Joiner.on((String)"->").join((Iterable)visitedTextureReferences), textureName, this.field_4252});
                return new class_4730(class_1723.field_21668, class_1047.method_4539());
            }
            visitedTextureReferences.add(textureName);
        }
        return (class_4730)optional.get();
    }

    private Either<class_4730, String> findTexture(String textureName) {
        CompositeElementsModel blockmodel = this;
        while (blockmodel != null) {
            Either either = (Either)blockmodel.field_4251.get(textureName);
            if (either != null) {
                return either;
            }
            blockmodel = blockmodel.field_4253;
        }
        return Either.left((Object)new class_4730(class_1723.field_21668, class_1047.method_4539()));
    }
}

