/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4590;
import net.minecraft.class_4719;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_796;
import net.minecraft.class_804;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.p3pp3rf1y.sophisticatedcore.client.render.CustomParticleIcon;
import net.p3pp3rf1y.sophisticatedcore.extensions.component.SophisticatedDataComponentHolder;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedcore.util.model.ModelData;
import net.p3pp3rf1y.sophisticatedcore.util.model.ModelProperty;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.CompositeElementsModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DynamicBarrelBakingData;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.util.QuadTransformers;
import net.p3pp3rf1y.sophisticatedstorage.client.util.QuaternionHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class BarrelBakedModelBase
implements class_1087,
CustomParticleIcon {
    private static final RenderContext.QuadTransform MOVE_TO_CORNER = QuadTransformers.applying(new class_4590(new Vector3f(-0.5f, -0.5f, -0.5f), null, null, null));
    public static final Map<class_2350, RenderContext.QuadTransform> DIRECTION_ROTATES = Map.of(class_2350.field_11036, BarrelBakedModelBase.getDirectionRotationTransform(class_2350.field_11036), class_2350.field_11033, BarrelBakedModelBase.getDirectionRotationTransform(class_2350.field_11033), class_2350.field_11043, BarrelBakedModelBase.getDirectionRotationTransform(class_2350.field_11043), class_2350.field_11035, BarrelBakedModelBase.getDirectionRotationTransform(class_2350.field_11035), class_2350.field_11039, BarrelBakedModelBase.getDirectionRotationTransform(class_2350.field_11039), class_2350.field_11034, BarrelBakedModelBase.getDirectionRotationTransform(class_2350.field_11034));
    private static final LoadingCache<class_2350, Cache<Integer, RenderContext.QuadTransform>> DIRECTION_MOVES_3D_ITEMS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<class_2350, Cache<Integer, RenderContext.QuadTransform>>(){

        public Cache<Integer, RenderContext.QuadTransform> load(class_2350 key) {
            return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        }
    });
    private static final RenderContext.QuadTransform SCALE_BIG_2D_ITEM = QuadTransformers.applying(new class_4590(null, null, new Vector3f(0.5f, 0.5f, 0.5f), null));
    private static final RenderContext.QuadTransform SCALE_SMALL_3D_ITEM = QuadTransformers.applying(new class_4590(null, null, new Vector3f(0.5f, 0.5f, 0.5f), null));
    private static final RenderContext.QuadTransform SCALE_SMALL_2D_ITEM = QuadTransformers.applying(new class_4590(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null));
    private static final Cache<Integer, RenderContext.QuadTransform> DIRECTION_MOVE_BACK_TO_SIDE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static final ModelProperty<String> WOOD_NAME = new ModelProperty();
    private static final ModelProperty<Boolean> IS_PACKED = new ModelProperty();
    private static final ModelProperty<Boolean> SHOWS_LOCK = new ModelProperty();
    private static final ModelProperty<Boolean> SHOWS_TIER = new ModelProperty();
    private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();
    private static final ModelProperty<Boolean> HAS_ACCENT_COLOR = new ModelProperty();
    private static final ModelProperty<List<RenderInfo.DisplayItem>> DISPLAY_ITEMS = new ModelProperty();
    private static final ModelProperty<List<Integer>> INACCESSIBLE_SLOTS = new ModelProperty();
    private static final ModelProperty<Map<BarrelMaterial, class_2960>> MATERIALS = new ModelProperty();
    public static final Cache<Integer, List<class_777>> BAKED_QUADS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
    private static final Map<Integer, RenderContext.QuadTransform> DISPLAY_ROTATIONS = new HashMap<Integer, RenderContext.QuadTransform>();
    private static final class_809 ITEM_TRANSFORMS = BarrelBakedModelBase.createItemTransforms();
    private static final List<BarrelMaterial> PARTICLE_ICON_MATERIAL_PRIORITY = List.of(BarrelMaterial.ALL, BarrelMaterial.ALL_BUT_TRIM, BarrelMaterial.TOP_ALL, BarrelMaterial.TOP);
    private static final Cache<class_2680, ModelData> modelDataCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final class_7775 baker;
    private final Function<class_4730, class_1058> spriteGetter;
    protected final Map<String, Map<BarrelModelPart, class_1087>> woodModelParts;
    private final class_806 barrelItemOverrides;
    private class_1792 barrelItem = class_1802.field_8162;
    @Nullable
    private String barrelWoodName = null;
    private boolean barrelHasMainColor = false;
    private boolean barrelHasAccentColor = false;
    private boolean barrelIsPacked = false;
    private boolean barrelShowsTier = true;
    private Map<BarrelMaterial, class_2960> barrelMaterials = new EnumMap<BarrelMaterial, class_2960>(BarrelMaterial.class);
    private boolean flatTop = false;
    private final Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData;
    private final Map<String, Map<BarrelModelPart, class_1087>> woodPartitionedModelParts;
    private final Cache<Integer, class_1087> dynamicBakedModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private ModelData modelData;

    public static void setModelData(class_2680 state, ModelData data) {
        modelDataCache.put((Object)state, (Object)data);
    }

    private static class_809 createItemTransforms() {
        return new class_809(new class_804(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new class_804(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new class_804(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new class_804(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new class_804(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.890625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new class_804(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new class_804(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new class_804(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));
    }

    public static void invalidateCache() {
        DIRECTION_MOVES_3D_ITEMS.invalidateAll();
        DIRECTION_MOVE_BACK_TO_SIDE.invalidateAll();
        BAKED_QUADS_CACHE.invalidateAll();
    }

    protected BarrelBakedModelBase(class_7775 baker, Function<class_4730, class_1058> spriteGetter, Map<String, Map<BarrelModelPart, class_1087>> woodModelParts, @Nullable class_1087 flatTopModel, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData, Map<String, Map<BarrelModelPart, class_1087>> woodPartitionedModelParts) {
        this.baker = baker;
        this.spriteGetter = spriteGetter;
        this.woodModelParts = woodModelParts;
        this.barrelItemOverrides = new BarrelItemOverrides(this, flatTopModel);
        this.woodDynamicBakingData = woodDynamicBakingData;
        this.woodPartitionedModelParts = woodPartitionedModelParts;
    }

    private static RenderContext.QuadTransform getDirectionRotationTransform(class_2350 dir) {
        return QuadTransformers.applying(new class_4590(null, DisplayItemRenderer.getNorthBasedRotation(dir), null, null));
    }

    private RenderContext.QuadTransform getDirectionMoveBackToSide(class_2680 state, class_2350 dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
        int hash = this.calculateMoveBackToSideHash(state, dir, distFromCenter, displayItemIndex, displayItemCount);
        RenderContext.QuadTransform transform = (RenderContext.QuadTransform)DIRECTION_MOVE_BACK_TO_SIDE.getIfPresent((Object)hash);
        if (transform == null) {
            class_2382 normal = dir.method_10163();
            Vector3f offset = new Vector3f(distFromCenter, distFromCenter, distFromCenter);
            offset.mul((float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260());
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount);
            frontOffset.add(-0.5f, -0.5f, -0.5f);
            this.rotateDisplayItemFrontOffset(state, dir, frontOffset);
            frontOffset.add(0.5f, 0.5f, 0.5f);
            offset.add((Vector3fc)frontOffset);
            transform = QuadTransformers.applying(new class_4590(offset, null, null, null));
            DIRECTION_MOVE_BACK_TO_SIDE.put((Object)hash, (Object)transform);
        }
        return transform;
    }

    protected void rotateDisplayItemFrontOffset(class_2680 state, class_2350 dir, Vector3f frontOffset) {
        frontOffset.rotate((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(dir));
    }

    protected int calculateMoveBackToSideHash(class_2680 state, class_2350 dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
        int hash = Float.hashCode(distFromCenter);
        hash = 31 * hash + displayItemIndex;
        hash = 31 * hash + displayItemCount;
        return hash;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.modelData = this.getModelData(blockView, pos, state, ModelData.EMPTY);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.modelData = null;
        super.emitItemQuads(stack, randomSupplier, context);
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
        if (this.modelData == null && state != null) {
            this.modelData = (ModelData)modelDataCache.getIfPresent((Object)state);
        }
        return this.getQuads(state, side, rand, this.modelData, null);
    }

    public List<class_777> getQuads(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand, @Nullable ModelData extraData, @Nullable class_1921 renderType) {
        boolean showsTier;
        Map<BarrelMaterial, class_2960> materials;
        boolean isPacked;
        boolean hasAccentColor;
        boolean hasMainColor;
        int hash;
        List quads;
        if (extraData == null) {
            extraData = ModelData.EMPTY;
        }
        if ((quads = (List)BAKED_QUADS_CACHE.getIfPresent((Object)(hash = this.createHash(state, side, extraData, renderType)))) != null) {
            return quads;
        }
        String woodName = null;
        if (state != null) {
            hasMainColor = Boolean.TRUE.equals(extraData.get(HAS_MAIN_COLOR));
            hasAccentColor = Boolean.TRUE.equals(extraData.get(HAS_ACCENT_COLOR));
            if (extraData.has(WOOD_NAME)) {
                woodName = (String)extraData.get(WOOD_NAME);
            }
            isPacked = this.isPacked(extraData);
            materials = this.getMaterials(extraData);
            showsTier = this.showsTier(extraData);
        } else {
            woodName = this.barrelWoodName;
            hasMainColor = this.barrelHasMainColor;
            hasAccentColor = this.barrelHasAccentColor;
            isPacked = this.barrelIsPacked;
            materials = this.barrelMaterials;
            showsTier = this.barrelShowsTier;
        }
        ArrayList<class_777> ret = new ArrayList<class_777>();
        boolean isBakedDynamically = !materials.isEmpty();
        Set materialModelParts = materials.keySet().stream().map(BarrelMaterial::getMaterialModelPart).collect(Collectors.toSet());
        boolean rendersUsingSplitModel = materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE) || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM);
        Map<BarrelModelPart, class_1087> modelParts = this.getWoodModelParts(woodName, isBakedDynamically && rendersUsingSplitModel);
        if (modelParts.isEmpty()) {
            return Collections.emptyList();
        }
        if (!(hasMainColor && hasAccentColor || isBakedDynamically)) {
            this.addPartQuads(state, side, rand, ret, modelParts, this.getBasePart(state), renderType);
        }
        this.addTintableModelQuads(state, side, rand, ret, hasMainColor, hasAccentColor, modelParts, renderType);
        if (isBakedDynamically && (renderType == null || renderType == class_1921.method_23581())) {
            this.bakeAndAddDynamicQuads(BarrelBakedModelBase.getSpriteSide(state, side), rand, woodName, materials, rendersUsingSplitModel, !hasMainColor || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE), !hasAccentColor || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM)).forEach(bakedModel -> ret.addAll(bakedModel.method_4707(state, side, rand)));
        }
        if (showsTier) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.TIER, renderType);
        }
        if (isPacked) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.PACKED, renderType);
        } else {
            if (this.showsLocked(extraData)) {
                this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.LOCKED, renderType);
            }
            this.addDisplayItemQuads(state, side, rand, ret, extraData, renderType);
        }
        BAKED_QUADS_CACHE.put((Object)hash, ret);
        return ret;
    }

    public List<class_777> getTierQuads(class_2680 state, class_5819 rand, String woodName, class_1921 renderType) {
        return this.getPartQuads(state, rand, woodName, BarrelModelPart.TIER, renderType);
    }

    public List<class_777> getLockQuads(class_2680 state, class_5819 rand, String woodName, class_1921 renderType) {
        return this.getPartQuads(state, rand, woodName, BarrelModelPart.LOCKED, renderType);
    }

    private List<class_777> getPartQuads(class_2680 state, class_5819 rand, String woodName, BarrelModelPart part, class_1921 renderType) {
        ArrayList<class_777> ret = new ArrayList<class_777>();
        Map<BarrelModelPart, class_1087> modelParts = this.getWoodModelParts(woodName, false);
        for (class_2350 dir : class_2350.values()) {
            this.addPartQuads(state, dir, rand, ret, modelParts, part, renderType);
        }
        return ret;
    }

    private static class_2350 getSpriteSide(@Nullable class_2680 state, @Nullable class_2350 side) {
        class_2350 sideBeforeRotation;
        class_2248 class_22482;
        if (side == null) {
            return class_2350.field_11043;
        }
        if (state != null && (class_22482 = state.method_26204()) instanceof BarrelBlock) {
            BarrelBlock barrelBlock = (BarrelBlock)class_22482;
            sideBeforeRotation = BlockSide.fromDirection(side, barrelBlock.getHorizontalDirection(state), barrelBlock.getVerticalFacing(state)).toDirection(class_2350.field_11043, VerticalFacing.NO);
        } else {
            sideBeforeRotation = BlockSide.fromDirection(side, class_2350.field_11043, VerticalFacing.UP).toDirection(class_2350.field_11043, VerticalFacing.NO);
        }
        return sideBeforeRotation;
    }

    private List<class_1087> bakeAndAddDynamicQuads(@Nullable class_2350 spriteSide, class_5819 rand, @Nullable String woodName, Map<BarrelMaterial, class_2960> barrelMaterials, boolean rendersUsingSplitModel, boolean renderCore, boolean renderTrim) {
        Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData> bakingData = this.woodDynamicBakingData.get(woodName != null ? woodName : class_4719.field_21679.comp_1299());
        HashMap<String, Either<class_4730, String>> materials = new HashMap<String, Either<class_4730, String>>();
        for (Map.Entry<BarrelMaterial, class_2960> entry : barrelMaterials.entrySet()) {
            BarrelMaterial barrelMaterial = entry.getKey();
            class_2960 blockName = entry.getValue();
            class_1058 sprite = RenderHelper.getSprite(blockName, spriteSide, rand);
            Either material = Either.left((Object)new class_4730(class_1723.field_21668, sprite.method_45851().method_45816()));
            for (BarrelMaterial childMaterial : barrelMaterial.getChildren()) {
                materials.put(childMaterial.method_15434(), (Either<class_4730, String>)material);
            }
        }
        ArrayList<class_1087> models = new ArrayList<class_1087>();
        if (rendersUsingSplitModel) {
            if (renderCore) {
                models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.CORE));
            }
            if (renderTrim) {
                models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.TRIM));
            }
        } else {
            models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.WHOLE));
        }
        return models;
    }

    private class_1087 getDynamicModel(@Nullable String woodName, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData> bakingData, Map<String, Either<class_4730, String>> materials, DynamicBarrelBakingData.DynamicPart dynamicPart) {
        int hash = Objects.hash(woodName, materials, dynamicPart.name());
        class_1087 bakedModel = (class_1087)this.dynamicBakedModelCache.getIfPresent((Object)hash);
        if (bakedModel == null) {
            bakedModel = this.compileAndBakeModel(materials, bakingData.get((Object)dynamicPart));
            this.dynamicBakedModelCache.put((Object)hash, (Object)bakedModel);
        }
        return bakedModel;
    }

    private class_2680 getDefaultBlockState(class_2960 blockName) {
        return ((class_2248)class_7923.field_41175.method_10223(blockName)).method_9564();
    }

    private Map<BarrelMaterial, class_2960> getMaterials(ModelData extraData) {
        return extraData.has(MATERIALS) ? Objects.requireNonNull((Map)extraData.get(MATERIALS)) : Collections.emptyMap();
    }

    private class_1087 compileAndBakeModel(Map<String, Either<class_4730, String>> materials, DynamicBarrelBakingData bakingData) {
        bakingData.modelPartDefinition().textures().forEach((textureName, texture) -> {
            if (!materials.containsKey(textureName)) {
                materials.put((String)textureName, (Either<class_4730, String>)Either.left((Object)texture));
            }
        });
        BarrelDynamicModelBase.BarrelModelPartDefinition baseModelPartDefinition = bakingData.modelPartDefinition();
        return baseModelPartDefinition.modelLocation().map(modelLocation -> {
            CompositeElementsModel baseModel = new CompositeElementsModel((class_2960)modelLocation, materials);
            baseModel.method_45785(arg_0 -> ((class_7775)this.baker).method_45872(arg_0));
            return baseModel.method_3446(this.baker, baseModel, this.spriteGetter, bakingData.modelState(), false);
        }).orElse(class_310.method_1551().method_1554().method_4744());
    }

    protected abstract BarrelModelPart getBasePart(@Nullable class_2680 var1);

    private boolean isPacked(ModelData extraData) {
        return extraData.has(IS_PACKED) && Boolean.TRUE.equals(extraData.get(IS_PACKED));
    }

    private boolean showsLocked(ModelData extraData) {
        return extraData.has(SHOWS_LOCK) && Boolean.TRUE.equals(extraData.get(SHOWS_LOCK));
    }

    private boolean showsTier(ModelData extraData) {
        return extraData.has(SHOWS_TIER) && Boolean.TRUE.equals(extraData.get(SHOWS_TIER));
    }

    private int createHash(@Nullable class_2680 state, @Nullable class_2350 side, ModelData data, @Nullable class_1921 renderType) {
        int hash = state != null ? this.getInWorldBlockHash(state, data, renderType) : this.getItemBlockHash();
        hash = hash * 31 + (side == null ? 0 : side.method_10146() + 1);
        hash = this.getDisplayItemsHash(data, hash);
        return hash;
    }

    private int getItemBlockHash() {
        int hash = this.barrelItem.hashCode();
        hash = hash * 31 + (this.barrelWoodName != null ? this.barrelWoodName.hashCode() + 1 : 0);
        hash = hash * 31 + (this.barrelHasMainColor ? 1 : 0);
        hash = hash * 31 + (this.barrelHasAccentColor ? 1 : 0);
        hash = hash * 31 + (this.barrelIsPacked ? 1 : 0);
        hash = hash * 31 + (this.barrelShowsTier ? 1 : 0);
        hash = hash * 31 + (this.flatTop ? 1 : 0);
        hash = hash * 31 + this.barrelMaterials.hashCode();
        return hash;
    }

    protected int getInWorldBlockHash(class_2680 state, ModelData data, @Nullable class_1921 renderType) {
        int hash = state.method_26204().hashCode();
        hash = hash * 31 + (renderType == null ? 0 : renderType.hashCode());
        hash = hash * 31 + (data.has(WOOD_NAME) ? ((String)data.get(WOOD_NAME)).hashCode() + 1 : 0);
        hash = hash * 31 + (data.has(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.get(HAS_MAIN_COLOR)) ? 1 : 0);
        hash = hash * 31 + (data.has(HAS_ACCENT_COLOR) && Boolean.TRUE.equals(data.get(HAS_ACCENT_COLOR)) ? 1 : 0);
        hash = hash * 31 + (this.isPacked(data) ? 1 : 0);
        hash = hash * 31 + (this.showsLocked(data) ? 1 : 0);
        hash = hash * 31 + (this.showsTier(data) ? 1 : 0);
        hash = hash * 31 + (Boolean.TRUE.equals(state.method_11654((class_2769)BarrelBlock.FLAT_TOP)) ? 1 : 0);
        hash = hash * 31 + (data.has(MATERIALS) ? ((Map)data.get(MATERIALS)).hashCode() : 0);
        return hash;
    }

    private int getDisplayItemsHash(ModelData data, int hash) {
        if (data.has(DISPLAY_ITEMS)) {
            List displayItems = (List)data.get(DISPLAY_ITEMS);
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                hash = hash * 31 + this.getDisplayItemHash(displayItem);
            }
        }
        if (data.has(INACCESSIBLE_SLOTS)) {
            List inaccessibleSlots = (List)data.get(INACCESSIBLE_SLOTS);
            for (Integer inaccessibleSlot : inaccessibleSlots) {
                hash = hash * 31 + inaccessibleSlot;
            }
        }
        return hash;
    }

    private int getDisplayItemHash(RenderInfo.DisplayItem displayItem) {
        int hash = displayItem.getRotation();
        class_1799 stack = displayItem.getItem();
        hash = hash * 31 + class_1799.method_57355((class_1799)stack);
        hash = hash * 31 + displayItem.getSlotIndex();
        return hash;
    }

    private void addDisplayItemQuads(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand, List<class_777> ret, ModelData data, @Nullable class_1921 renderType) {
        class_2248 class_22482;
        if (state == null || side != null || !((class_22482 = state.method_26204()) instanceof BarrelBlock)) {
            return;
        }
        BarrelBlock barrelBlock = (BarrelBlock)class_22482;
        List displayItems = (List)data.get(DISPLAY_ITEMS);
        class_310 minecraft = class_310.method_1551();
        class_918 itemRenderer = minecraft.method_1480();
        if (displayItems != null && !displayItems.isEmpty()) {
            int index = 0;
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                class_1799 item = displayItem.getItem();
                if (barrelBlock.hasFixedIndexDisplayItems()) {
                    index = displayItem.getSlotIndex();
                }
                if (item.method_7960()) continue;
                class_1087 model = itemRenderer.method_4019(item, null, (class_1309)minecraft.field_1724, 0);
                if (!model.method_4713() && BarrelBakedModelBase.shouldRenderForRenderType(item, renderType, model)) {
                    int rotation = displayItem.getRotation();
                    for (class_2350 face : class_2350.values()) {
                        this.addRenderedItemSide(state, rand, ret, item, model, rotation, face, index, barrelBlock.getDisplayItemsCount(displayItems));
                    }
                    this.addRenderedItemSide(state, rand, ret, item, model, rotation, null, index, barrelBlock.getDisplayItemsCount(displayItems));
                }
                ++index;
            }
        }
        this.addInaccessibleSlotsQuads(state, rand, ret, data, barrelBlock, displayItems, minecraft);
    }

    private static boolean shouldRenderForRenderType(class_1799 item, @Nullable class_1921 renderType, class_1087 model) {
        class_638 clientLevel = class_310.method_1551().field_1687;
        if (renderType == null || clientLevel == null) {
            return true;
        }
        return renderType != class_1921.method_23583();
    }

    private void addInaccessibleSlotsQuads(class_2680 state, class_5819 rand, List<class_777> ret, ModelData data, BarrelBlock barrelBlock, @Nullable List<RenderInfo.DisplayItem> displayItems, class_310 minecraft) {
        List inaccessibleSlots = (List)data.get(INACCESSIBLE_SLOTS);
        if (displayItems != null && inaccessibleSlots != null) {
            class_1799 inaccessibleSlotStack = new class_1799((class_1935)ModItems.INACCESSIBLE_SLOT.get());
            class_1087 model = minecraft.method_1480().method_4019(inaccessibleSlotStack, null, (class_1309)minecraft.field_1724, 0);
            Iterator iterator = inaccessibleSlots.iterator();
            while (iterator.hasNext()) {
                int inaccessibleSlot = (Integer)iterator.next();
                if (model.method_4713()) continue;
                for (class_2350 face : class_2350.values()) {
                    this.addRenderedItemSide(state, rand, ret, inaccessibleSlotStack, model, 0, face, inaccessibleSlot, barrelBlock.getDisplayItemsCount(displayItems));
                }
                this.addRenderedItemSide(state, rand, ret, inaccessibleSlotStack, model, 0, null, inaccessibleSlot, barrelBlock.getDisplayItemsCount(displayItems));
            }
        }
    }

    private void addRenderedItemSide(class_2680 state, class_5819 rand, List<class_777> ret, class_1799 displayItem, class_1087 model, int rotation, @Nullable class_2350 dir, int displayItemIndex, int displayItemCount) {
        class_2350 class_23502;
        class_2248 class_22482;
        List<class_777> quads = model.method_4707(null, dir, rand);
        quads = QuadTransformers.process(MOVE_TO_CORNER, quads);
        quads = QuadTransformers.process(QuadTransformers.applying(this.toTransformation(model.method_4709().method_3503(class_811.field_4319))), quads);
        if (!model.method_4712()) {
            quads = displayItemCount == 1 ? QuadTransformers.process(SCALE_BIG_2D_ITEM, quads) : QuadTransformers.process(SCALE_SMALL_2D_ITEM, quads);
        } else if (displayItemCount > 1) {
            quads = QuadTransformers.process(SCALE_SMALL_3D_ITEM, quads);
        }
        if (rotation != 0) {
            quads = QuadTransformers.process(this.getDisplayRotation(rotation), quads);
        }
        if ((class_22482 = state.method_26204()) instanceof BarrelBlock) {
            BarrelBlock barrelBlock = (BarrelBlock)class_22482;
            class_23502 = barrelBlock.getFacing(state);
        } else {
            class_23502 = class_2350.field_11043;
        }
        class_2350 facing = class_23502;
        quads = this.rotateDisplayItemQuads(quads, state);
        if (model.method_4712()) {
            RenderContext.QuadTransform transformer = this.getDirectionMove(displayItem, model, state, facing, displayItemIndex, displayItemCount, displayItemCount == 1 ? 1.0f : 0.5f);
            quads = QuadTransformers.process(transformer, quads);
            this.recalculateDirections(quads);
        } else {
            quads = QuadTransformers.process(this.getDirectionMove(displayItem, model, state, facing, displayItemIndex, displayItemCount, 1.0f), quads);
            this.recalculateDirections(quads);
        }
        this.updateTintIndexes(quads, displayItemIndex);
        ret.addAll(quads);
    }

    private class_4590 toTransformation(class_804 transform) {
        if (transform.equals((Object)class_804.field_4284)) {
            return class_4590.method_22931();
        }
        return new class_4590(transform.field_4286, this.quatFromXYZ(transform.field_4287, true), transform.field_4285, null);
    }

    public Quaternionf quatFromXYZ(Vector3f xyz, boolean degrees) {
        return QuaternionHelper.quatFromXYZDegree(xyz);
    }

    protected abstract List<class_777> rotateDisplayItemQuads(List<class_777> var1, class_2680 var2);

    private void updateTintIndexes(List<class_777> quads, int displayItemIndex) {
        int offset = (displayItemIndex + 1) * 10;
        quads.forEach(quad -> {
            if (quad.field_4174 >= 0) {
                quad.field_4174 += offset;
            }
        });
    }

    private void recalculateDirections(List<class_777> quads) {
        quads.forEach(quad -> {
            quad.field_4173 = class_796.method_3467((int[])quad.method_3357());
        });
    }

    private RenderContext.QuadTransform getDirectionMove(class_1799 displayItem, class_1087 model, class_2680 state, class_2350 direction, int displayItemIndex, int displayItemCount, float itemScale) {
        boolean isFlatTop = (Boolean)state.method_11654((class_2769)BarrelBlock.FLAT_TOP);
        int hash = this.calculateDirectionMoveHash(state, displayItem, displayItemIndex, displayItemCount, isFlatTop);
        Cache directionCache = (Cache)DIRECTION_MOVES_3D_ITEMS.getUnchecked((Object)direction);
        RenderContext.QuadTransform transformer = (RenderContext.QuadTransform)directionCache.getIfPresent((Object)hash);
        if (transformer == null) {
            double offset = DisplayItemRenderer.getDisplayItemOffset(displayItem, model, itemScale);
            if (!isFlatTop) {
                offset -= 0.0625;
            }
            transformer = this.getDirectionMoveBackToSide(state, direction, (float)(0.5 + offset), displayItemIndex, displayItemCount);
            directionCache.put((Object)hash, (Object)transformer);
        }
        return transformer;
    }

    protected int calculateDirectionMoveHash(class_2680 state, class_1799 displayItem, int displayItemIndex, int displayItemCount, boolean isFlatTop) {
        int hashCode = class_1799.method_57355((class_1799)displayItem);
        hashCode = hashCode * 31 + displayItemIndex;
        hashCode = hashCode * 31 + displayItemCount;
        hashCode = hashCode * 31 + (isFlatTop ? 1 : 0);
        return hashCode;
    }

    private RenderContext.QuadTransform getDisplayRotation(int rotation) {
        return DISPLAY_ROTATIONS.computeIfAbsent(rotation, r -> QuadTransformers.applying(new class_4590(null, class_7833.field_40718.rotationDegrees((float)rotation), null, null)));
    }

    private void addTintableModelQuads(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand, List<class_777> ret, boolean hasMainColor, boolean hasAccentColor, Map<BarrelModelPart, class_1087> modelParts, @Nullable class_1921 renderType) {
        if (renderType != null && renderType != class_1921.method_23581()) {
            return;
        }
        if (hasAccentColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.TINTABLE_ACCENT, renderType);
        }
        if (hasMainColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, this.getMainPart(state), renderType);
        }
    }

    private BarrelModelPart getMainPart(@Nullable class_2680 state) {
        return this.rendersOpen() && state != null && Boolean.TRUE.equals(state.method_11654((class_2769)BarrelBlock.OPEN)) ? BarrelModelPart.TINTABLE_MAIN_OPEN : BarrelModelPart.TINTABLE_MAIN;
    }

    protected abstract boolean rendersOpen();

    private void addPartQuads(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand, List<class_777> ret, Map<BarrelModelPart, class_1087> modelParts, BarrelModelPart part, @Nullable class_1921 renderType) {
        if (renderType != null && renderType != class_1921.method_23581()) {
            return;
        }
        if (modelParts.containsKey((Object)part)) {
            ret.addAll(modelParts.getOrDefault((Object)part, class_310.method_1551().method_1554().method_4744()).method_4707(state, side, rand));
        }
    }

    private Map<BarrelModelPart, class_1087> getWoodModelParts(@Nullable String barrelWoodName, boolean requiresPartitionedModel) {
        if (requiresPartitionedModel && this.woodPartitionedModelParts.containsKey(barrelWoodName)) {
            return this.woodPartitionedModelParts.get(barrelWoodName);
        }
        if (this.woodModelParts.isEmpty()) {
            return Collections.emptyMap();
        }
        if (barrelWoodName == null || !this.woodModelParts.containsKey(barrelWoodName)) {
            return this.woodModelParts.values().iterator().next();
        }
        return this.woodModelParts.get(barrelWoodName);
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return true;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.getWoodModelParts(null, false).getOrDefault((Object)BarrelModelPart.BASE, class_310.method_1551().method_1554().method_4744()).method_4711();
    }

    public class_809 method_4709() {
        return ITEM_TRANSFORMS;
    }

    public class_1058 getParticleIcon(ModelData data) {
        Map materials;
        if (data.has(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.get(HAS_MAIN_COLOR))) {
            class_1087 model = this.getWoodModelParts(null, false).get((Object)BarrelModelPart.TINTABLE_MAIN);
            if (model instanceof CustomParticleIcon) {
                CustomParticleIcon dataModel = (CustomParticleIcon)model;
                return dataModel.getParticleIcon(data);
            }
            return model.method_4711();
        }
        if (data.has(MATERIALS) && (materials = (Map)data.get(MATERIALS)) != null) {
            for (BarrelMaterial barrelMaterial : PARTICLE_ICON_MATERIAL_PRIORITY) {
                if (!materials.containsKey((Object)barrelMaterial)) continue;
                class_2680 blockState = this.getDefaultBlockState((class_2960)materials.get((Object)barrelMaterial));
                return class_310.method_1551().method_1541().method_3349(blockState).method_4711();
            }
        }
        if (data.has(WOOD_NAME)) {
            String name = (String)data.get(WOOD_NAME);
            if (!this.woodModelParts.containsKey(name)) {
                return this.method_4711();
            }
            class_1087 model = this.getWoodModelParts(name, false).get((Object)BarrelModelPart.BASE);
            if (model instanceof CustomParticleIcon) {
                CustomParticleIcon dataModel = (CustomParticleIcon)model;
                return dataModel.getParticleIcon(data);
            }
            return model.method_4711();
        }
        return this.method_4711();
    }

    public ModelData getModelData(class_1920 world, class_2338 pos, class_2680 state, ModelData tileData) {
        return WorldHelper.getBlockEntity((class_1922)world, (class_2338)pos, BarrelBlockEntity.class).map(BarrelBakedModelBase::getModelDataFromBlockEntity).orElse(ModelData.EMPTY);
    }

    public static ModelData getModelDataFromBlockEntity(BarrelBlockEntity be) {
        Map<BarrelMaterial, class_2960> materials;
        ModelData.Builder builder = ModelData.builder();
        boolean hasMainColor = be.getStorageWrapper().hasMainColor();
        builder.with(HAS_MAIN_COLOR, (Object)hasMainColor);
        boolean hasAccentColor = be.getStorageWrapper().hasAccentColor();
        builder.with(HAS_ACCENT_COLOR, (Object)hasAccentColor);
        if (!be.hasFullyDynamicRenderer()) {
            builder.with(DISPLAY_ITEMS, (Object)be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getDisplayItems());
            builder.with(INACCESSIBLE_SLOTS, (Object)be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getInaccessibleSlots());
        }
        builder.with(IS_PACKED, (Object)be.isPacked());
        builder.with(SHOWS_LOCK, (Object)(be.isLocked() && be.shouldShowLock() ? 1 : 0));
        builder.with(SHOWS_TIER, (Object)be.shouldShowTier());
        Optional<class_4719> woodType = be.getWoodType();
        if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
            builder.with(WOOD_NAME, (Object)woodType.orElse(class_4719.field_21679).comp_1299());
        }
        if (!(materials = be.getMaterials()).isEmpty()) {
            builder.with(MATERIALS, materials);
        }
        return builder.build();
    }

    public class_806 method_4710() {
        return this.barrelItemOverrides;
    }

    private static class BarrelItemOverrides
    extends class_806 {
        private final BarrelBakedModelBase barrelBakedModel;
        @Nullable
        private final class_1087 flatTopModel;
        private final Cache<Integer, class_1087> resolvedModels = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

        public BarrelItemOverrides(BarrelBakedModelBase barrelBakedModel, @Nullable class_1087 flatTopModel) {
            this.barrelBakedModel = barrelBakedModel;
            this.flatTopModel = flatTopModel;
        }

        @Nullable
        public class_1087 method_3495(class_1087 model, class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            boolean flatTop = BarrelBlockItem.isFlatTop((SophisticatedDataComponentHolder)stack);
            if (this.flatTopModel != null && flatTop) {
                return this.flatTopModel.method_4710().method_3495(this.flatTopModel, stack, level, entity, seed);
            }
            boolean hasMainColor = StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)stack).isPresent();
            boolean hasAccentColor = StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)stack).isPresent();
            Map<BarrelMaterial, class_2960> materials = BarrelBlockItem.getMaterials(stack);
            String woodName = WoodStorageBlockItem.getWoodType((SophisticatedDataComponentHolder)stack).map(class_4719::comp_1299).orElse((String)(this.barrelBakedModel.barrelHasAccentColor && this.barrelBakedModel.barrelHasMainColor && materials.isEmpty() ? null : class_4719.field_21679.comp_1299()));
            boolean packed = WoodStorageBlockItem.isPacked(stack);
            boolean barrelShowsTier = StorageBlockItem.showsTier(stack);
            class_1792 item = stack.method_7909();
            int hash = Objects.hash(item, woodName, hasMainColor, hasAccentColor, packed, barrelShowsTier, flatTop, materials);
            Object resolvedModel = (class_1087)this.resolvedModels.getIfPresent((Object)hash);
            if (resolvedModel == null) {
                resolvedModel = new ResolvedModel(hasMainColor, hasAccentColor, woodName, packed, barrelShowsTier, materials, flatTop, item);
                this.resolvedModels.put((Object)hash, resolvedModel);
            }
            return resolvedModel;
        }

        private class ResolvedModel
        extends ForwardingBakedModel {
            private final boolean hasMainColor;
            private final boolean hasAccentColor;
            @Nullable
            private final String woodName;
            private final boolean packed;
            private final boolean barrelShowsTier;
            private final Map<BarrelMaterial, class_2960> materials;
            private final boolean flatTop;
            private final class_1792 item;

            public ResolvedModel(boolean hasMainColor, @Nullable boolean hasAccentColor, String woodName, boolean packed, boolean barrelShowsTier, Map<BarrelMaterial, class_2960> materials, boolean flatTop, class_1792 item) {
                this.wrapped = BarrelItemOverrides.this.barrelBakedModel;
                this.hasMainColor = hasMainColor;
                this.hasAccentColor = hasAccentColor;
                this.woodName = woodName;
                this.packed = packed;
                this.barrelShowsTier = barrelShowsTier;
                this.materials = materials;
                this.flatTop = flatTop;
                this.item = item;
            }

            public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
                this.setProperties();
                super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            }

            public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
                this.setProperties();
                super.emitItemQuads(stack, randomSupplier, context);
            }

            public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
                this.setProperties();
                return super.method_4707(state, side, rand);
            }

            private void setProperties() {
                BarrelItemOverrides.this.barrelBakedModel.barrelHasMainColor = this.hasMainColor;
                BarrelItemOverrides.this.barrelBakedModel.barrelHasAccentColor = this.hasAccentColor;
                BarrelItemOverrides.this.barrelBakedModel.barrelWoodName = this.woodName;
                BarrelItemOverrides.this.barrelBakedModel.barrelIsPacked = this.packed;
                BarrelItemOverrides.this.barrelBakedModel.barrelShowsTier = this.barrelShowsTier;
                BarrelItemOverrides.this.barrelBakedModel.barrelMaterials = this.materials;
                BarrelItemOverrides.this.barrelBakedModel.flatTop = this.flatTop;
                BarrelItemOverrides.this.barrelBakedModel.barrelItem = this.item;
            }
        }
    }
}

