/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import io.github.fabricators_of_create.porting_lib.core.util.Lazy;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5253;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.p3pp3rf1y.sophisticatedcore.extensions.component.SophisticatedDataComponentHolder;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.util.DecorationHelper;

public class DecorationTableBlockEntity
extends class_2586 {
    public static final int TOP_INNER_TRIM_SLOT = 0;
    public static final int TOP_TRIM_SLOT = 1;
    public static final int SIDE_TRIM_SLOT = 2;
    public static final int BOTTOM_TRIM_SLOT = 3;
    public static final int TOP_CORE_SLOT = 4;
    public static final int SIDE_CORE_SLOT = 5;
    public static final int BOTTOM_CORE_SLOT = 6;
    public static final int RED_DYE_SLOT = 0;
    public static final int GREEN_DYE_SLOT = 1;
    public static final int BLUE_DYE_SLOT = 2;
    public static final Lazy<Set<class_1792>> STORAGES_WIHOUT_TOP_INNER_TRIM = Lazy.of(() -> Set.of((class_1792)ModBlocks.BARREL_ITEM.get(), (class_1792)ModBlocks.COPPER_BARREL_ITEM.get(), (class_1792)ModBlocks.IRON_BARREL_ITEM.get(), (class_1792)ModBlocks.GOLD_BARREL_ITEM.get(), (class_1792)ModBlocks.DIAMOND_BARREL_ITEM.get(), (class_1792)ModBlocks.NETHERITE_BARREL_ITEM.get(), (class_1792)ModBlocks.LIMITED_BARREL_1_ITEM.get(), (class_1792)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), (class_1792)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (class_1792)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), (class_1792)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), (class_1792)ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get()));
    private static final Map<Predicate<class_1799>, IItemDecorator> ITEM_DECORATORS = new LinkedHashMap<Predicate<class_1799>, IItemDecorator>();
    private final Map<class_2960, Integer> remainingParts = new HashMap<class_2960, Integer>();
    private final ItemStackHandler decorativeBlocks = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            class_1792 class_17922 = resource.getItem();
            if (!(class_17922 instanceof class_1747)) return false;
            class_1747 blockItem = (class_1747)class_17922;
            if (resource.getItem() instanceof StorageBlockItem) return false;
            if (!class_2248.method_9614((class_265)blockItem.method_7711().method_9564().method_26218((class_1922)DecorationTableBlockEntity.this.field_11863, class_2338.field_10980))) return false;
            return true;
        }
    };
    private final ItemStackHandler dyes = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            return switch (slot) {
                case 0 -> resource.toStack().method_31573(ConventionalItemTags.RED_DYES);
                case 1 -> resource.toStack().method_31573(ConventionalItemTags.GREEN_DYES);
                case 2 -> resource.toStack().method_31573(ConventionalItemTags.BLUE_DYES);
                default -> false;
            };
        }
    };
    private class_1799 result = class_1799.field_8037;
    private final Map<Integer, Boolean> slotMaterialInheritance = new HashMap<Integer, Boolean>();
    private int accentColor = -1;
    private int mainColor = -1;
    private final Set<class_2960> missingDyes = new HashSet<class_2960>();
    private final ItemStackHandler storageBlock = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            return ITEM_DECORATORS.keySet().stream().anyMatch(predicate -> predicate.test(resource.toStack(count)));
        }
    };
    public static final IItemDecorator STORAGE_DECORATOR = new IItemDecorator(){

        @Override
        public boolean supportsMaterials(class_1799 input) {
            return input.method_7909() instanceof BarrelBlockItem && !DecorationTableBlockEntity.isTintedStorage(input);
        }

        @Override
        public boolean supportsTints(class_1799 input) {
            return !(input.method_7909() instanceof BarrelBlockItem) || BarrelBlockItem.getMaterials(input).isEmpty();
        }

        @Override
        public boolean supportsTopInnerTrim(class_1799 input) {
            return !((Set)STORAGES_WIHOUT_TOP_INNER_TRIM.get()).contains(input.method_7909());
        }

        @Override
        public class_1799 decorateWithMaterials(class_1799 input, Map<BarrelMaterial, class_2960> materialsToApply) {
            if (materialsToApply.isEmpty()) {
                return class_1799.field_8037;
            }
            EnumMap<BarrelMaterial, class_2960> materials = new EnumMap<BarrelMaterial, class_2960>(BarrelMaterial.class);
            materials.putAll(BarrelBlockItem.getMaterials(input));
            BarrelBlockItem.uncompactMaterials(materials);
            materials.putAll(materialsToApply);
            BarrelBlockItem.compactMaterials(materials);
            if (DecorationTableBlockEntity.allMaterialsMatch(materials, BarrelBlockItem.getMaterials(input))) {
                return class_1799.field_8037;
            }
            class_1799 result = input.method_46651(1);
            BarrelBlockItem.removeCoveredTints(result, materials);
            BarrelBlockItem.setMaterials(result, materials);
            return result;
        }

        @Override
        public TintDecorationResult decorateWithTints(class_1799 input, int mainColorToSet, int accentColorToSet) {
            class_1747 blockItem;
            if (DecorationTableBlockEntity.colorsTransparentOrSameAs(input, mainColorToSet, accentColorToSet)) {
                return TintDecorationResult.EMPTY;
            }
            class_1799 result = input.method_46651(1);
            class_1792 class_17922 = result.method_7909();
            if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922) instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)blockItem;
                if (mainColorToSet != -1) {
                    tintableBlockItem.setMainColor(result, mainColorToSet);
                }
                if (accentColorToSet != -1) {
                    tintableBlockItem.setAccentColor(result, accentColorToSet);
                }
            }
            return new TintDecorationResult(result, DecorationTableBlockEntity.calculateRequiredDyes(mainColorToSet, accentColorToSet, StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)input).orElse(-1), StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)input).orElse(-1)));
        }
    };

    public static void registerItemDecorator(Predicate<class_1799> itemMatcher, IItemDecorator itemDecorator) {
        ITEM_DECORATORS.put(itemMatcher, itemDecorator);
    }

    public void updateResultAndSetChanged() {
        this.updateResult();
        this.method_5431();
    }

    private void updateResult() {
        this.missingDyes.clear();
        this.result = class_1799.field_8037;
        class_1799 input = this.storageBlock.getStackInSlot(0);
        if (input.method_7960()) {
            return;
        }
        DecorationTableBlockEntity.getItemDecorator(input).ifPresent(itemDecorator -> {
            TintDecorationResult decorationResult = this.decorateItem((IItemDecorator)itemDecorator, input);
            this.result = decorationResult.result();
            this.missingDyes.addAll(this.calculateMissingDyes(decorationResult.requiredDyeParts()));
        });
    }

    private static Optional<IItemDecorator> getItemDecorator(class_1799 input) {
        return ITEM_DECORATORS.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(input)).findFirst().map(Map.Entry::getValue);
    }

    private TintDecorationResult decorateItem(IItemDecorator itemDecorator, class_1799 input) {
        Map<BarrelMaterial, class_2960> materialsToApply;
        if (itemDecorator.supportsMaterials(input) && !(materialsToApply = this.getMaterialsToApply(itemDecorator.supportsTopInnerTrim(input))).isEmpty()) {
            return new TintDecorationResult(itemDecorator.decorateWithMaterials(input, materialsToApply), Collections.emptyMap());
        }
        if (itemDecorator.supportsTints(input)) {
            return itemDecorator.decorateWithTints(input, this.mainColor, this.accentColor);
        }
        return TintDecorationResult.EMPTY;
    }

    public boolean hasMaterials() {
        return !InventoryHelper.isEmpty((SlottedStackStorage)this.decorativeBlocks);
    }

    public List<class_1799> getDecoratedPreviewStacks() {
        class_1799 input = this.storageBlock.getStackInSlot(0);
        return DecorationTableBlockEntity.getItemDecorator(input).map(itemDecorator -> {
            ArrayList previewStacks = new ArrayList();
            itemDecorator.getPreviewStackInputs(input, this.hasMaterials()).forEach(stack -> DecorationTableBlockEntity.getItemDecorator(stack).ifPresent(inputItemDecorator -> {
                TintDecorationResult decorationResult = this.decorateItem((IItemDecorator)inputItemDecorator, (class_1799)stack);
                if (!decorationResult.result().method_7960()) {
                    previewStacks.add(decorationResult.result());
                }
            }));
            return previewStacks;
        }).orElse(Collections.emptyList());
    }

    public static boolean allMaterialsMatch(Map<BarrelMaterial, class_2960> newMaterials, Map<BarrelMaterial, class_2960> currentMaterials) {
        if (newMaterials.size() != currentMaterials.size()) {
            return false;
        }
        for (Map.Entry<BarrelMaterial, class_2960> entry : newMaterials.entrySet()) {
            if (entry.getValue().equals((Object)currentMaterials.get((Object)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private Set<class_2960> calculateMissingDyes(Map<class_6862<class_1792>, Integer> requiredDyeParts) {
        HashSet<class_2960> missingDyes = new HashSet<class_2960>();
        if (!(this.dyes.getStackInSlot(0).method_7960() || this.dyes.getStackInSlot(1).method_7960() || this.dyes.getStackInSlot(2).method_7960())) {
            return missingDyes;
        }
        Map<class_2960, Integer> partsNeeded = requiredDyeParts.entrySet().stream().map(entry -> Map.entry(((class_6862)entry.getKey()).comp_327(), (Integer)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<class_2960, Integer> entry2 : partsNeeded.entrySet()) {
            if (entry2.getKey().equals((Object)ConventionalItemTags.RED_DYES.comp_327()) && this.dyes.getStackInSlot(0).method_7960()) {
                missingDyes.add(entry2.getKey());
                continue;
            }
            if (entry2.getKey().equals((Object)ConventionalItemTags.GREEN_DYES.comp_327()) && this.dyes.getStackInSlot(1).method_7960()) {
                missingDyes.add(entry2.getKey());
                continue;
            }
            if (!entry2.getKey().equals((Object)ConventionalItemTags.BLUE_DYES.comp_327()) || !this.dyes.getStackInSlot(2).method_7960()) continue;
            missingDyes.add(entry2.getKey());
        }
        return missingDyes;
    }

    private static Map<class_6862<class_1792>, Integer> calculateRequiredDyes(int mainColorToSet, int accentColorToSet, int currentMainColor, int currentAccentColor) {
        return DecorationHelper.getDyePartsNeeded(mainColorToSet, accentColorToSet, currentMainColor, currentAccentColor);
    }

    public Set<class_2960> getMissingDyes() {
        return this.missingDyes;
    }

    private void setMaterialsFromDecorativeBlocks(Map<BarrelMaterial, class_2960> materials, boolean supportsInnerTrim) {
        class_2960 topInnerTrimMaterialLocation = this.setMaterialFromBlock(0, null, materials, BarrelMaterial.TOP_INNER_TRIM, supportsInnerTrim);
        class_2960 topTrimMaterialLocation = this.setMaterialFromBlock(1, topInnerTrimMaterialLocation, materials, BarrelMaterial.TOP_TRIM, true);
        class_2960 sideTrimMaterialLocation = this.setMaterialFromBlock(2, topTrimMaterialLocation, materials, BarrelMaterial.SIDE_TRIM, true);
        this.setMaterialFromBlock(3, sideTrimMaterialLocation, materials, BarrelMaterial.BOTTOM_TRIM, true);
        class_2960 topMaterialLocation = this.setMaterialFromBlock(4, topTrimMaterialLocation, materials, BarrelMaterial.TOP, true);
        class_2960 sideMaterialLocation = this.setMaterialFromBlock(5, topMaterialLocation, materials, BarrelMaterial.SIDE, true);
        this.setMaterialFromBlock(6, sideMaterialLocation, materials, BarrelMaterial.BOTTOM, true);
    }

    @Nullable
    private class_2960 setMaterialFromBlock(int slotIndex, @Nullable class_2960 defaultMaterialLocation, Map<BarrelMaterial, class_2960> materials, BarrelMaterial material, boolean addToMaterials) {
        class_1799 decorativeBlock = this.decorativeBlocks.getStackInSlot(slotIndex);
        class_2960 materialLocation = DecorationHelper.getMaterialLocation(decorativeBlock).orElse((class_2960)(this.isSlotMaterialInherited(slotIndex) ? defaultMaterialLocation : null));
        if (materialLocation != null) {
            if (addToMaterials) {
                materials.put(material, materialLocation);
            }
            return materialLocation;
        }
        return null;
    }

    public DecorationTableBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlocks.DECORATION_TABLE_BLOCK_ENTITY_TYPE.get(), pos, blockState);
    }

    public ItemStackHandler getDecorativeBlocks() {
        return this.decorativeBlocks;
    }

    public ItemStackHandler getDyes() {
        return this.dyes;
    }

    public ItemStackHandler getStorageBlock() {
        return this.storageBlock;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public class_1799 extractResult(int count) {
        class_1799 result = this.getResult();
        if (result.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 extracted = result.method_7972();
        extracted.method_7939(count);
        if (count >= result.method_7947()) {
            this.result = class_1799.field_8037;
        } else {
            result.method_7934(count);
        }
        this.method_5431();
        return extracted;
    }

    public boolean isSlotMaterialInherited(int slot) {
        return this.slotMaterialInheritance.getOrDefault(slot, true);
    }

    public class_1799 getInheritedItem(int childSlot) {
        while (this.isSlotMaterialInherited(childSlot)) {
            int parentSlot = this.getSlotInheritedFrom(childSlot);
            if (parentSlot == -1) {
                return class_1799.field_8037;
            }
            if (!this.decorativeBlocks.getStackInSlot(parentSlot).method_7960()) {
                return this.decorativeBlocks.getStackInSlot(parentSlot);
            }
            childSlot = parentSlot;
        }
        return class_1799.field_8037;
    }

    public int getSlotInheritedFrom(int slot) {
        return switch (slot) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            case 4 -> 1;
            case 5 -> 4;
            case 6 -> 5;
            default -> -1;
        };
    }

    public void setSlotMaterialInheritance(int slot, boolean value) {
        if (value) {
            this.slotMaterialInheritance.remove(slot);
        } else {
            this.slotMaterialInheritance.put(slot, false);
        }
        this.updateResultAndSetChanged();
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        this.saveData(tag, registries);
        return tag;
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.decorativeBlocks.deserializeNBT(registries, tag.method_10562("decorativeBlocks"));
        this.dyes.deserializeNBT(registries, tag.method_10562("dyes"));
        this.storageBlock.deserializeNBT(registries, tag.method_10562("storageBlock"));
        this.result = class_1799.method_57360((class_7225.class_7874)registries, (class_2520)tag.method_10562("result")).orElse(class_1799.field_8037);
        this.slotMaterialInheritance.clear();
        class_2499 inheritance = tag.method_10554("slotMaterialInheritance", 10);
        for (int i = 0; i < inheritance.size(); ++i) {
            class_2487 slotTag = inheritance.method_10602(i);
            this.slotMaterialInheritance.put(slotTag.method_10550("slot"), slotTag.method_10577("value"));
        }
        this.remainingParts.clear();
        class_2499 remainingPartsTag = tag.method_10554("remainingParts", 10);
        for (int i = 0; i < remainingPartsTag.size(); ++i) {
            class_2487 partTag = remainingPartsTag.method_10602(i);
            class_2960 key = class_2960.method_12829((String)partTag.method_10558("key"));
            if (key == null) continue;
            this.remainingParts.put(key, partTag.method_10550("value"));
        }
        this.mainColor = tag.method_10550("mainColor");
        this.accentColor = tag.method_10550("accentColor");
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        this.saveData(tag, registries);
    }

    private void saveData(class_2487 tag, class_7225.class_7874 registries) {
        tag.method_10566("decorativeBlocks", (class_2520)this.decorativeBlocks.serializeNBT(registries));
        tag.method_10566("dyes", (class_2520)this.dyes.serializeNBT(registries));
        tag.method_10566("storageBlock", (class_2520)this.storageBlock.serializeNBT(registries));
        if (!this.result.method_7960()) {
            tag.method_10566("result", this.result.method_57358(registries));
        }
        class_2499 inheritance = new class_2499();
        this.slotMaterialInheritance.forEach((slot, value) -> {
            class_2487 slotTag = new class_2487();
            slotTag.method_10569("slot", slot.intValue());
            slotTag.method_10556("value", value.booleanValue());
            inheritance.add((Object)slotTag);
        });
        tag.method_10566("slotMaterialInheritance", (class_2520)inheritance);
        class_2499 remainingPartsTag = new class_2499();
        this.remainingParts.forEach((key, value) -> {
            class_2487 partTag = new class_2487();
            partTag.method_10582("key", key.toString());
            partTag.method_10569("value", value.intValue());
            remainingPartsTag.add((Object)partTag);
        });
        tag.method_10566("remainingParts", (class_2520)remainingPartsTag);
        tag.method_10569("mainColor", this.mainColor);
        tag.method_10569("accentColor", this.accentColor);
    }

    public void consumeIngredientsOnCraft() {
        class_1799 input = this.storageBlock.getStackInSlot(0);
        DecorationTableBlockEntity.getItemDecorator(input).ifPresent(itemDecorator -> {
            if (!itemDecorator.consumesIngredientsOnCraft()) {
                return;
            }
            boolean emptyDecorativeBlocks = InventoryHelper.isEmpty((SlottedStackStorage)this.decorativeBlocks);
            if ((emptyDecorativeBlocks || !itemDecorator.supportsMaterials(input)) && itemDecorator.supportsTints(input)) {
                DecorationHelper.consumeDyes(this.mainColor, this.accentColor, this.remainingParts, List.of(this.dyes), StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)input).orElse(-1), StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)input).orElse(-1), false);
            } else if (!emptyDecorativeBlocks && itemDecorator.supportsMaterials(input)) {
                Map<BarrelMaterial, class_2960> originalMaterials = BarrelBlockItem.getUncompactedMaterials(input);
                DecorationHelper.consumeMaterials(this.remainingParts, List.of(this.decorativeBlocks), originalMaterials, this.getMaterialsToApply(!((Set)STORAGES_WIHOUT_TOP_INNER_TRIM.get()).contains(input.method_7909())), false);
            }
            this.method_5431();
            WorldHelper.notifyBlockUpdate((class_2586)this);
        });
    }

    public Map<class_2960, Integer> getPartsNeeded() {
        HashMap<class_2960, Integer> partsNeeded = new HashMap<class_2960, Integer>();
        class_1799 storageStack = this.storageBlock.getStackInSlot(0);
        if (InventoryHelper.isEmpty((SlottedStackStorage)this.decorativeBlocks) || !(storageStack.method_7909() instanceof BarrelBlockItem)) {
            DecorationHelper.getDyePartsNeeded(this.mainColor, this.accentColor, StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)storageStack).orElse(-1), StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)storageStack).orElse(-1)).forEach((tag, parts) -> partsNeeded.put(tag.comp_327(), (Integer)parts));
        } else {
            partsNeeded.putAll(DecorationHelper.getMaterialPartsNeeded(BarrelBlockItem.getUncompactedMaterials(storageStack), this.getMaterialsToApply(!((Set)STORAGES_WIHOUT_TOP_INNER_TRIM.get()).contains(storageStack.method_7909()))));
        }
        return partsNeeded;
    }

    private Map<BarrelMaterial, class_2960> getMaterialsToApply(boolean supportsInnerTrim) {
        EnumMap<BarrelMaterial, class_2960> materialsToApply = new EnumMap<BarrelMaterial, class_2960>(BarrelMaterial.class);
        this.setMaterialsFromDecorativeBlocks(materialsToApply, supportsInnerTrim);
        return materialsToApply;
    }

    public int getMainColor() {
        return this.mainColor;
    }

    public void setMainColor(int mainColor) {
        this.mainColor = mainColor;
        this.updateResultAndSetChanged();
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
        this.updateResultAndSetChanged();
    }

    public Map<class_2960, Integer> getPartsStored() {
        return this.remainingParts;
    }

    public void dropContents() {
        InventoryHelper.dropItems((SlottedStackStorage)this.decorativeBlocks, (class_1937)this.field_11863, (class_2338)this.field_11867);
        InventoryHelper.dropItems((SlottedStackStorage)this.dyes, (class_1937)this.field_11863, (class_2338)this.field_11867);
        InventoryHelper.dropItems((SlottedStackStorage)this.storageBlock, (class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    private static boolean isTintedStorage(class_1799 storage) {
        return StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)storage).isPresent() || StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)storage).isPresent();
    }

    private static boolean colorsTransparentOrSameAs(class_1799 storage, int mainColorToSet, int accentColorToSet) {
        return !(mainColorToSet != -1 && mainColorToSet != StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)storage).orElse(-1) || accentColorToSet != -1 && accentColorToSet != StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)storage).orElse(-1));
    }

    static {
        ITEM_DECORATORS.put(stack -> stack.method_7909() instanceof StorageBlockItem, STORAGE_DECORATOR);
        ITEM_DECORATORS.put(stack -> stack.method_7909() instanceof PaintbrushItem, new IItemDecorator(){

            @Override
            public boolean consumesIngredientsOnCraft() {
                return false;
            }

            @Override
            public boolean supportsMaterials(class_1799 input) {
                return true;
            }

            @Override
            public boolean supportsTints(class_1799 input) {
                return true;
            }

            @Override
            public boolean supportsTopInnerTrim(class_1799 input) {
                return true;
            }

            @Override
            public class_1799 decorateWithMaterials(class_1799 input, Map<BarrelMaterial, class_2960> materialsToApply) {
                BarrelBlockItem.compactMaterials(materialsToApply);
                if (DecorationTableBlockEntity.allMaterialsMatch(materialsToApply, BarrelBlockItem.getMaterials(input))) {
                    return class_1799.field_8037;
                }
                class_1799 result = input.method_46651(1);
                PaintbrushItem.setBarrelMaterials(result, materialsToApply);
                return result;
            }

            @Override
            public TintDecorationResult decorateWithTints(class_1799 input, int mainColorToSet, int accentColorToSet) {
                if (mainColorToSet == -1 && accentColorToSet == -1 || mainColorToSet == PaintbrushItem.getMainColor(input) && accentColorToSet == PaintbrushItem.getAccentColor(input)) {
                    return TintDecorationResult.EMPTY;
                }
                class_1799 result = input.method_46651(1);
                if (mainColorToSet != -1) {
                    PaintbrushItem.setMainColor(result, mainColorToSet);
                }
                if (accentColorToSet != -1) {
                    PaintbrushItem.setAccentColor(result, accentColorToSet);
                }
                return new TintDecorationResult(result, Collections.emptyMap());
            }

            @Override
            public List<class_1799> getPreviewStackInputs(class_1799 input, boolean materialsInCraftingSlots) {
                if (materialsInCraftingSlots) {
                    return List.of(new class_1799((class_1935)ModBlocks.LIMITED_BARREL_3_ITEM.get()));
                }
                return List.of(new class_1799((class_1935)ModBlocks.LIMITED_BARREL_3_ITEM.get()), new class_1799((class_1935)ModBlocks.CHEST_ITEM.get()), new class_1799((class_1935)ModBlocks.SHULKER_BOX_ITEM.get()));
            }
        });
        ITEM_DECORATORS.put(stack -> stack.method_31573(class_3489.field_48803), new IItemDecorator(){

            @Override
            public boolean supportsMaterials(class_1799 input) {
                return false;
            }

            @Override
            public boolean supportsTints(class_1799 input) {
                return true;
            }

            @Override
            public boolean supportsTopInnerTrim(class_1799 input) {
                return false;
            }

            @Override
            public class_1799 decorateWithMaterials(class_1799 input, Map<BarrelMaterial, class_2960> materialsToApply) {
                return class_1799.field_8037;
            }

            @Override
            public TintDecorationResult decorateWithTints(class_1799 input, int mainColorToSet, int accentColorToSet) {
                int currentColor = class_9282.method_57470((class_1799)input, (int)-1);
                if (mainColorToSet == -1 || currentColor == mainColorToSet) {
                    return TintDecorationResult.EMPTY;
                }
                class_1799 result = input.method_46651(1);
                result.method_57379(class_9334.field_49644, (Object)new class_9282(class_5253.class_5254.method_27764((int)0, (int)class_5253.class_5254.method_27765((int)mainColorToSet), (int)class_5253.class_5254.method_27766((int)mainColorToSet), (int)class_5253.class_5254.method_27767((int)mainColorToSet)), true));
                return new TintDecorationResult(result, DecorationHelper.getDyePartsNeeded(mainColorToSet, -1, currentColor, -1, 24, 0));
            }
        });
    }

    public static interface IItemDecorator {
        default public boolean consumesIngredientsOnCraft() {
            return true;
        }

        public boolean supportsMaterials(class_1799 var1);

        public boolean supportsTints(class_1799 var1);

        public boolean supportsTopInnerTrim(class_1799 var1);

        public class_1799 decorateWithMaterials(class_1799 var1, Map<BarrelMaterial, class_2960> var2);

        public TintDecorationResult decorateWithTints(class_1799 var1, int var2, int var3);

        default public List<class_1799> getPreviewStackInputs(class_1799 input, boolean materialsInCraftingSlots) {
            return List.of(input);
        }
    }

    public record TintDecorationResult(class_1799 result, Map<class_6862<class_1792>, Integer> requiredDyeParts) {
        public static final TintDecorationResult EMPTY = new TintDecorationResult(class_1799.field_8037, Collections.emptyMap());
    }
}

