/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5561;
import net.minecraft.class_7225;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.DynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.IDynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class BarrelBlockEntity
extends WoodStorageBlockEntity
implements IMaterialHolder {
    private static final String MATERIALS_TAG = "materials";
    public static final String STORAGE_TYPE = "barrel";
    private Map<BarrelMaterial, class_2960> materials = new EnumMap<BarrelMaterial, class_2960>(BarrelMaterial.class);
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 level, class_2338 pos, class_2680 state) {
            BarrelBlockEntity.this.playSound(state, class_3417.field_17604);
            BarrelBlockEntity.this.updateOpenBlockState(state, true);
        }

        protected void method_31683(class_1937 level, class_2338 pos, class_2680 state) {
            BarrelBlockEntity.this.playSound(state, class_3417.field_17603);
            BarrelBlockEntity.this.updateOpenBlockState(state, false);
        }

        protected void method_31682(class_1937 level, class_2338 pos, class_2680 state, int previousOpenerCount, int newOpenerCount) {
        }

        protected boolean method_31679(class_1657 player) {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof StorageContainerMenu) {
                StorageContainerMenu storageContainerMenu = (StorageContainerMenu)class_17032;
                return storageContainerMenu.getStorageBlockEntity() == BarrelBlockEntity.this;
            }
            return false;
        }
    };
    private IDynamicRenderTracker dynamicRenderTracker = IDynamicRenderTracker.NOOP;

    @Override
    protected class_5561 getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    protected BarrelBlockEntity(class_2338 pos, class_2680 state, class_2591<? extends BarrelBlockEntity> blockEntityType) {
        super(pos, state, blockEntityType);
        this.getStorageWrapper().getRenderInfo().setChangeListener(ri -> {
            this.dynamicRenderTracker.onRenderInfoUpdated((RenderInfo)ri);
            WorldHelper.notifyBlockUpdate((class_2586)this);
        });
    }

    public void setDynamicRenderTracker(IDynamicRenderTracker dynamicRenderTracker) {
        this.dynamicRenderTracker = dynamicRenderTracker;
    }

    public BarrelBlockEntity(class_2338 pos, class_2680 state) {
        this(pos, state, (class_2591<? extends BarrelBlockEntity>)ModBlocks.BARREL_BLOCK_ENTITY_TYPE.get());
    }

    void updateOpenBlockState(class_2680 state, boolean open) {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level.field_9236) {
            this.dynamicRenderTracker = new DynamicRenderTracker(this);
        }
    }

    public boolean hasDynamicRenderer() {
        return this.dynamicRenderTracker.isDynamicRenderer();
    }

    public boolean hasFullyDynamicRenderer() {
        return this.dynamicRenderTracker.isFullyDynamicRenderer();
    }

    @Override
    public void toggleLock() {
        this.setUpdateBlockRender();
        super.toggleLock();
    }

    @Override
    protected void saveSynchronizedData(class_2487 tag) {
        super.saveSynchronizedData(tag);
        NBTHelper.putMap((class_2487)tag, (String)MATERIALS_TAG, this.materials, BarrelMaterial::method_15434, resourceLocation -> class_2519.method_23256((String)resourceLocation.toString()));
    }

    @Override
    public void loadSynchronizedData(class_2487 tag, class_7225.class_7874 registries) {
        super.loadSynchronizedData(tag, registries);
        this.materials = NBTHelper.getMap((class_2487)tag, (String)MATERIALS_TAG, BarrelMaterial::fromName, (bm, t) -> Optional.of(class_2960.method_60654((String)t.method_10714()))).orElse(Map.of());
    }

    @Override
    public void setMaterials(Map<BarrelMaterial, class_2960> materials) {
        this.materials = materials;
        this.method_5431();
    }

    @Override
    public Map<BarrelMaterial, class_2960> getMaterials() {
        return this.materials;
    }

    @Override
    public boolean canHoldMaterials() {
        return true;
    }
}

