/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6880;
import net.minecraft.class_9793;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTab;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.RepeatMode;

public abstract class JukeboxUpgradeTab
extends UpgradeSettingsTab<JukeboxUpgradeContainer> {
    private static final TextureBlitData PLAY_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(16, 64), Dimension.SQUARE_16);
    private static final ButtonDefinition PLAY = new ButtonDefinition(Dimension.SQUARE_18, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, PLAY_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("play"))});
    private static final TextureBlitData STOP_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(0, 64), Dimension.SQUARE_16);
    private static final ButtonDefinition STOP = new ButtonDefinition(Dimension.SQUARE_18, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, STOP_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("stop"))});
    private static final TextureBlitData SHUFFLE_ON_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(96, 80), Dimension.SQUARE_16);
    private static final TextureBlitData SHUFFLE_OFF_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(112, 80), Dimension.SQUARE_16);
    private static final ButtonDefinition.Toggle<Boolean> SHUFFLE = new ButtonDefinition.Toggle<Boolean>(Dimension.SQUARE_18, GuiHelper.DEFAULT_BUTTON_BACKGROUND, Map.of(true, new ToggleButton.StateData(SHUFFLE_ON_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("shuffle_on"))}), false, new ToggleButton.StateData(SHUFFLE_OFF_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("shuffle_off"))})), GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND);
    private static final TextureBlitData REPEAT_ALL_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(128, 80), Dimension.SQUARE_16);
    private static final TextureBlitData REPEAT_ONE_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(144, 80), Dimension.SQUARE_16);
    private static final TextureBlitData NO_REPEAT_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(160, 80), Dimension.SQUARE_16);
    private static final ButtonDefinition.Toggle<RepeatMode> REPEAT = new ButtonDefinition.Toggle<RepeatMode>(Dimension.SQUARE_18, GuiHelper.DEFAULT_BUTTON_BACKGROUND, Map.of(RepeatMode.ALL, new ToggleButton.StateData(REPEAT_ALL_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("repeat_all"))}), RepeatMode.ONE, new ToggleButton.StateData(REPEAT_ONE_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("repeat_one"))}), RepeatMode.NO, new ToggleButton.StateData(NO_REPEAT_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("no_repeat"))})), GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND);
    private static final TextureBlitData PREVIOUS_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(48, 96), Dimension.SQUARE_16);
    private static final ButtonDefinition PREVIOUS = new ButtonDefinition(Dimension.SQUARE_18, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, PREVIOUS_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("previous_disc"))});
    private static final TextureBlitData NEXT_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(32, 96), Dimension.SQUARE_16);
    private static final ButtonDefinition NEXT = new ButtonDefinition(Dimension.SQUARE_18, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, NEXT_FOREGROUND, new class_2561[]{class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("next_disc"))});
    private static final int BUTTON_PADDING = 3;
    public static final int TOP_Y = 24;
    private final int slotsInRow;

    public JukeboxUpgradeTab(JukeboxUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen, int slotsInRow, class_2561 tabLabel, class_2561 closedTooltip) {
        super(upgradeContainer, position, screen, tabLabel, closedTooltip);
        this.slotsInRow = slotsInRow;
    }

    @Override
    protected void renderBg(class_332 guiGraphics, class_310 minecraft, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, minecraft, mouseX, mouseY);
        if (((JukeboxUpgradeContainer)this.getContainer()).isOpen()) {
            GuiHelper.renderSlotsBackground(guiGraphics, this.x + 3, this.y + 24, this.slotsInRow, ((JukeboxUpgradeContainer)this.getContainer()).getSlots().size() / this.slotsInRow, ((JukeboxUpgradeContainer)this.getContainer()).getSlots().size() % this.slotsInRow);
        }
    }

    @Override
    protected void moveSlotsToTab() {
        int slotIndex = 0;
        for (class_1735 discSlot : ((JukeboxUpgradeContainer)this.getContainer()).getSlots()) {
            discSlot.field_7873 = this.x - ((StorageScreenBase)this.screen).sophisticatedCore_getGuiLeft() + 4 + slotIndex % this.slotsInRow * 18;
            discSlot.field_7872 = this.y - ((StorageScreenBase)this.screen).sophisticatedCore_getGuiTop() + 24 + 1 + slotIndex / this.slotsInRow * 18;
            ++slotIndex;
        }
    }

    protected int getBottomSlotY() {
        return 24 + ((JukeboxUpgradeContainer)this.getContainer()).getSlots().size() / this.slotsInRow * 18 + (((JukeboxUpgradeContainer)this.getContainer()).getSlots().size() % this.slotsInRow > 0 ? 18 : 0);
    }

    public static class Advanced
    extends JukeboxUpgradeTab {
        public Advanced(JukeboxUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen, int slotsInRow) {
            super(upgradeContainer, position, screen, slotsInRow, (class_2561)TranslationHelper.INSTANCE.translUpgrade("advanced_jukebox", new Object[0]), TranslationHelper.INSTANCE.translUpgradeTooltip("advanced_jukebox"));
            int bottomSlotY = this.getBottomSlotY();
            this.addHideableChild(new Button(new Position(this.x + 3, this.y + bottomSlotY + 3), PREVIOUS, button -> {
                if (button == 0) {
                    ((JukeboxUpgradeContainer)this.getContainer()).previous();
                }
            }));
            this.addHideableChild(new Button(new Position(this.x + 21, this.y + bottomSlotY + 3), STOP, button -> {
                if (button == 0) {
                    ((JukeboxUpgradeContainer)this.getContainer()).stop();
                }
            }));
            this.addHideableChild(new Button(new Position(this.x + 39, this.y + bottomSlotY + 3), PLAY, button -> {
                if (button == 0) {
                    ((JukeboxUpgradeContainer)this.getContainer()).play();
                }
            }));
            this.addHideableChild(new Button(new Position(this.x + 57, this.y + bottomSlotY + 3), NEXT, button -> {
                if (button == 0) {
                    ((JukeboxUpgradeContainer)this.getContainer()).next();
                }
            }));
            this.addHideableChild(new ToggleButton<Boolean>(new Position(this.x + 12, this.y + bottomSlotY + 3 + 20), SHUFFLE, button -> {
                if (button == 0) {
                    ((JukeboxUpgradeContainer)this.getContainer()).toggleShuffle();
                }
            }, () -> ((JukeboxUpgradeContainer)this.getContainer()).isShuffleEnabled()));
            this.addHideableChild(new ToggleButton<RepeatMode>(new Position(this.x + 48, this.y + bottomSlotY + 3 + 20), REPEAT, button -> {
                if (button == 0) {
                    ((JukeboxUpgradeContainer)this.getContainer()).toggleRepeat();
                }
            }, () -> ((JukeboxUpgradeContainer)this.getContainer()).getRepeatMode()));
        }

        @Override
        protected void renderBg(class_332 guiGraphics, class_310 minecraft, int mouseX, int mouseY) {
            super.renderBg(guiGraphics, minecraft, mouseX, mouseY);
            ((JukeboxUpgradeContainer)this.getContainer()).getDiscSlotActive().ifPresent(slot -> this.renderPlaytimeOverLay(guiGraphics, 0x5500CC00, ((StorageScreenBase)this.screen).getLeftX() + slot.field_7873, ((StorageScreenBase)this.screen).getTopY() + slot.field_7872, 16, 16));
        }

        private float getPlaybackRemainingProgress() {
            long finishTime = ((JukeboxUpgradeContainer)this.getContainer()).getDiscFinishTime();
            int remaining = (int)(finishTime - this.minecraft.field_1687.method_8510());
            Optional<class_6880<class_9793>> song = ((JukeboxUpgradeContainer)this.getContainer()).getJukeboxSong((class_1937)this.minecraft.field_1687);
            return song.map(jukeboxSongHolder -> Float.valueOf((float)remaining / (float)((class_9793)jukeboxSongHolder.comp_349()).method_60750())).orElse(Float.valueOf(0.0f)).floatValue();
        }

        private void renderPlaytimeOverLay(class_332 guiGraphics, int slotColor, int xPos, int yPos, int width, int height) {
            float remainingProgress = this.getPlaybackRemainingProgress();
            if (remainingProgress <= 0.0f) {
                return;
            }
            int progressOver = width - (int)((float)width * remainingProgress);
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            guiGraphics.method_33284(xPos + progressOver, yPos, xPos + width, yPos + height, 0, slotColor, slotColor);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    public static class Basic
    extends JukeboxUpgradeTab {
        public Basic(JukeboxUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen) {
            super(upgradeContainer, position, screen, 4, (class_2561)TranslationHelper.INSTANCE.translUpgrade("jukebox", new Object[0]), TranslationHelper.INSTANCE.translUpgradeTooltip("jukebox"));
            int bottomSlotY = this.getBottomSlotY();
            this.addHideableChild(new Button(new Position(this.x + 3, this.y + bottomSlotY + 3), STOP, button -> {
                if (button == 0) {
                    ((JukeboxUpgradeContainer)this.getContainer()).stop();
                }
            }));
            this.addHideableChild(new Button(new Position(this.x + 21, this.y + bottomSlotY + 3), PLAY, button -> {
                if (button == 0) {
                    ((JukeboxUpgradeContainer)this.getContainer()).play();
                }
            }));
        }
    }
}

