/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.audioplayer;

import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.StaticAudioPlayer;
import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;

public class SCPlayerManager {
    private final Map<UUID, PlayerReference> players = new ConcurrentHashMap<UUID, PlayerReference>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "SC-AudioPlayerThread");
        thread.setDaemon(true);
        return thread;
    });
    private static SCPlayerManager instance;

    @Nullable
    public UUID playLocational(VoicechatServerApi api, class_3218 level, class_243 pos, UUID sound, @Nullable class_3222 p, float distance, @Nullable String category, int maxLengthSeconds) {
        return this.playLocational(api, level, pos, sound, p, distance, category, maxLengthSeconds, false);
    }

    @Nullable
    public UUID playLocational(VoicechatServerApi api, class_3218 level, class_243 pos, UUID sound, @Nullable class_3222 p, float distance, @Nullable String category, int maxLengthSeconds, boolean byCommand) {
        UUID channelID = UUID.randomUUID();
        LocationalAudioChannel channel = api.createLocationalAudioChannel(channelID, api.fromServerLevel((Object)level), api.createPosition(pos.field_1352, pos.field_1351, pos.field_1350));
        if (channel == null) {
            return null;
        }
        if (category != null) {
            channel.setCategory(category);
        }
        channel.setDistance(distance);
        api.getPlayersInRange(api.fromServerLevel((Object)level), channel.getLocation(), (double)(distance + 1.0f), serverPlayer -> {
            VoicechatConnection connection = api.getConnectionOf(serverPlayer);
            if (connection != null) {
                return connection.isDisabled();
            }
            return true;
        }).stream().map(Player::getPlayer).map(class_3222.class::cast).forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"You need to enable voice chat to hear custom audio"), true));
        AtomicBoolean stopped = new AtomicBoolean();
        AtomicReference<AudioPlayer> player2 = new AtomicReference<AudioPlayer>();
        this.players.put(channelID, new PlayerReference(() -> {
            AtomicBoolean atomicBoolean = stopped;
            synchronized (atomicBoolean) {
                stopped.set(true);
                AudioPlayer audioPlayer = (AudioPlayer)player2.get();
                if (audioPlayer != null) {
                    audioPlayer.stopPlaying();
                }
            }
        }, player2, sound, channel));
        this.executor.execute(() -> {
            AudioPlayer audioPlayer = this.playChannel(api, (AudioChannel)channel, level, sound, p, maxLengthSeconds);
            if (audioPlayer == null) {
                this.players.remove(channelID);
                return;
            }
            audioPlayer.setOnStopped(() -> this.players.remove(channelID));
            AtomicBoolean atomicBoolean = stopped;
            synchronized (atomicBoolean) {
                if (!stopped.get()) {
                    player2.set(audioPlayer);
                } else {
                    audioPlayer.stopPlaying();
                }
            }
        });
        return channelID;
    }

    @Nullable
    public UUID playStatic(VoicechatServerApi api, class_3218 level, class_243 pos, UUID sound, @Nullable class_3222 p, float distance, @Nullable String category, int maxLengthSeconds) {
        return this.playStatic(api, level, pos, sound, p, distance, category, maxLengthSeconds, false);
    }

    @Nullable
    public UUID playStatic(VoicechatServerApi api, class_3218 level, class_243 pos, UUID sound, @Nullable class_3222 p, float distance, @Nullable String category, int maxLengthSeconds, boolean byCommand) {
        UUID channelID = UUID.randomUUID();
        api.getPlayersInRange(api.fromServerLevel((Object)level), api.createPosition(pos.field_1352, pos.field_1351, pos.field_1350), (double)(distance + 1.0f), serverPlayer -> {
            VoicechatConnection connection = api.getConnectionOf(serverPlayer);
            if (connection != null) {
                return connection.isDisabled();
            }
            return true;
        }).stream().map(Player::getPlayer).map(class_3222.class::cast).forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"You need to enable voice chat to hear custom audio"), true));
        StaticAudioPlayer staticAudioPlayer = StaticAudioPlayer.create((VoicechatServerApi)api, (class_3218)level, (UUID)sound, (class_3222)p, (int)maxLengthSeconds, (String)category, (class_243)pos, (UUID)channelID, (float)distance);
        AtomicBoolean stopped = new AtomicBoolean();
        AtomicReference<AudioPlayer> player2 = new AtomicReference<AudioPlayer>();
        this.players.put(channelID, new PlayerReference(() -> {
            AtomicBoolean atomicBoolean = stopped;
            synchronized (atomicBoolean) {
                stopped.set(true);
                AudioPlayer audioPlayer = (AudioPlayer)player2.get();
                if (audioPlayer != null) {
                    audioPlayer.stopPlaying();
                }
            }
        }, player2, sound, null));
        this.executor.execute(() -> {
            if (staticAudioPlayer == null) {
                this.players.remove(channelID);
                return;
            }
            staticAudioPlayer.setOnStopped(() -> this.players.remove(channelID));
            AtomicBoolean atomicBoolean = stopped;
            synchronized (atomicBoolean) {
                if (!stopped.get()) {
                    player2.set((AudioPlayer)staticAudioPlayer);
                } else {
                    staticAudioPlayer.stopPlaying();
                }
            }
        });
        return channelID;
    }

    @Nullable
    private AudioPlayer playChannel(VoicechatServerApi api, AudioChannel channel, class_3218 level, UUID sound, class_3222 p, int maxLengthSeconds) {
        try {
            short[] audio = AudioManager.getSound((MinecraftServer)level.method_8503(), (UUID)sound);
            if (AudioManager.getLengthSeconds((short[])audio) > (float)maxLengthSeconds) {
                if (p != null) {
                    p.method_7353((class_2561)class_2561.method_43470((String)"Audio is too long to play").method_27692(class_124.field_1079), true);
                } else {
                    SophisticatedCore.LOGGER.error("Audio {} was too long to play", (Object)sound);
                }
                return null;
            }
            AudioPlayer player = api.createAudioPlayer(channel, api.createEncoder(), audio);
            player.startPlaying();
            return player;
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Failed to play audio", (Throwable)e);
            if (p != null) {
                p.method_7353((class_2561)class_2561.method_43470((String)"Failed to play audio: %s".formatted(e.getMessage())).method_27692(class_124.field_1079), true);
            }
            return null;
        }
    }

    public void stop(UUID channelID) {
        PlayerReference player = this.players.get(channelID);
        if (player != null) {
            player.onStop.stop();
        }
        this.players.remove(channelID);
    }

    public boolean isPlaying(UUID channelID) {
        PlayerReference player = this.players.get(channelID);
        if (player == null) {
            return false;
        }
        AudioPlayer p = player.player.get();
        if (p == null) {
            return true;
        }
        return p.isPlaying();
    }

    @Nullable
    public LocationalAudioChannel getAudioChannel(UUID channelID) {
        PlayerReference player = this.players.get(channelID);
        if (player == null) {
            return null;
        }
        return player.channel();
    }

    public static SCPlayerManager instance() {
        if (instance == null) {
            instance = new SCPlayerManager();
        }
        return instance;
    }

    private record PlayerReference(Stoppable onStop, AtomicReference<AudioPlayer> player, UUID sound, LocationalAudioChannel channel) {
    }

    private static interface Stoppable {
        public void stop();
    }
}

