/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2461;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5625;
import net.minecraft.class_7403;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.network.SyncDatapackSettingsTemplatePayload;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.DatapackSettingsTemplateManager;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTemplateStorage;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public class TemplatePersistanceContainer {
    private static final Pattern EXPORT_FILE_NAME_PATTERN = Pattern.compile("[A-Za-z0-9/._\\-\\s]+");
    private static final int TOTAL_ORDINAL_SAVE_SLOTS = 10;
    private static final String ACTION_TAG = "action";
    private static final String SAVE_SLOT_TAG = "saveSlot";
    private static final String LOAD_SLOT_TAG = "loadSlot";
    static final String TEMPLATE_PERSISTANCE_TAG = "templatePersistance";
    private final SettingsContainerMenu<?> settingsContainer;
    private final class_5455 registryAccess;
    private final List<IPersistanceSlot> saveSlots = new ArrayList<IPersistanceSlot>();
    private int saveSlotIndex = 0;
    private final List<IPersistanceSlot> loadSlots = new ArrayList<IPersistanceSlot>();
    private int loadSlotIndex = -1;
    @Nullable
    private TemplateSettingsHandler selectedTemplate;
    private Runnable onSlotsRefreshed = () -> {};

    public TemplatePersistanceContainer(SettingsContainerMenu<?> settingsContainer, class_5455 registryAccess) {
        this.settingsContainer = settingsContainer;
        this.registryAccess = registryAccess;
        this.initSlots();
    }

    public void setOnSlotsRefreshed(Runnable onSlotsRefreshed) {
        this.onSlotsRefreshed = onSlotsRefreshed;
    }

    private void initSlots() {
        int i;
        this.saveSlots.clear();
        for (i = 0; i < this.getNumberOfSaves(); ++i) {
            this.saveSlots.add(new OrdinalPersistanceSlot(i + 1));
        }
        if (i < 9) {
            this.saveSlots.add(new OrdinalPersistanceSlot(i + 1));
        }
        this.getNamedSaves().forEach(name -> this.saveSlots.add(new NamedPersistanceSlot((String)name)));
        this.saveSlots.add(new EditNamePersistanceSlot(""));
        this.loadSlots.clear();
        for (i = 0; i < this.getNumberOfSaves(); ++i) {
            this.loadSlots.add(new OrdinalPersistanceSlot(i + 1));
        }
        this.getNamedSaves().forEach(name -> this.loadSlots.add(new NamedPersistanceSlot((String)name)));
        DatapackSettingsTemplateManager.getTemplates().forEach((datapackName, templates) -> templates.forEach((templateName, templateNbt) -> this.loadSlots.add(new DatapackSlot((String)datapackName, (String)templateName))));
        if (this.loadSlotIndex == -1 && !this.loadSlots.isEmpty()) {
            this.loadSlotIndex = 0;
        } else if (this.loadSlotIndex != -1 && this.loadSlots.isEmpty()) {
            this.loadSlotIndex = -1;
        }
        this.updateSelectedTemplate();
        this.onSlotsRefreshed.run();
    }

    public void handlePacket(class_2487 data) {
        if (data.method_10545(ACTION_TAG)) {
            String action;
            switch (action = data.method_10558(ACTION_TAG)) {
                case "saveTemplate": {
                    this.saveTemplate(data.method_10558("slotName"));
                    break;
                }
                case "loadTemplate": {
                    this.loadTemplate();
                    break;
                }
                case "exportTemplate": {
                    this.exportTemplate(data.method_10558("fileName"));
                }
            }
        }
        if (data.method_10545(SAVE_SLOT_TAG)) {
            this.scrollSaveSlot(data.method_10577(SAVE_SLOT_TAG));
        } else if (data.method_10545(LOAD_SLOT_TAG)) {
            this.scrollLoadSlot(data.method_10577(LOAD_SLOT_TAG));
        }
    }

    private void sendDataToServer(Supplier<class_2487> compoundSupplier) {
        this.settingsContainer.sendDataToServer(() -> {
            class_2487 compound = new class_2487();
            compound.method_10566(TEMPLATE_PERSISTANCE_TAG, (class_2520)compoundSupplier.get());
            return compound;
        });
    }

    private class_1657 getPlayer() {
        return this.settingsContainer.getPlayer();
    }

    public void loadTemplate() {
        if (this.selectedTemplate == null) {
            return;
        }
        this.settingsContainer.getStorageWrapper().getSettingsHandler().getSettingsCategories().values().forEach(category -> this.overwriteCategory(category.getClass(), (ISettingsCategory<?>)category, (ISettingsCategory<?>)this.selectedTemplate.getTypeCategory(category.getClass())));
        this.sendDataToServer(() -> NBTHelper.putString(new class_2487(), ACTION_TAG, "loadTemplate"));
        if (this.getPlayer().method_37908().method_8608()) {
            this.getPlayer().method_7353((class_2561)class_2561.method_43469((String)TranslationHelper.INSTANCE.translSettingsMessage("load_template"), (Object[])new Object[]{this.loadSlots.get(this.loadSlotIndex).getSlotName()}), false);
        }
    }

    private <T extends ISettingsCategory<T>> void overwriteCategory(Class<T> categoryClazz, ISettingsCategory<?> currentCategory, ISettingsCategory<?> otherCategory) {
        currentCategory.overwriteWith(otherCategory);
    }

    public void saveTemplate(String slotName) {
        SettingsTemplateStorage settingsTemplateStorage = SettingsTemplateStorage.get();
        IPersistanceSlot saveSlot = this.saveSlots.get(this.saveSlotIndex);
        saveSlot.setSlotName(slotName);
        saveSlot.persistTo(this.getPlayer(), settingsTemplateStorage, this.settingsContainer.getStorageWrapper().getSettingsHandler().getNbt().method_10553());
        this.sendDataToServer(() -> NBTHelper.putString(NBTHelper.putString(new class_2487(), ACTION_TAG, "saveTemplate"), "slotName", slotName));
        this.initSlots();
        this.moveSaveSlotIndexTo(saveSlot.getSlotName());
        if (this.getPlayer().method_37908().method_8608()) {
            this.getPlayer().method_7353((class_2561)class_2561.method_43469((String)TranslationHelper.INSTANCE.translSettingsMessage("save_template"), (Object[])new Object[]{saveSlot.getSlotName()}), false);
        }
    }

    private void moveSaveSlotIndexTo(String slotName) {
        for (int i = 0; i < this.saveSlots.size(); ++i) {
            if (!this.saveSlots.get(i).getSlotName().equals(slotName)) continue;
            this.saveSlotIndex = i;
            break;
        }
    }

    public void scrollSaveSlot(boolean next) {
        this.saveSlotIndex += next ? 1 : -1;
        if (this.saveSlotIndex < 0) {
            this.saveSlotIndex = this.saveSlots.size() - 1;
        }
        if (this.saveSlotIndex >= this.saveSlots.size()) {
            this.saveSlotIndex = 0;
        }
        this.sendDataToServer(() -> NBTHelper.putBoolean(new class_2487(), SAVE_SLOT_TAG, next));
    }

    public void scrollLoadSlot(boolean next) {
        if (this.loadSlots.isEmpty()) {
            this.loadSlotIndex = -1;
            return;
        }
        this.loadSlotIndex += next ? 1 : -1;
        if (this.loadSlotIndex < 0) {
            this.loadSlotIndex = this.loadSlots.size() - 1;
        }
        if (this.loadSlotIndex >= this.loadSlots.size()) {
            this.loadSlotIndex = 0;
        }
        this.updateSelectedTemplate();
        this.sendDataToServer(() -> NBTHelper.putBoolean(new class_2487(), LOAD_SLOT_TAG, next));
    }

    private void updateSelectedTemplate() {
        if (this.loadSlotIndex > -1 && this.loadSlotIndex < this.loadSlots.size()) {
            class_2487 settingsTag = this.loadSlots.get(this.loadSlotIndex).getSettingsNbt(this.getPlayer(), SettingsTemplateStorage.get());
            this.selectedTemplate = new TemplateSettingsHandler(settingsTag, this.registryAccess){

                @Override
                protected SettingsHandler getCurrentSettingsHandler() {
                    return TemplatePersistanceContainer.this.settingsContainer.getStorageWrapper().getSettingsHandler();
                }
            };
        }
    }

    public class_5250 getSaveSlotTooltipName() {
        return this.saveSlots.get(this.saveSlotIndex).getSlotTooltipName();
    }

    public class_5250 getLoadSlotTooltipName() {
        return this.loadSlots.get(this.loadSlotIndex).getSlotTooltipName();
    }

    public int getLoadSlot() {
        return this.loadSlotIndex;
    }

    private int getNumberOfSaves() {
        return SettingsTemplateStorage.get().getPlayerTemplates(this.settingsContainer.getPlayer()).size();
    }

    private List<String> getNamedSaves() {
        return new ArrayList<String>(SettingsTemplateStorage.get().getPlayerNamedTemplates(this.settingsContainer.getPlayer()).keySet());
    }

    public Optional<TemplateSettingsHandler> getSelectedTemplate() {
        return Optional.ofNullable(this.selectedTemplate);
    }

    public boolean showsTextbox() {
        return this.saveSlots.get(this.saveSlotIndex).showsTextbox();
    }

    public void refreshTemplateSlots() {
        this.initSlots();
        this.onSlotsRefreshed.run();
    }

    public void exportTemplate(String fileName) {
        if (fileName.isEmpty()) {
            this.getPlayer().method_7353((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translSettingsMessage("export_template.empty_name")).method_27692(class_124.field_1061), false);
            return;
        }
        Matcher matcher = EXPORT_FILE_NAME_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            this.getPlayer().method_7353((class_2561)class_2561.method_43469((String)TranslationHelper.INSTANCE.translSettingsMessage("export_template.invalid_characters"), (Object[])new Object[]{TemplatePersistanceContainer.findNonMatchingCharacters(matcher, fileName)}).method_27692(class_124.field_1061), false);
            return;
        }
        fileName = fileName.replace(' ', '_');
        String finalFileName = fileName = fileName.toLowerCase(Locale.ROOT);
        this.sendDataToServer(() -> NBTHelper.putString(NBTHelper.putString(new class_2487(), ACTION_TAG, "exportTemplate"), "fileName", finalFileName));
        class_1657 class_16572 = this.getPlayer();
        if (class_16572 instanceof class_3222) {
            Path templatesDir;
            String playersFolder;
            class_3222 serverPlayer = (class_3222)class_16572;
            class_3218 serverLevel = serverPlayer.method_51469();
            Path datapacksDir = serverLevel.method_8503().method_27050(class_5218.field_24186);
            Path datapackRoot = datapacksDir.resolve(playersFolder = this.getPlayer().method_5820().toLowerCase(Locale.ROOT) + "_soph_templates");
            if (!TemplatePersistanceContainer.initDatapackStructure(datapackRoot, templatesDir = datapackRoot.resolve("data/" + playersFolder + "/sophisticated_settingstemplates"))) {
                return;
            }
            Path exportPath = templatesDir.resolve(fileName + ".snbt");
            class_2487 settingsNbt = this.settingsContainer.getStorageWrapper().getSettingsHandler().getNbt().method_10553();
            try {
                class_2461.method_32234((class_7403)class_7403.field_39439, (Path)exportPath, (String)new class_5625().method_32283((class_2520)settingsNbt));
            }
            catch (IOException e) {
                SophisticatedCore.LOGGER.error("Error writing template export", (Throwable)e);
                return;
            }
            DatapackSettingsTemplateManager.putTemplate(playersFolder, fileName, settingsNbt);
            PacketDistributor.sendToPlayer(serverPlayer, new SyncDatapackSettingsTemplatePayload(playersFolder, fileName, settingsNbt));
            this.initSlots();
            this.getPlayer().method_7353((class_2561)class_2561.method_43469((String)TranslationHelper.INSTANCE.translSettingsMessage("export_template"), (Object[])new Object[]{serverLevel.method_8503().method_27050(class_5218.field_24188).relativize(exportPath)}), false);
        }
    }

    public static String findNonMatchingCharacters(Matcher matcher, String input) {
        StringBuilder nonMatchingCharacters = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (matcher.reset(String.valueOf(c)).matches()) continue;
            nonMatchingCharacters.append(c);
        }
        return nonMatchingCharacters.toString();
    }

    public boolean templateHasTooManySlots() {
        return this.selectedTemplate != null && this.selectedTemplate.getSettingsCategories().values().stream().anyMatch(category -> category.isLargerThanNumberOfSlots(this.settingsContainer.getStorageWrapper().getInventoryHandler().getSlotCount()));
    }

    private static boolean initDatapackStructure(Path datapackRoot, Path templatesDir) {
        try {
            Files.createDirectories(templatesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            SophisticatedCore.LOGGER.error("Error creating directory for template export", (Throwable)e);
            return false;
        }
        Path packMcmetaFile = datapackRoot.resolve("pack.mcmeta");
        if (!Files.exists(packMcmetaFile, new LinkOption[0])) {
            try {
                Files.writeString(packMcmetaFile, (CharSequence)"{\n    \"pack\": {\n        \"pack_format\": 15,\n        \"description\": \"Sophisticated Settings Templates data pack\"\n    }\n}\n", new OpenOption[0]);
            }
            catch (IOException e) {
                SophisticatedCore.LOGGER.error("Error creating pack.mcmeta for template export", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public Optional<String> getLoadSlotSource() {
        return this.loadSlots.get(this.loadSlotIndex).getSlotSource();
    }

    private static class OrdinalPersistanceSlot
    implements IPersistanceSlot {
        private final int slot;

        public OrdinalPersistanceSlot(int slot) {
            this.slot = slot;
        }

        @Override
        public String getName() {
            return "ordinal";
        }

        @Override
        public String getSlotName() {
            return String.valueOf(this.slot);
        }

        @Override
        public void serialize(class_2487 tag) {
            IPersistanceSlot.super.serialize(tag);
            tag.method_10569("slot", this.slot);
        }

        @Override
        public void persistTo(class_1657 player, SettingsTemplateStorage settingsTemplateStorage, class_2487 settingsCopy) {
            settingsTemplateStorage.putPlayerTemplate(player, this.slot, settingsCopy);
        }

        @Override
        public class_2487 getSettingsNbt(class_1657 player, SettingsTemplateStorage settingsTemplateStorage) {
            return settingsTemplateStorage.getPlayerTemplates(player).getOrDefault(this.slot, new class_2487());
        }
    }

    private static class EditNamePersistanceSlot
    extends NamedPersistanceSlot {
        public EditNamePersistanceSlot(String slotName) {
            super(slotName);
        }

        @Override
        public boolean showsTextbox() {
            return true;
        }

        @Override
        public void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public class_5250 getSlotTooltipName() {
            return class_2561.method_43471((String)TranslationHelper.INSTANCE.translSettingsButton("save_template.custom_name_slot"));
        }
    }

    public static abstract class TemplateSettingsHandler
    extends SettingsHandler {
        protected TemplateSettingsHandler(class_2487 contentsNbt, class_5455 registryAccess) {
            super(contentsNbt, () -> {}, NoopStorageWrapper.INSTANCE::getInventoryHandler, NoopStorageWrapper.INSTANCE::getRenderInfo);
        }

        protected abstract SettingsHandler getCurrentSettingsHandler();

        @Override
        protected class_2487 getSettingsNbtFromContentsNbt(class_2487 contentsNbt) {
            return contentsNbt;
        }

        @Override
        protected void addItemDisplayCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier, class_2487 settingsNbt) {
            int itemNumberLimit = this.getCurrentSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).getItemNumberLimit();
            this.addSettingsCategory(settingsNbt, "item_display", this.markContentsDirty, (categoryNbt, saveNbt) -> new ItemDisplaySettingsCategory(inventoryHandlerSupplier, renderInfoSupplier, (class_2487)categoryNbt, (Consumer<class_2487>)saveNbt, itemNumberLimit, () -> this.getTypeCategory(MemorySettingsCategory.class)));
        }

        @Override
        public String getGlobalSettingsCategoryName() {
            return this.getCurrentSettingsHandler().getGlobalSettingsCategoryName();
        }

        @Override
        public ISettingsCategory<?> instantiateGlobalSettingsCategory(class_2487 categoryNbt, Consumer<class_2487> saveNbt) {
            return this.getCurrentSettingsHandler().instantiateGlobalSettingsCategory(categoryNbt, saveNbt);
        }

        @Override
        protected void saveCategoryNbt(class_2487 settingsNbt, String categoryName, class_2487 tag) {
        }
    }

    private static interface IPersistanceSlot {
        public String getName();

        public String getSlotName();

        default public void serialize(class_2487 tag) {
            tag.method_10582("name", this.getName());
        }

        default public void persistTo(class_1657 player, SettingsTemplateStorage settingsTemplateStorage, class_2487 settingsCopy) {
        }

        default public boolean showsTextbox() {
            return false;
        }

        default public void setSlotName(String slotName) {
        }

        default public class_5250 getSlotTooltipName() {
            return class_2561.method_43470((String)this.getSlotName());
        }

        public class_2487 getSettingsNbt(class_1657 var1, SettingsTemplateStorage var2);

        default public Optional<String> getSlotSource() {
            return Optional.empty();
        }
    }

    private static class DatapackSlot
    implements IPersistanceSlot {
        private final String datapackName;
        private final String templateName;

        public DatapackSlot(String datapackName, String templateName) {
            this.datapackName = datapackName;
            this.templateName = templateName;
        }

        @Override
        public String getName() {
            return "datapack";
        }

        @Override
        public String getSlotName() {
            return this.templateName;
        }

        @Override
        public class_2487 getSettingsNbt(class_1657 player, SettingsTemplateStorage settingsTemplateStorage) {
            return DatapackSettingsTemplateManager.getTemplateNbt(this.datapackName, this.templateName).orElseGet(class_2487::new);
        }

        @Override
        public Optional<String> getSlotSource() {
            return Optional.of(this.datapackName);
        }
    }

    private static class NamedPersistanceSlot
    implements IPersistanceSlot {
        protected String slotName;

        public NamedPersistanceSlot(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public String getName() {
            return "named";
        }

        @Override
        public String getSlotName() {
            return this.slotName;
        }

        @Override
        public void serialize(class_2487 tag) {
            IPersistanceSlot.super.serialize(tag);
            tag.method_10582("slot", this.slotName);
        }

        @Override
        public void persistTo(class_1657 player, SettingsTemplateStorage settingsTemplateStorage, class_2487 settingsCopy) {
            settingsTemplateStorage.putPlayerNamedTemplate(player, this.slotName, settingsCopy);
        }

        @Override
        public class_2487 getSettingsNbt(class_1657 player, SettingsTemplateStorage settingsTemplateStorage) {
            return settingsTemplateStorage.getPlayerNamedTemplates(player).getOrDefault(this.slotName, new class_2487());
        }
    }
}

