/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry.tool;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.IRegistryDataLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.Matchers;

public class SwordRegistry {
    private static final Set<class_1792> SWORD_ITEMS = new HashSet<class_1792>();
    private static final Map<String, Set<Predicate<class_1799>>> MOD_SWORD_MATCHERS = new HashMap<String, Set<Predicate<class_1799>>>();
    private static final Set<Predicate<class_1799>> SWORD_MATCHERS = new HashSet<Predicate<class_1799>>();

    private SwordRegistry() {
    }

    public static boolean isSword(class_1799 stack) {
        if (SWORD_ITEMS.contains(stack.method_7909())) {
            return true;
        }
        if (stack.method_7909() instanceof class_1829) {
            SWORD_ITEMS.add(stack.method_7909());
            return true;
        }
        class_2960 registryName = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (registryName == class_7923.field_41178.method_10137()) {
            return false;
        }
        for (Predicate<class_1799> swordMatcher : SWORD_MATCHERS) {
            if (!swordMatcher.test(stack)) continue;
            return true;
        }
        String modId = registryName.method_12836();
        if (!MOD_SWORD_MATCHERS.containsKey(modId)) {
            return false;
        }
        Set<Predicate<class_1799>> matchers = MOD_SWORD_MATCHERS.get(modId);
        for (Predicate<class_1799> matcher : matchers) {
            if (!matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static class SwordsLoader
    implements IRegistryDataLoader {
        @Override
        public String getName() {
            return "swords";
        }

        @Override
        public void parse(JsonObject json, @Nullable String modId) {
            JsonArray swords = json.getAsJsonArray("swords");
            for (JsonElement jsonElement : swords) {
                if (jsonElement.isJsonPrimitive()) {
                    this.parseSword(jsonElement.getAsString());
                    continue;
                }
                this.parseSwordMatcher(modId, jsonElement);
            }
        }

        private void parseSwordMatcher(@Nullable String modId, JsonElement jsonElement) {
            Matchers.getItemMatcher(jsonElement).ifPresent(swordMatcher -> {
                if (modId != null) {
                    MOD_SWORD_MATCHERS.computeIfAbsent(modId, m -> new HashSet()).add(swordMatcher);
                } else {
                    SWORD_MATCHERS.add((Predicate<class_1799>)swordMatcher);
                }
            });
        }

        private void parseSword(String swordName) {
            class_7923.field_41178.method_17966(class_2960.method_60654((String)swordName)).ifPresentOrElse(SWORD_ITEMS::add, () -> {
                String modId = swordName.split(":")[0];
                if (!FabricLoader.getInstance().isModLoaded(modId)) {
                    SophisticatedBackpacks.LOGGER.debug("Mod {} isn't loaded skipping load of sword {}", (Object)modId, (Object)swordName);
                } else {
                    SophisticatedBackpacks.LOGGER.warn("Mod {} is loaded and yet sword {} doesn't exist in registry, skipping its load", (Object)modId, (Object)swordName);
                }
            });
        }

        @Override
        public void clear() {
            SWORD_ITEMS.clear();
            SWORD_MATCHERS.clear();
            MOD_SWORD_MATCHERS.clear();
        }
    }
}

