/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.IRegistryDataLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.JsonHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.SwordRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolRegistry;

public class RegistryLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Map<String, IRegistryDataLoader> loaders = new HashMap<String, IRegistryDataLoader>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<class_2960, String> loadedRegistries = new HashMap<class_2960, String>();
    private final List<DependentFile> loadLater = new ArrayList<DependentFile>();

    public static void registerParser(IRegistryDataLoader parser) {
        loaders.put(parser.getName(), parser);
    }

    public RegistryLoader() {
        super(GSON, "registry");
    }

    public class_2960 getFabricId() {
        return SophisticatedBackpacks.getRL("registry_loader");
    }

    protected void apply(Map<class_2960, JsonElement> registries, class_3300 resourceManagerIn, class_3695 profilerIn) {
        loaders.values().forEach(IRegistryDataLoader::clear);
        registries.forEach(this::loadRegistry);
        this.loadDependents(registries);
    }

    private void loadDependents(Map<class_2960, JsonElement> registries) {
        int lastCountLoadLater = this.loadLater.size();
        while (!this.loadLater.isEmpty()) {
            Iterator<DependentFile> iterator = this.loadLater.iterator();
            while (iterator.hasNext()) {
                DependentFile dependentFile = iterator.next();
                if (!this.areDependenciesLoaded(dependentFile.getDependencies())) continue;
                this.loadRegistry(dependentFile.getName(), registries.get(dependentFile.getName()));
                iterator.remove();
            }
            if (lastCountLoadLater <= this.loadLater.size()) {
                this.logIncorrectDependencies();
                break;
            }
            lastCountLoadLater = this.loadLater.size();
        }
    }

    private void logIncorrectDependencies() {
        for (DependentFile dependentFile : this.loadLater) {
            SophisticatedBackpacks.LOGGER.error("Non existent or circular load after dependencies in {} - {}", (Object)dependentFile.getName(), (Object)String.join((CharSequence)",", dependentFile.getDependencies()));
        }
    }

    private void loadRegistry(class_2960 name, JsonElement fullJson) {
        Set<String> dependencies;
        SophisticatedBackpacks.LOGGER.debug("Started loading registry data from {} ", (Object)name);
        String path = name.method_12832();
        String shortName = path.substring(path.lastIndexOf(47) + 1);
        if (!fullJson.isJsonObject()) {
            return;
        }
        JsonObject json = fullJson.getAsJsonObject();
        Optional<IRegistryDataLoader> loader = this.getLoader(shortName, json);
        if (loader.isEmpty()) {
            SophisticatedBackpacks.LOGGER.error("No loader defined for {}", (Object)shortName);
            return;
        }
        if (json.has("load_after") && !this.areDependenciesLoaded(dependencies = JsonHelper.setFromJson(json.get("load_after"), e -> class_3518.method_15287((JsonElement)e, (String)"")))) {
            this.loadLater.add(new DependentFile(name, dependencies));
            SophisticatedBackpacks.LOGGER.debug("Registry data at {} depend on {} which are not all loaded, skipping for now.", (Object)name, dependencies);
            return;
        }
        this.loadedRegistries.put(name, loader.get().getName());
        String modId = null;
        if (class_3518.method_15294((JsonObject)json, (String)"mod")) {
            modId = class_3518.method_15265((JsonObject)json, (String)"mod");
        }
        if (this.isDisabled(json) || modId != null && !FabricLoader.getInstance().isModLoaded(modId)) {
            return;
        }
        try {
            loader.get().parse(json, modId);
            SophisticatedBackpacks.LOGGER.debug("Finished loading registry data for {}", (Object)name);
        }
        catch (Exception exception) {
            SophisticatedBackpacks.LOGGER.error("Caught exception while loading {} : {}", (Object)name, (Object)exception);
        }
    }

    private boolean areDependenciesLoaded(Set<String> dependencies) {
        for (String dependency : dependencies) {
            if (this.loadedRegistries.containsValue(dependency)) continue;
            return false;
        }
        return true;
    }

    private boolean isDisabled(JsonObject json) {
        return json.has("disabled") && class_3518.method_15270((JsonObject)json, (String)"disabled");
    }

    private Optional<IRegistryDataLoader> getLoader(String fileName, JsonObject json) {
        String parserName = fileName;
        if (json.has("type")) {
            parserName = class_3518.method_15265((JsonObject)json, (String)"type");
        }
        return loaders.containsKey(parserName) ? Optional.of(loaders.get(parserName)) : Optional.empty();
    }

    static {
        RegistryLoader.registerParser(new ToolRegistry.BlockToolsLoader());
        RegistryLoader.registerParser(new ToolRegistry.EntityToolsLoader());
        RegistryLoader.registerParser(new SwordRegistry.SwordsLoader());
    }

    private static class DependentFile {
        private final class_2960 name;
        private final Set<String> dependencies;

        private DependentFile(class_2960 name, Set<String> dependencies) {
            this.name = name;
            this.dependencies = dependencies;
        }

        public Set<String> getDependencies() {
            return this.dependencies;
        }

        public class_2960 getName() {
            return this.name;
        }
    }
}

