/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.vertex.serializers;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.locks.StampedLock;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatExtensions;
import net.caffeinemc.mods.sodium.api.vertex.serializer.VertexSerializer;
import net.caffeinemc.mods.sodium.api.vertex.serializer.VertexSerializerRegistry;
import net.caffeinemc.mods.sodium.client.render.vertex.serializers.generated.VertexSerializerFactory;
import net.minecraft.class_293;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexSerializerRegistryImpl
implements VertexSerializerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertexSerializerRegistryImpl.class);
    private static final Path CLASS_DUMP_PATH;
    private final Long2ReferenceMap<VertexSerializer> cache = new Long2ReferenceOpenHashMap();
    private final StampedLock lock = new StampedLock();

    @Override
    public VertexSerializer get(class_293 srcFormat, class_293 dstFormat) {
        long identifier = VertexSerializerRegistryImpl.createKey(srcFormat, dstFormat);
        VertexSerializer serializer = this.find(identifier);
        if (serializer == null) {
            serializer = this.create(identifier, srcFormat, dstFormat);
        }
        return serializer;
    }

    @Override
    public void registerSerializer(class_293 srcFormat, class_293 dstFormat, VertexSerializer serializer) {
        this.cache.put(VertexSerializerRegistryImpl.createKey(srcFormat, dstFormat), (Object)serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VertexSerializer create(long identifier, class_293 srcFormat, class_293 dstFormat) {
        long stamp = this.lock.writeLock();
        try {
            VertexSerializer cached = (VertexSerializer)this.cache.get(identifier);
            if (cached != null) {
                VertexSerializer vertexSerializer = cached;
                return vertexSerializer;
            }
            VertexSerializer serializer = VertexSerializerRegistryImpl.createSerializer(srcFormat, dstFormat);
            this.cache.put(identifier, (Object)serializer);
            VertexSerializer vertexSerializer = serializer;
            return vertexSerializer;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VertexSerializer find(long identifier) {
        long stamp = this.lock.readLock();
        try {
            VertexSerializer vertexSerializer = (VertexSerializer)this.cache.get(identifier);
            return vertexSerializer;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    private static VertexSerializer createSerializer(class_293 srcVertexFormat, class_293 dstVertexFormat) {
        VertexSerializer serializer;
        Object instance;
        Constructor<?> constructor;
        String identifier = String.format("%04X$%04X", VertexSerializerRegistryImpl.getGlobalId(srcVertexFormat), VertexSerializerRegistryImpl.getGlobalId(dstVertexFormat));
        VertexSerializerFactory.Bytecode bytecode = VertexSerializerFactory.generate(srcVertexFormat, dstVertexFormat, identifier);
        if (CLASS_DUMP_PATH != null) {
            VertexSerializerRegistryImpl.dumpClass(identifier, bytecode);
        }
        Class<?> clazz = VertexSerializerFactory.define(bytecode);
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find constructor of generated class", e);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate generated class", e);
        }
        try {
            serializer = (VertexSerializer)instance;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Failed to cast generated class to interface type", e);
        }
        return serializer;
    }

    private static void dumpClass(String id, VertexSerializerFactory.Bytecode bytecode) {
        Path path = CLASS_DUMP_PATH.resolve("VertexSerializer$Impl$%s.class".formatted(id));
        try {
            Files.write(path, bytecode.copy(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Could not dump bytecode to location: {}", (Object)path, (Object)e);
        }
    }

    private static long createKey(class_293 a, class_293 b) {
        return (long)VertexSerializerRegistryImpl.getGlobalId(a) & 0xFFFFFFFFL | ((long)VertexSerializerRegistryImpl.getGlobalId(b) & 0xFFFFFFFFL) << 32;
    }

    private static int getGlobalId(class_293 format) {
        return ((VertexFormatExtensions)format).sodium$getGlobalId();
    }

    static {
        String classDumpPath = System.getProperty("sodium.codegen.dump", null);
        CLASS_DUMP_PATH = classDumpPath != null ? Path.of(classDumpPath, new String[0]) : null;
    }
}

