/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.fabric;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.fabric.ClientBoundSyncDataMapsPacket;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_3962;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

public abstract class DataMapBridge<T, O>
extends class_4080<List<JsonElement>> {
    public static final Map<String, Function<class_7225.class_7874, DataMapBridge<?, ?>>> FACTORIES = new HashMap();
    private static final Map<String, DataMapBridge<?, ?>> SERVER_INSTANCES = new HashMap();
    private static final String ML_MARKER = "moonlight_parse_on_fabric";
    private static final Gson GSON = new Gson();
    public final String path;
    private final class_7225.class_7874 registryAccess;
    public final Codec<Map<class_6885<O>, T>> mapCodec;
    public final class_9139<class_9129, Map<class_6885<O>, T>> streamCodec;
    public final Map<class_6885<O>, T> map = new HashMap<class_6885<O>, T>();

    @ApiStatus.Internal
    public static void init() {
        DataMapBridge.register("data_maps/item/furnace_fuels.json", BurnTimes::new);
        DataMapBridge.register("data_maps/item/compostables.json", Compostables::new);
        DataMapBridge.register("data_maps/block/oxidizables.json", Oxidisables::new);
        DataMapBridge.register("data_maps/block/waxables.json", Waxables::new);
        for (Map.Entry<String, Function<class_7225.class_7874, DataMapBridge<?, ?>>> f : FACTORIES.entrySet()) {
            String mapID = f.getKey();
            class_2960 reloadID = Moonlight.res(mapID);
            PlatHelper.addServerReloadListener(r -> {
                DataMapBridge instance = (DataMapBridge)((Object)((Object)((Function)f.getValue()).apply(r)));
                SERVER_INSTANCES.put(mapID, instance);
                return instance;
            }, reloadID);
        }
    }

    @ApiStatus.Internal
    public static void onDataSyncToPlayer(class_3222 player, boolean isJoined) {
        for (Map.Entry<String, DataMapBridge<?, ?>> entry : SERVER_INSTANCES.entrySet()) {
            DataMapBridge<?, ?> map = entry.getValue();
            NetworkHelper.sendToClientPlayer(player, new ClientBoundSyncDataMapsPacket(map));
        }
    }

    public static void register(String path, Function<class_7225.class_7874, DataMapBridge<?, ?>> factory) {
        FACTORIES.put(path, factory);
    }

    protected DataMapBridge(String path, class_7225.class_7874 registryAccess, Codec<T> entryCodec, class_5321<? extends class_2378<O>> reg) {
        this.path = path;
        this.registryAccess = registryAccess;
        this.mapCodec = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)class_6895.method_40340((class_5321)reg), (Codec)entryCodec).fieldOf("values").forGetter(m -> m)).apply((Applicative)i, HashMap::new));
        this.streamCodec = class_9135.method_56377(i -> new HashMap(), (class_9139)class_9135.method_58001(reg), (class_9139)class_9135.method_56368(entryCodec));
    }

    protected final List<JsonElement> prepare(class_3300 resourceManager, class_3695 profiler) {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        Map m = resourceManager.method_41265(this.path, r -> true);
        ArrayList list = new ArrayList();
        for (List res : m.values()) {
            list.addAll(res);
        }
        for (List res : list) {
            try {
                BufferedReader reader = res.method_43039();
                try {
                    JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                    output.add(jsonElement);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var14) {
                Moonlight.LOGGER.error("Couldn't parse data file {} from {}", (Object)res, (Object)this.path);
            }
        }
        return output;
    }

    protected final void apply(List<JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        this.map.clear();
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.registryAccess);
        for (JsonElement entry : jsons) {
            JsonObject jo;
            if (!(entry instanceof JsonObject) || !(jo = (JsonObject)entry).has(ML_MARKER)) continue;
            Map parsed = (Map)this.mapCodec.parse((DynamicOps)ops, (Object)jo).getOrThrow();
            this.map.putAll(parsed);
        }
        this.applyData();
    }

    public final void applyData() {
        for (Map.Entry<class_6885<O>, T> entry : this.map.entrySet()) {
            for (class_6880 holder : entry.getKey()) {
                Object object = holder.comp_349();
                T data = entry.getValue();
                this.applyEntry(object, data);
            }
        }
    }

    protected abstract void applyEntry(O var1, T var2);

    public void encode(class_9129 buf) {
        this.streamCodec.encode((Object)buf, this.map);
    }

    public void decode(class_9129 buf) {
        this.map.clear();
        this.map.putAll((Map)this.streamCodec.decode((Object)buf));
    }

    protected static class BurnTimes
    extends DataMapBridge<FurnaceFuel, class_1792> {
        protected static final String FUEL = "data_maps/item/furnace_fuels.json";

        protected BurnTimes(class_7225.class_7874 registryAccess) {
            super(FUEL, registryAccess, FurnaceFuel.CODEC, class_7924.field_41197);
        }

        @Override
        protected void applyEntry(class_1792 object, FurnaceFuel dataEntry) {
            FuelRegistry.INSTANCE.add((class_1935)object, (Object)dataEntry.burnTime);
        }

        protected record FurnaceFuel(int burnTime) {
            public static final Codec<FurnaceFuel> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(in -> in.group((App)class_5699.field_33442.fieldOf("burn_time").forGetter(FurnaceFuel::burnTime)).apply((Applicative)in, FurnaceFuel::new)), (Codec)class_5699.field_33442.xmap(FurnaceFuel::new, FurnaceFuel::burnTime));
        }
    }

    protected static class Compostables
    extends DataMapBridge<Compostable, class_1792> {
        protected static final String COMPOSTABLES = "data_maps/item/compostables.json";

        protected Compostables(class_7225.class_7874 registryAccess) {
            super(COMPOSTABLES, registryAccess, Compostable.CODEC, class_7924.field_41197);
        }

        @Override
        protected void applyEntry(class_1792 object, Compostable dataEntry) {
            class_3962.field_17566.put((Object)object, dataEntry.chance);
        }

        protected record Compostable(float chance, boolean canVillagerCompost) {
            public static final Codec<Compostable> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(in -> in.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(Compostable::chance), (App)Codec.BOOL.optionalFieldOf("can_villager_compost", (Object)false).forGetter(Compostable::canVillagerCompost)).apply((Applicative)in, Compostable::new)), (Codec)Codec.floatRange((float)0.0f, (float)1.0f).xmap(Compostable::new, Compostable::chance));

            public Compostable(float chance) {
                this(chance, false);
            }
        }
    }

    protected static class Oxidisables
    extends DataMapBridge<Oxidizable, class_2248> {
        protected static final String OXIDISABLES = "data_maps/block/oxidizables.json";

        protected Oxidisables(class_7225.class_7874 registryAccess) {
            super(OXIDISABLES, registryAccess, Oxidizable.CODEC, class_7924.field_41254);
        }

        @Override
        protected void applyEntry(class_2248 object, Oxidizable dataEntry) {
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)object, (class_2248)dataEntry.nextOxidationStage);
        }

        public record Oxidizable(class_2248 nextOxidationStage) {
            public static final Codec<Oxidizable> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(in -> in.group((App)class_7923.field_41175.method_39673().fieldOf("next_oxidation_stage").forGetter(Oxidizable::nextOxidationStage)).apply((Applicative)in, Oxidizable::new)), (Codec)class_7923.field_41175.method_39673().xmap(Oxidizable::new, Oxidizable::nextOxidationStage));
        }
    }

    protected static class Waxables
    extends DataMapBridge<Waxable, class_2248> {
        protected static final String WAXABLES = "data_maps/block/waxables.json";

        protected Waxables(class_7225.class_7874 registryAccess) {
            super(WAXABLES, registryAccess, Waxable.CODEC, class_7924.field_41254);
        }

        @Override
        protected void applyEntry(class_2248 object, Waxable dataEntry) {
            OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)object, (class_2248)dataEntry.waxed);
        }

        public record Waxable(class_2248 waxed) {
            public static final Codec<Waxable> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(in -> in.group((App)class_7923.field_41175.method_39673().fieldOf("waxed").forGetter(Waxable::waxed)).apply((Applicative)in, Waxable::new)), (Codec)class_7923.field_41175.method_39673().xmap(Waxable::new, Waxable::waxed));
        }
    }
}

