/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCachedEditableResources
implements class_3262,
IEditablePackResources {
    protected final Path path;
    protected final class_9224 locationInfo;
    protected final class_3272 metadata;
    protected final class_3264 packType;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected class_3262 cachedResources = null;

    public AbstractCachedEditableResources(Path path, class_9224 locationInfo, class_3264 packType, class_2561 description) {
        this.path = path;
        this.locationInfo = locationInfo;
        this.packType = packType;
        this.metadata = new class_3272(description, class_155.method_16673().method_48017(packType), Optional.empty());
    }

    public class_9224 method_56926() {
        return this.locationInfo;
    }

    public Set<String> method_14406(class_3264 type) {
        if (type != this.packType) {
            return Set.of();
        }
        return this.namespaces;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        if (packType != this.packType) {
            return;
        }
        if (this.cachedResources == null) {
            return;
        }
        this.cachedResources.method_14408(packType, namespace, path, resourceOutput);
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        if (packType != this.packType) {
            return null;
        }
        if (this.cachedResources == null) {
            return null;
        }
        return this.cachedResources.method_14405(packType, location);
    }

    public <T> T method_14407(class_3270<T> serializer) {
        try {
            return (T)(serializer == class_3272.field_14202 ? this.metadata : null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    @Override
    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    public void close() {
        if (this.cachedResources != null) {
            this.cachedResources.close();
        }
    }
}

