/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.misc.RollingBuffer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class ParticleTrailEmitter {
    private final double wantedSpacing;
    private final int maxParticlesPerTick;
    private final int minParticlesPerTick;
    private final double minSpeed;
    private class_243 lastEmittedPos = null;
    private final RollingBuffer<class_243> previousVelocities = new RollingBuffer(3);
    private final RollingBuffer<class_243> previousPositions = new RollingBuffer(3);

    private ParticleTrailEmitter(Builder builder) {
        this.wantedSpacing = builder.idealSpacing;
        this.maxParticlesPerTick = builder.maxParticlesPerTick;
        this.minParticlesPerTick = builder.minParticlesPerTick;
        this.minSpeed = builder.minSpeed;
    }

    public void tick(class_1297 obj, class_2394 particleOptions) {
        this.tick(obj, particleOptions, true);
    }

    public void tick(class_1297 obj, class_2394 particleOptions, boolean followSpeed) {
        this.tick(obj, (class_243 position, class_243 velocity) -> {
            class_1937 level = obj.method_37908();
            if (followSpeed) {
                level.method_8406(particleOptions, position.field_1352, position.field_1351, position.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350);
            } else {
                level.method_8406(particleOptions, position.field_1352, position.field_1351, position.field_1350, 0.0, 0.0, 0.0);
            }
        });
    }

    public void tick(class_1297 obj, Emitter emitter) {
        double t;
        class_243 movement = obj.method_18798();
        this.previousVelocities.push(movement);
        this.previousPositions.push(obj.method_19538());
        if (this.previousPositions.size() < 2) {
            return;
        }
        if (movement.method_1027() < this.minSpeed * this.minSpeed) {
            return;
        }
        class_243 startPos = this.previousPositions.get(0);
        class_243 endPos = this.previousPositions.get(1);
        class_243 startVel = this.previousVelocities.get(0);
        class_243 endVel = this.previousVelocities.get(1);
        if (this.lastEmittedPos == null) {
            this.lastEmittedPos = startPos;
            return;
        }
        double segmentLength = startPos.method_1022(endPos);
        Double startT = ParticleTrailEmitter.intersectSphereSegment(this.lastEmittedPos, this.wantedSpacing, startPos, endPos);
        if (startT == null) {
            return;
        }
        double remainingLength = segmentLength * (1.0 - startT);
        float spacing = (float)this.wantedSpacing;
        int particlesToEmit = 1 + (int)(remainingLength / this.wantedSpacing);
        if (particlesToEmit > this.maxParticlesPerTick) {
            particlesToEmit = this.maxParticlesPerTick;
            spacing = (float)(remainingLength / (double)particlesToEmit);
        } else if (particlesToEmit < this.minParticlesPerTick) {
            particlesToEmit = this.minParticlesPerTick;
            spacing = (float)(remainingLength / (double)particlesToEmit);
        }
        float h = obj.method_17682() / 2.0f;
        for (int i = 0; i < particlesToEmit && !((t = startT + (double)((float)i * spacing / (float)segmentLength)) > 1.0); ++i) {
            class_243 position = startPos.method_35590(endPos, t);
            class_243 velocity = startVel.method_35590(endVel, t);
            emitter.emitParticle(position.method_1031(0.0, (double)h, 0.0), velocity);
            this.lastEmittedPos = position;
        }
    }

    private static Double intersectSphereSegment(class_243 center, double radius, class_243 start, class_243 end) {
        double c;
        class_243 direction = end.method_1020(start);
        class_243 oldDirection = start.method_1020(center);
        double a = direction.method_1026(direction);
        double b = 2.0 * oldDirection.method_1026(direction);
        double discriminant = b * b - 4.0 * a * (c = oldDirection.method_1026(oldDirection) - radius * radius);
        if (discriminant < 0.0) {
            return null;
        }
        double sqrtDiscriminant = (float)Math.sqrt(discriminant);
        double t1 = (-b - sqrtDiscriminant) / (2.0 * a);
        double t2 = (-b + sqrtDiscriminant) / (2.0 * a);
        if (t1 >= 0.0 && t1 <= 1.0) {
            return class_3532.method_15350((double)t2, (double)0.0, (double)1.0);
        }
        if (t2 >= 0.0 && t2 <= 1.0) {
            return class_3532.method_15350((double)t2, (double)0.0, (double)1.0);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double idealSpacing = 0.5;
        private int maxParticlesPerTick = 5;
        private int minParticlesPerTick = 0;
        private double minSpeed = 0.0;

        public Builder spacing(double spacing) {
            this.idealSpacing = spacing;
            return this;
        }

        public Builder maxParticlesPerTick(int max) {
            this.maxParticlesPerTick = max;
            return this;
        }

        public Builder minParticlesPerTick(int min) {
            this.minParticlesPerTick = min;
            return this;
        }

        public Builder minSpeed(double speed) {
            this.minSpeed = speed;
            return this;
        }

        public ParticleTrailEmitter build() {
            if (this.minParticlesPerTick > this.maxParticlesPerTick) {
                throw new IllegalArgumentException("minParticlesPerTick cannot be greater than maxParticlesPerTick");
            }
            return new ParticleTrailEmitter(this);
        }
    }

    public static interface Emitter {
        public void emitParticle(class_243 var1, class_243 var2);
    }
}

