/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidTankImpl;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftFluidTank {
    public static final class_9139<class_9129, SoftFluidTank> STREAM_CODEC = new class_9139<class_9129, SoftFluidTank>(){

        public SoftFluidTank decode(class_9129 object) {
            int capacity = (Integer)class_9135.field_49675.decode((Object)object);
            SoftFluidStack stack = (SoftFluidStack)SoftFluidStack.STREAM_CODEC.decode((Object)object);
            return SoftFluidTank.create(stack, capacity, (class_7871<SoftFluid>)((class_7871)object.method_56349().method_46759(SoftFluidRegistry.KEY).get()));
        }

        public void encode(class_9129 object, SoftFluidTank object2) {
            class_9135.field_49675.encode((Object)object, (Object)object2.getCapacity());
            SoftFluidStack.STREAM_CODEC.encode((Object)object, (Object)object2.getFluid());
        }
    };
    public static final Codec<SoftFluidTank> CODEC = new Codec<SoftFluidTank>(){

        public <T> DataResult<Pair<SoftFluidTank, T>> decode(DynamicOps<T> ops, T input) {
            if (ops instanceof class_6903) {
                class_6903 registryOps = (class_6903)ops;
                Optional reg = registryOps.method_46634(SoftFluidRegistry.KEY);
                if (reg.isEmpty()) {
                    return DataResult.error(() -> "Failed to find registry from registry lookup!");
                }
                DataResult result1 = SoftFluidStack.CODEC.decode(ops, input);
                DataResult result2 = Codec.INT.decode(ops, input);
                return result1.flatMap(r1 -> result2.map(r2 -> {
                    SoftFluidTank tank = SoftFluidTank.create((SoftFluidStack)r1.getFirst(), (Integer)r2.getFirst(), (class_7871<SoftFluid>)((class_7871)reg.get()));
                    return Pair.of((Object)tank, (Object)r2.getSecond());
                }));
            }
            return DataResult.error(() -> "Registry ops required!");
        }

        public <T> DataResult<T> encode(SoftFluidTank input, DynamicOps<T> ops, T prefix) {
            DataResult result1 = SoftFluidStack.CODEC.encode((Object)input.getFluid(), ops, prefix);
            DataResult result2 = Codec.INT.encode((Object)input.getCapacity(), ops, prefix);
            if (result1.error().isPresent()) {
                return result1;
            }
            if (result2.error().isPresent()) {
                return result2;
            }
            return DataResult.success(prefix);
        }
    };
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;
    private final class_7871<SoftFluid> fluidReg;
    protected final int capacity;
    @NotNull
    protected SoftFluidStack fluidStack;
    protected int stillTintCache = 0;
    protected int flowingTintCache = 0;
    protected int particleTintCache = 0;
    protected boolean needsColorRefresh = true;

    protected SoftFluidTank(int capacity, class_7225.class_7874 registries) {
        this(capacity, (class_7871<SoftFluid>)registries.method_46762(SoftFluidRegistry.KEY));
    }

    protected SoftFluidTank(int capacity, class_7871<SoftFluid> fluidReg) {
        this.capacity = capacity;
        this.fluidReg = fluidReg;
        this.fluidStack = SoftFluidStack.empty(fluidReg);
    }

    @Deprecated(forRemoval=true)
    protected SoftFluidTank(int capacity) {
        this(capacity, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
    }

    public static SoftFluidTank create(int capacity, class_7225.class_7874 registries) {
        return SoftFluidTank.create(capacity, (class_7871<SoftFluid>)registries.method_46762(SoftFluidRegistry.KEY));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoftFluidTank create(int capacity, class_7871<SoftFluid> fluidReg) {
        void var1_1;
        return SoftFluidTankImpl.create(capacity, (class_7871<SoftFluid>)var1_1);
    }

    @Deprecated(forRemoval=true)
    public static SoftFluidTank create(int capacity) {
        return SoftFluidTank.create(capacity, (class_7871<SoftFluid>)SoftFluidRegistry.get(Utils.hackyGetRegistryAccess()).method_46771());
    }

    @Deprecated(forRemoval=true)
    public static SoftFluidTank create(SoftFluidStack stack, int capacity) {
        return SoftFluidTank.create(stack, capacity, (class_7871<SoftFluid>)SoftFluidRegistry.get(Utils.hackyGetRegistryAccess()).method_46771());
    }

    public static SoftFluidTank create(SoftFluidStack stack, int capacity, class_7871<SoftFluid> fluidReg) {
        SoftFluidTank tank = SoftFluidTank.create(capacity, fluidReg);
        tank.setFluid(stack);
        return tank;
    }

    public SoftFluidTank makeCopy() {
        SoftFluidTank tank = SoftFluidTank.create(this.capacity, this.fluidReg);
        tank.copyContent(this);
        return tank;
    }

    public boolean interactWithPlayer(class_1657 player, class_1268 hand, @Nullable class_1937 world, @Nullable class_2338 pos) {
        class_1799 handStack = player.method_5998(hand);
        class_1799 returnStack = this.interactWithItem(handStack, world, pos, false);
        if (returnStack != null) {
            Utils.swapItem(player, hand, returnStack);
            if (!handStack.method_7960()) {
                player.method_7259(class_3468.field_15372.method_14956((Object)handStack.method_7909()));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public class_1799 interactWithItem(class_1799 stack, class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        class_1271<class_1799> fillResult = this.fillItem(stack, world, pos, simulate);
        if (fillResult.method_5467().method_23665()) {
            return (class_1799)fillResult.method_5466();
        }
        class_1271<class_1799> drainResult = this.drainItem(stack, world, pos, simulate);
        if (drainResult.method_5467().method_23665()) {
            return (class_1799)drainResult.method_5466();
        }
        return null;
    }

    public class_1271<class_1799> drainItem(class_1799 filledContainerStack, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        return this.drainItem(filledContainerStack, world, pos, simulate, true);
    }

    public class_1271<class_1799> drainItem(class_1799 filledContainer, class_1937 level, @Nullable class_2338 pos, boolean simulate, boolean playSound) {
        Pair<SoftFluidStack, FluidContainerList.Category> extracted = SoftFluidStack.fromItem(filledContainer);
        if (extracted == null) {
            return class_1271.method_22430((Object)class_1799.field_8037);
        }
        SoftFluidStack fluidStack = (SoftFluidStack)extracted.getFirst();
        if (this.addFluid(fluidStack, true) == fluidStack.getCount()) {
            FluidContainerList.Category category = (FluidContainerList.Category)extracted.getSecond();
            class_1799 emptyContainer = category.getEmptyContainer().method_7854();
            if (!simulate) {
                this.addFluid(fluidStack, false);
                class_3414 sound = category.getEmptySound();
                if (sound != null && pos != null) {
                    level.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            return class_1271.method_29237((Object)emptyContainer, (boolean)level.field_9236);
        }
        return class_1271.method_22430((Object)class_1799.field_8037);
    }

    public class_1271<class_1799> fillItem(class_1799 emptyContainer, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        return this.fillItem(emptyContainer, world, pos, simulate, true);
    }

    public class_1271<class_1799> fillItem(class_1799 emptyContainer, class_1937 level, @Nullable class_2338 pos, boolean simulate, boolean playSound) {
        Pair<class_1799, FluidContainerList.Category> pair = this.fluidStack.splitToItem(emptyContainer);
        if (pair != null) {
            FluidContainerList.Category category = (FluidContainerList.Category)pair.getSecond();
            class_3414 sound = category.getEmptySound();
            if (sound != null && pos != null) {
                level.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1271.method_29237((Object)((class_1799)pair.getFirst()), (boolean)level.field_9236);
        }
        return class_1271.method_22430((Object)class_1799.field_8037);
    }

    protected void addFluidOntoExisting(SoftFluidStack stack) {
        this.fluidStack.grow(stack.getCount());
    }

    @Nullable
    public class_1271<class_1799> fillBottle(class_1937 world, class_2338 pos) {
        return this.fillItem(class_1802.field_8469.method_7854(), world, pos, false);
    }

    @Nullable
    public class_1271<class_1799> fillBucket(class_1937 world, class_2338 pos) {
        return this.fillItem(class_1802.field_8550.method_7854(), world, pos, false);
    }

    @Nullable
    public class_1271<class_1799> fillBowl(class_1937 world, class_2338 pos) {
        return this.fillItem(class_1802.field_8428.method_7854(), world, pos, false);
    }

    public boolean isFluidCompatible(SoftFluidStack fluidStack) {
        return this.fluidStack.isSameFluidSameComponents(fluidStack) || this.isEmpty();
    }

    public int addFluid(SoftFluidStack stack, boolean simulate) {
        if (!this.isFluidCompatible(stack)) {
            return 0;
        }
        int space = this.getSpace();
        if (space == 0) {
            return 0;
        }
        int amount = Math.min(space, stack.getCount());
        if (simulate) {
            return amount;
        }
        SoftFluidStack toAdd = stack.split(amount);
        if (this.isEmpty()) {
            this.setFluid(toAdd);
        } else {
            this.addFluidOntoExisting(toAdd);
        }
        return amount;
    }

    public SoftFluidStack removeFluid(int amount, boolean simulate) {
        if (this.isEmpty()) {
            return SoftFluidStack.empty(this.fluidReg);
        }
        int toRemove = Math.min(amount, this.fluidStack.getCount());
        SoftFluidStack stack = this.fluidStack.copyWithCount(toRemove);
        if (!simulate) {
            this.fluidStack.shrink(toRemove);
        }
        return stack;
    }

    @Deprecated(forRemoval=true)
    public boolean transferFluid(SoftFluidTank destination) {
        return this.transferFluid(destination, 1);
    }

    @Deprecated(forRemoval=true)
    public boolean transferFluid(SoftFluidTank destination, int amount) {
        if (this.isEmpty()) {
            return false;
        }
        SoftFluidStack removed = this.removeFluid(amount, false);
        if (destination.addFluid(removed, true) == removed.getCount()) {
            destination.addFluid(removed, false);
            return true;
        }
        return false;
    }

    public int getSpace() {
        return Math.max(0, this.capacity - this.fluidStack.getCount());
    }

    public int getFluidCount() {
        return this.fluidStack.getCount();
    }

    public boolean isFull() {
        return this.fluidStack.getCount() == this.capacity;
    }

    public boolean isEmpty() {
        return this.fluidStack.isEmpty();
    }

    public float getHeight(float maxHeight) {
        return maxHeight * (float)this.fluidStack.getCount() / (float)this.capacity;
    }

    public int getComparatorOutput() {
        float f = (float)this.fluidStack.getCount() / (float)this.capacity;
        return class_3532.method_15375((float)(f * 14.0f)) + 1;
    }

    public SoftFluidStack getFluid() {
        return this.fluidStack;
    }

    public SoftFluid getFluidValue() {
        return (SoftFluid)this.fluidStack.getHolder().comp_349();
    }

    public void setFluid(SoftFluidStack fluid) {
        this.fluidStack = fluid;
        this.refreshTintCache();
    }

    public void refreshTintCache() {
        this.stillTintCache = 0;
        this.needsColorRefresh = true;
    }

    private void fillCount() {
        this.fluidStack.setCount(this.capacity);
    }

    public void clear() {
        this.setFluid(SoftFluidStack.empty(this.fluidReg));
    }

    public void copyContent(SoftFluidTank other) {
        SoftFluidStack stack = other.getFluid();
        this.setFluid(stack.copyWithCount(Math.min(this.capacity, stack.getCount())));
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void capCapacity() {
        this.fluidStack.setCount(class_3532.method_15340((int)this.fluidStack.getCount(), (int)0, (int)this.capacity));
    }

    private void cacheColors(@Nullable class_1920 world, @Nullable class_2338 pos) {
        this.stillTintCache = this.fluidStack.getStillColor(world, pos);
        this.flowingTintCache = this.fluidStack.getFlowingColor(world, pos);
        this.particleTintCache = this.fluidStack.getParticleColor(world, pos);
        this.needsColorRefresh = false;
    }

    public int getCachedStillColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        if (this.needsColorRefresh) {
            this.cacheColors(world, pos);
        }
        return this.stillTintCache;
    }

    public int getCachedFlowingColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        if (this.needsColorRefresh) {
            this.cacheColors(world, pos);
        }
        return this.flowingTintCache;
    }

    public int getCachedParticleColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        if (this.needsColorRefresh) {
            this.cacheColors(world, pos);
        }
        return this.particleTintCache;
    }

    public boolean containsFood() {
        return !this.fluidStack.getFoodProvider().isEmpty();
    }

    public void load(class_2487 compound, class_7225.class_7874 registries) {
        class_2487 fluidTag = compound.method_10562("fluid");
        class_2487 backCompat = compound.method_10562("FluidHolder");
        if (!backCompat.method_33133()) {
            fluidTag = backCompat;
        }
        if (!fluidTag.method_33133()) {
            this.setFluid(SoftFluidStack.load(registries, (class_2520)fluidTag));
        }
    }

    @Deprecated(forRemoval=true)
    public void load(class_2487 compound) {
        this.load(compound, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
    }

    @Deprecated(forRemoval=true)
    public class_2487 save(class_2487 compound) {
        this.save(compound, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
        return compound;
    }

    public void save(class_2487 compound, class_7225.class_7874 registries) {
        this.setFluid(this.fluidStack);
        class_2520 tag = this.fluidStack.save(registries);
        compound.method_10566("fluid", tag);
    }

    public boolean tryDrinkUpFluid(class_1657 player, class_1937 world) {
        if (!this.isEmpty() && this.containsFood()) {
            if (this.fluidStack.getFoodProvider().consume(player, world, this.fluidStack::copyComponentsTo)) {
                this.fluidStack.shrink(1);
                return true;
            }
        }
        return false;
    }

    public static int getLiquidCountFromItem(class_1792 i) {
        if (i == class_1802.field_8469) {
            return 1;
        }
        if (i == class_1802.field_8428) {
            return 2;
        }
        if (i == class_1802.field_8550) {
            return 4;
        }
        return 0;
    }
}

