/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidImpl;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SoftFluid {
    private final class_2561 name;
    private final class_6885<class_3611> equivalentFluids;
    private final FluidContainerList containerList;
    private final FoodProvider food;
    private final class_6885<class_9331<?>> preservedComponentsFromItem;
    public final boolean isGenerated;
    private final class_2960 stillTexture;
    private final class_2960 flowingTexture;
    @Nullable
    private final class_2960 useTexturesFrom;
    private final int luminosity;
    private final int emissivity;
    private final int tintColor;
    private final TintMethod tintMethod;
    protected int averageTextureTint = -1;
    public static final int BOTTLE_COUNT = Capacity.BOTTLE.getValue();
    public static final int BOWL_COUNT = Capacity.BOWL.getValue();
    public static final int BUCKET_COUNT = Capacity.BUCKET.getValue();
    public static final int WATER_BUCKET_COUNT = 3;
    public static final Codec<class_6880<SoftFluid>> HOLDER_CODEC = class_5381.method_29749(SoftFluidRegistry.KEY, CODEC);
    public static final class_9139<class_9129, class_6880<SoftFluid>> STREAM_CODEC = class_9135.method_56383(SoftFluidRegistry.KEY);
    public static final Codec<class_2561> COMPONENT_CODEC = Codec.either((Codec)class_8824.field_46598, (Codec)Codec.STRING).xmap(either -> (class_2561)either.map(c -> c, class_2561::method_43471), Either::left);
    public static final Codec<SoftFluid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("still_texture").forGetter(SoftFluid::getStillTexture), (App)class_2960.field_25139.fieldOf("flowing_texture").forGetter(SoftFluid::getFlowingTexture), (App)COMPONENT_CODEC.optionalFieldOf("translation_key", (Object)class_2561.method_43471((String)"fluid.moonlight.generic_fluid")).forGetter(SoftFluid::getTranslatedName), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("luminosity", (Object)0).forGetter(SoftFluid::getLuminosity), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("emissivity", (Object)0).forGetter(SoftFluid::getEmissivity), (App)ColorUtils.CODEC.optionalFieldOf("color", (Object)-1).forGetter(SoftFluid::getTintColor), (App)TintMethod.CODEC.optionalFieldOf("tint_method", (Object)TintMethod.STILL_AND_FLOWING).forGetter(SoftFluid::getTintMethod), (App)FoodProvider.CODEC.optionalFieldOf("food", (Object)FoodProvider.EMPTY).forGetter(SoftFluid::getFoodProvider), (App)Utils.lenientHomogeneousList(class_7924.field_49659).optionalFieldOf("preserved_components_from_item", (Object)class_6885.method_58563()).forGetter(SoftFluid::getPreservedComponents), (App)FluidContainerList.CODEC.optionalFieldOf("containers", (Object)new FluidContainerList()).forGetter(SoftFluid::getContainerList), (App)Utils.lenientHomogeneousList(class_7924.field_41270).optionalFieldOf("equivalent_fluids", (Object)class_6885.method_58563()).forGetter(s -> s.equivalentFluids), (App)class_2960.field_25139.optionalFieldOf("use_texture_from").forGetter(s -> Optional.ofNullable(s.getTextureOverride()))).apply((Applicative)instance, SoftFluid::new));

    protected SoftFluid(class_2960 still, class_2960 flowing, class_2561 name, int luminosity, int emissivity, int color, TintMethod tintMethod, FoodProvider food, class_6885<class_9331<?>> components, FluidContainerList containers, class_6885<class_3611> equivalent, Optional<class_2960> textureFrom) {
        Triplet<class_2960, class_2960, Integer> data;
        this.tintMethod = tintMethod;
        this.equivalentFluids = equivalent;
        this.luminosity = luminosity;
        this.emissivity = Math.max(emissivity, luminosity);
        this.containerList = containers;
        this.food = food;
        this.name = name;
        this.preservedComponentsFromItem = components;
        this.useTexturesFrom = textureFrom.orElse(null);
        int tint = color;
        if (this.useTexturesFrom != null && PlatHelper.getPhysicalSide().isClient() && (data = SoftFluid.getRenderingData(this.useTexturesFrom)) != null) {
            still = data.left();
            flowing = data.middle();
            tint = data.right();
        }
        this.stillTexture = still;
        this.flowingTexture = flowing;
        this.tintColor = tint;
        this.isGenerated = false;
    }

    public SoftFluid(class_6880<class_3611> fluid) {
        Triplet<class_2960, class_2960, Integer> data;
        class_2960 still = class_2960.method_60654((String)"block/water_still");
        class_2960 flowing = class_2960.method_60654((String)"block/water_flowing");
        this.tintMethod = TintMethod.STILL_AND_FLOWING;
        this.containerList = new FluidContainerList();
        this.food = FoodProvider.EMPTY;
        this.preservedComponentsFromItem = class_6885.method_58563();
        this.useTexturesFrom = ((class_5321)fluid.method_40230().get()).method_29177();
        this.equivalentFluids = class_6885.method_40246((class_6880[])new class_6880[]{fluid});
        Pair<Integer, class_2561> pair = SoftFluid.getFluidSpecificAttributes((class_3611)fluid.comp_349());
        this.name = pair.getSecond() == null ? class_2561.method_43470((String)"generic fluid") : (class_2561)pair.getSecond();
        this.luminosity = (Integer)pair.getFirst();
        this.emissivity = (Integer)pair.getFirst();
        int tint = -1;
        if (this.useTexturesFrom != null && PlatHelper.getPhysicalSide().isClient() && (data = SoftFluid.getRenderingData(this.useTexturesFrom)) != null) {
            still = data.left();
            flowing = data.middle();
            tint = data.right();
        }
        this.stillTexture = still;
        this.flowingTexture = flowing;
        this.tintColor = tint;
        this.isGenerated = true;
    }

    public void afterInit() {
        for (class_6880 f : this.equivalentFluids) {
            class_1792 filled = ((class_3611)f.comp_349()).method_15774();
            if (filled == class_1802.field_8162 || filled == class_1802.field_8550) continue;
            this.containerList.add(class_1802.field_8550, filled, BUCKET_COUNT, class_3417.field_15126, class_3417.field_14834);
        }
    }

    @Nullable
    public class_2960 getTextureOverride() {
        return this.useTexturesFrom;
    }

    public FoodProvider getFoodProvider() {
        return this.food;
    }

    public class_2561 getTranslatedName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.equivalentFluids.method_40247() != 0 || !this.containerList.getPossibleFilled().isEmpty();
    }

    public class_6880<class_3611> getVanillaFluid() {
        Iterator iterator = this.getEquivalentFluids().iterator();
        if (iterator.hasNext()) {
            class_6880 fluid = (class_6880)iterator.next();
            return fluid;
        }
        return class_3612.field_15906.method_40178();
    }

    public class_6885<class_9331<?>> getPreservedComponents() {
        return this.preservedComponentsFromItem;
    }

    public class_6885<class_3611> getEquivalentFluids() {
        return this.equivalentFluids;
    }

    public boolean isEquivalent(class_6880<class_3611> fluid) {
        return this.equivalentFluids.method_40241(fluid);
    }

    @Deprecated(forRemoval=true)
    public boolean isEmptyFluid() {
        return this == SoftFluidRegistry.empty();
    }

    public Optional<class_1792> getFilledContainer(class_1792 emptyContainer) {
        return this.containerList.getFilled(emptyContainer);
    }

    public Optional<class_1792> getEmptyContainer(class_1792 filledContainer) {
        return this.containerList.getEmpty(filledContainer);
    }

    public FluidContainerList getContainerList() {
        return this.containerList;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public int getEmissivity() {
        return this.emissivity;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public int getAverageTextureTintColor() {
        return this.averageTextureTint;
    }

    public TintMethod getTintMethod() {
        return this.tintMethod;
    }

    public boolean isColored() {
        return this.tintColor != -1;
    }

    public class_2960 getFlowingTexture() {
        return this.flowingTexture;
    }

    public class_2960 getStillTexture() {
        return this.stillTexture;
    }

    public boolean isFood() {
        return !this.food.isEmpty();
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Pair<Integer, class_2561> getFluidSpecificAttributes(class_3611 fluid) {
        return SoftFluidImpl.getFluidSpecificAttributes(fluid);
    }

    @ApiStatus.Internal
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Triplet<class_2960, class_2960, Integer> getRenderingData(class_2960 useTexturesFrom) {
        return SoftFluidImpl.getRenderingData(useTexturesFrom);
    }

    public static enum TintMethod implements class_3542
    {
        NO_TINT,
        FLOWING,
        STILL_AND_FLOWING;

        public static final Codec<TintMethod> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean appliesToFlowing() {
            return this == FLOWING || this == STILL_AND_FLOWING;
        }

        public boolean appliesToStill() {
            return this == STILL_AND_FLOWING;
        }

        static {
            CODEC = class_3542.method_28140(TintMethod::values);
        }
    }

    public static enum Capacity implements class_3542
    {
        BOTTLE(1, 1),
        BOWL(2, 1),
        BUCKET(4, 3),
        BLOCK(4, 4);

        public final int value;
        public static final Codec<Capacity> CODEC;
        public static final Codec<Integer> INT_CODEC;

        private Capacity(int forge, int fabric) {
            this.value = PlatHelper.getPlatform().isForge() ? forge : fabric;
        }

        public String method_15434() {
            return this.name().toUpperCase(Locale.ROOT);
        }

        public int getValue() {
            return this.value;
        }

        static {
            CODEC = class_3542.method_28140(Capacity::values);
            INT_CODEC = Codec.either((Codec)Codec.INT, CODEC).xmap(either -> (Integer)either.map(i -> i, Capacity::getValue), Either::left);
        }
    }
}

