/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.heartstone.Heartstone;
import net.mehvahdjukaar.heartstone.HeartstoneData;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.heartstone.compat.CurioCompat;
import net.mehvahdjukaar.heartstone.compat.TrinketsCompat;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3902;
import org.jetbrains.annotations.Nullable;

public class HeartstoneItem
extends class_1792 {
    public HeartstoneItem() {
        super(new class_1792.class_1793().method_7894(class_1814.field_8903).method_7889(2));
    }

    public boolean method_7886(class_1799 pStack) {
        return HeartstoneItem.getHeartstoneId(pStack) != null;
    }

    @Nullable
    public static Long getHeartstoneId(class_1799 stack) {
        return (Long)stack.method_57825(Heartstone.HEARTSTONE_ID.get(), null);
    }

    public static boolean isCracked(class_1799 stack) {
        return stack.method_57826(Heartstone.CRACKED.get());
    }

    public static void crack(class_1799 stack, class_1297 entity) {
        stack.method_57379(Heartstone.CRACKED.get(), (Object)class_3902.field_17274);
        if (entity instanceof class_1657) {
            class_1657 p = (class_1657)entity;
            if (p.method_6047() == stack) {
                p.method_20235(stack.method_7909(), class_1304.field_6173);
            }
            if (p.method_6079() == stack) {
                p.method_20235(stack.method_7909(), class_1304.field_6171);
            }
        }
        entity.method_5783(class_3417.field_26942, 0.6f, 1.3f);
        entity.method_5783(class_3417.field_15072, 1.3f, 0.7f);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        class_1657 p;
        super.method_7888(stack, level, entity, slotId, isSelected);
        if (HeartstoneItem.isCracked(stack) && (level.method_8510() + 1L) % 40L == 0L && entity instanceof class_1657 && HeartstoneItem.getBoundPlayer(p = (class_1657)entity, stack, false) != null) {
            stack.method_57381(Heartstone.CRACKED.get());
            entity.method_5783(class_3417.field_43154, 0.8f, 0.7f);
            entity.method_5783(class_3417.field_38371, 1.1f, 1.2f);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 player, class_1268 pHand) {
        class_1799 itemstack = player.method_5998(pHand);
        if (pLevel.field_9236) {
            return class_1271.method_22427((Object)itemstack);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        class_1657 otherPlayer = HeartstoneItem.getBoundPlayer(player, itemstack, true);
        if (otherPlayer != null) {
            NetworkHandler.sendHeartstoneParticles(player, otherPlayer);
        } else {
            pLevel.method_43129(null, (class_1297)player, class_3417.field_26981, player.method_5634(), 0.6f, 0.7f);
        }
        player.method_7357().method_7906((class_1792)this, 60);
        return class_1271.method_22428((Object)itemstack);
    }

    @Nullable
    public static class_1657 getBoundPlayer(class_1657 player, class_1799 itemstack, boolean sameDim) {
        class_1937 class_19372;
        Long id = HeartstoneItem.getHeartstoneId(itemstack);
        if (id != null && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_3324 players = serverLevel.method_8503().method_3760();
            for (class_1657 targetPlayer : players.method_14571()) {
                if (!HeartstoneItem.arePlayersBound(player, itemstack, targetPlayer, sameDim)) continue;
                return targetPlayer;
            }
        }
        return null;
    }

    public static List<class_1799> getAllHeartstones(class_1657 player) {
        class_1799 s;
        ArrayList<class_1799> found = new ArrayList<class_1799>();
        player.method_31548().field_7547.stream().filter(i -> i.method_7909() instanceof HeartstoneItem).forEach(found::add);
        if (Heartstone.TRINKETS && !(s = TrinketsCompat.getHeartstone(player)).method_7960()) {
            found.add(s);
        }
        if (Heartstone.CURIO && !(s = CurioCompat.getHeartstone(player)).method_7960()) {
            found.add(s);
        }
        return found;
    }

    public static boolean arePlayersBound(class_1657 pPlayer, class_1799 original, class_1657 target, boolean sameDimension) {
        if (sameDimension && target.method_37908().method_27983() != pPlayer.method_37908().method_27983()) {
            return false;
        }
        if (target != pPlayer) {
            class_1799 s;
            Long id = HeartstoneItem.getHeartstoneId(original);
            if (id == null) {
                return false;
            }
            class_1661 inv = target.method_31548();
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 s2 = inv.method_5438(i);
                if (!HeartstoneItem.hasMatchingId(id, s2)) continue;
                return true;
            }
            if (Heartstone.TRINKETS && !(s = TrinketsCompat.getHeartstone(target)).method_7960() && HeartstoneItem.hasMatchingId(id, s)) {
                return true;
            }
            if (Heartstone.CURIO) {
                class_1799 s3 = CurioCompat.getHeartstone(target);
                return !s3.method_7960() && HeartstoneItem.hasMatchingId(id, s3);
            }
        }
        return false;
    }

    public static boolean hasMatchingId(Long id, class_1799 s) {
        if (s.method_7909() instanceof HeartstoneItem) {
            Long other = HeartstoneItem.getHeartstoneId(s);
            return other != null && other.equals(id);
        }
        return false;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        Long id = HeartstoneItem.getHeartstoneId(stack);
        if (id != null) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"message.heartstone.id", (Object[])new Object[]{id}));
        }
        if (HeartstoneItem.isCracked(stack)) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"message.heartstone.cracked"));
        }
    }

    public void method_54465(class_1799 pStack, class_1937 pLevel, class_1657 pPlayer) {
        super.method_54465(pStack, pLevel, pPlayer);
        if (HeartstoneItem.getHeartstoneId(pStack) == null && pLevel instanceof class_3218) {
            class_3218 serverLevel = (class_3218)pLevel;
            pStack.method_57379(Heartstone.HEARTSTONE_ID.get(), (Object)HeartstoneData.getNewId(serverLevel));
        }
    }
}

