/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.util;

import com.cstav.genshinstrument.networking.IModPacket;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_9129;

public class ServerUtil {
    public static void registerCodecs(List<Class<IModPacket>> c2sPacketTypes, List<Class<IModPacket>> s2cPacketTypes) {
        ServerUtil.registerCodecs((PayloadTypeRegistry<class_9129>)PayloadTypeRegistry.playC2S(), c2sPacketTypes);
        ServerUtil.registerCodecs((PayloadTypeRegistry<class_9129>)PayloadTypeRegistry.playS2C(), s2cPacketTypes);
    }

    public static void registerCodecs(PayloadTypeRegistry<class_9129> registry, List<Class<IModPacket>> packetTypes) {
        for (Class<IModPacket> packetClass : packetTypes) {
            registry.register(IModPacket.type(packetClass), IModPacket.codec(packetClass));
        }
    }

    public static void registerServerPackets(List<Class<IModPacket>> packetTypes) {
        for (Class<IModPacket> packetClass : packetTypes) {
            ServerPlayNetworking.registerGlobalReceiver(IModPacket.type(packetClass), IModPacket::handleServer);
        }
    }

    public static void registerClientPackets(List<Class<IModPacket>> packetTypes, Map<String, BiConsumer<? extends IModPacket, ClientPlayNetworking.Context>> packetSwitch) {
        for (Class<IModPacket> packetClass : packetTypes) {
            ClientPlayNetworking.registerGlobalReceiver(IModPacket.type(packetClass), (packet, context) -> {
                BiConsumer packetHandler = (BiConsumer)packetSwitch.get(packet.method_56479().comp_2242().method_12832());
                packetHandler.accept(packet, context);
            });
        }
    }

    public static <T extends IModPacket> Map.Entry<String, BiConsumer<T, ClientPlayNetworking.Context>> switchEntry(BiConsumer<T, ClientPlayNetworking.Context> handler, Class<T> packetType) {
        return Map.entry(IModPacket.path(packetType), handler);
    }
}

