/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.held;

import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class HeldNoteSoundInstance
extends class_1101 {
    public final HeldNoteSound heldSoundContainer;
    public final HeldNoteSound.Phase phase;
    public final class_2960 instrumentId;
    public final Optional<class_1297> initiator;
    public final InitiatorID initiatorId;
    public final Optional<class_2338> soundOrigin;
    public final int notePitch;
    private boolean released;
    protected int timeAlive = 0;
    protected int overallTimeAlive;
    protected boolean chainedHolding = false;

    protected HeldNoteSoundInstance(HeldNoteSound heldSoundContainer, HeldNoteSound.Phase phase, int notePitch, float volume, @Nullable class_1297 initiator, @Nullable class_2338 soundOrigin, InitiatorID initiatorId, class_2960 instrumentId, int timeAlive, boolean released) {
        super(heldSoundContainer.getSound(phase).getByPreference(HeldNoteSoundInstance.distFromSourceSqr(soundOrigin, initiator)), NoteSound.INSTRUMENT_SOUND_SOURCE, class_1113.method_43221());
        this.initiatorId = initiatorId;
        this.instrumentId = instrumentId;
        this.heldSoundContainer = heldSoundContainer;
        this.phase = phase;
        this.overallTimeAlive = timeAlive;
        this.initiator = Optional.ofNullable(initiator);
        this.soundOrigin = Optional.ofNullable(soundOrigin);
        this.field_5442 = volume;
        this.notePitch = notePitch;
        this.field_5441 = NoteSound.getPitchByNoteOffset(notePitch);
        this.released = released;
        if (this.distFromSourceSqr() < class_3532.method_33723((double)5.5)) {
            this.field_5440 = class_1113.class_1114.field_5478;
            this.field_18936 = true;
            this.field_5449 = 0.0;
            this.field_5450 = 0.0;
            this.field_5439 = 0.0;
        } else {
            this.field_5440 = class_1113.class_1114.field_5476;
            this.field_18936 = false;
            this.soundOrigin.ifPresentOrElse(loc -> {
                this.field_5439 = loc.method_10263();
                this.field_5450 = loc.method_10264();
                this.field_5449 = loc.method_10260();
            }, this::toInitiatorPos);
        }
    }

    public HeldNoteSoundInstance(HeldNoteSound heldSoundContainer, HeldNoteSound.Phase phase, int notePitch, float volume, @Nullable class_1297 initiator, @Nullable class_2338 soundOrigin, InitiatorID initiatorId, class_2960 instrumentId) {
        this(heldSoundContainer, phase, notePitch, volume, initiator, soundOrigin, initiatorId, instrumentId, 0, false);
    }

    public void queueAndAddInstance() {
        class_310.method_1551().method_1483().method_22140((class_1117)this);
        ClientUtil.stopMusicIfClose(this.soundOrigin.orElseGet(this.initiator.map(class_1297::method_24515)::get));
        this.addSoundInstance();
    }

    public void addSoundInstance() {
        HeldNoteSounds.put(this.initiatorId, this.heldSoundContainer, this.notePitch, this);
    }

    protected void removeSoundInstance() {
        HeldNoteSounds.release(this.initiatorId, this.heldSoundContainer, this.notePitch, this);
    }

    public void setReleased() {
        if (this.released) {
            return;
        }
        this.released = true;
        if (this.phase == HeldNoteSound.Phase.HOLD && this.heldSoundContainer.release() != null) {
            class_243 pos = this.getSourcePos();
            this.heldSoundContainer.release().playLocally(this.field_5441, this.field_5442, new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
        }
    }

    public boolean isReleased() {
        return this.released;
    }

    protected static double distFromSourceSqr(@Nullable class_2338 soundOrigin, @Nullable class_1297 initiator) {
        return class_310.method_1551().field_1724.method_19538().method_1025(HeldNoteSoundInstance.getSourcePos(soundOrigin, initiator));
    }

    public double distFromSourceSqr() {
        return class_310.method_1551().field_1724.method_19538().method_1025(this.getSourcePos());
    }

    protected static class_243 getSourcePos(@Nullable class_2338 soundOrigin, @Nullable class_1297 initiator) {
        return soundOrigin == null ? initiator.method_19538() : soundOrigin.method_46558();
    }

    protected class_243 getSourcePos() {
        return HeldNoteSoundInstance.getSourcePos(this.soundOrigin.orElse(null), this.initiator.orElse(null));
    }

    public void method_16896() {
        this.toInitiatorPos();
        this.handleChainHolding();
        if (this.released) {
            float fadeOutMultiplier = 1.0f;
            float fhft = this.heldSoundContainer.fullHoldFadeoutTime() * 20.0f;
            if (this.phase == HeldNoteSound.Phase.HOLD && fhft != 0.0f && (float)this.overallTimeAlive < fhft) {
                fadeOutMultiplier = 1.0f / ((float)(this.overallTimeAlive + 1) / fhft);
            }
            this.field_5442 -= this.heldSoundContainer.releaseFadeOut() * fadeOutMultiplier;
            if (this.field_5442 <= 0.0f) {
                this.stopHeld();
            }
        }
        ++this.timeAlive;
        ++this.overallTimeAlive;
    }

    protected void handleChainHolding() {
        if (this.chainedHolding || this.field_5441 == 0.0f) {
            return;
        }
        switch (this.phase) {
            case ATTACK: {
                if (this.timeAlive != (int)(this.heldSoundContainer.holdDelay() * 20.0f)) break;
                this.queueHoldPhase(false);
                this.chainedHolding = true;
                break;
            }
            case HOLD: {
                if (!((float)this.timeAlive * this.field_5441 >= (float)((int)((this.heldSoundContainer.holdDuration() + this.heldSoundContainer.chainedHoldDelay()) * 20.0f)))) break;
                this.queueHoldPhase(this.heldSoundContainer.decay() > 0.0f);
                this.chainedHolding = true;
                this.removeSoundInstance();
            }
        }
    }

    protected void queueHoldPhase(boolean decreaseVol) {
        if (this.field_5442 <= 0.2f) {
            return;
        }
        new HeldNoteSoundInstance(this.heldSoundContainer, HeldNoteSound.Phase.HOLD, this.notePitch, this.field_5442 - (decreaseVol ? this.heldSoundContainer.decay() : 0.0f), this.initiator.orElse(null), this.soundOrigin.orElse(null), this.initiatorId, this.instrumentId, this.overallTimeAlive, this.released).queueAndAddInstance();
    }

    protected void toInitiatorPos() {
        if (this.field_18936) {
            return;
        }
        if (this.soundOrigin.isPresent() || this.initiator.isEmpty()) {
            return;
        }
        if (this.released) {
            return;
        }
        this.field_5439 = this.initiator.get().method_23317();
        this.field_5450 = this.initiator.get().method_23318();
        this.field_5449 = this.initiator.get().method_23321();
    }

    public float method_4781() {
        return this.field_5442;
    }

    public float method_4782() {
        return this.field_5441;
    }

    public void stopHeld() {
        this.method_24876();
        this.removeSoundInstance();
    }
}

