/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.InstrumentChannelType;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.event.NoteSoundPlayedEvent;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.sound.NoteSoundReuslt;
import com.cstav.genshinstrument.sound.registrar.NoteSoundRegistrar;
import com.cstav.genshinstrument.util.LabelUtil;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;

public class NoteSound {
    public static final class_3419 INSTRUMENT_SOUND_SOURCE = class_3419.field_15247;
    public static final double STEREO_RANGE = 5.5;
    public static final double LOCAL_RANGE = 5.5;
    public static final int MIN_PITCH = -LabelUtil.NOTES_PER_SCALE;
    public static final int MAX_PITCH = LabelUtil.NOTES_PER_SCALE;
    public final int index;
    public final class_2960 baseSoundLocation;
    public class_3414 mono;
    public class_3414 stereo;

    @ApiStatus.Internal
    public NoteSound(int index, class_2960 baseSoundLocation) {
        this.index = index;
        this.baseSoundLocation = baseSoundLocation;
    }

    public class_3414 getMono() {
        return this.mono;
    }

    public boolean hasStereo() {
        return this.stereo != null;
    }

    public class_3414 getStereo() {
        return this.stereo;
    }

    public NoteSound[] getSoundsArr() {
        return NoteSoundRegistrar.getSounds(this.baseSoundLocation);
    }

    public NoteSoundReuslt transpose(int amount) {
        int newIndex = amount + this.index;
        NoteSound[] sounds = this.getSoundsArr();
        int delta = newIndex / sounds.length;
        if (delta != 0) {
            if (delta < -1 || delta > 1) {
                return new NoteSoundReuslt(null, delta);
            }
            newIndex += sounds.length * delta;
        }
        return new NoteSoundReuslt(sounds[newIndex], delta);
    }

    @Environment(value=EnvType.CLIENT)
    public class_3414 getByPreference(double playDistSqr) {
        if (!this.hasStereo()) {
            return this.mono;
        }
        InstrumentChannelType preference = (InstrumentChannelType)((Object)ModClientConfigs.CHANNEL_TYPE.get());
        return switch (preference) {
            default -> throw new MatchException(null, null);
            case InstrumentChannelType.MIXED -> {
                if (NoteSound.metInstrumentVolume() && playDistSqr <= class_3532.method_33723((double)5.5)) {
                    yield this.stereo;
                }
                yield this.mono;
            }
            case InstrumentChannelType.STEREO -> this.stereo;
            case InstrumentChannelType.MONO -> this.mono;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public class_3414 getByPreference() {
        return this.getByPreference(0.0);
    }

    private static boolean metInstrumentVolume() {
        return class_310.method_1551().field_1690.method_1630(INSTRUMENT_SOUND_SOURCE) == 1.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public void playFromServer(Optional<Integer> initiatorID, NoteSoundMetadata meta) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        class_638 level = minecraft.field_1687;
        class_1297 initiator = initiatorID.map(arg_0 -> ((class_1937)level).method_8469(arg_0)).orElse(null);
        double playDistSqr = meta.pos().method_46558().method_1025(player.method_19538());
        ClientUtil.stopMusicIfClose(playDistSqr);
        ((NoteSoundPlayedEvent)NoteSoundPlayedEvent.EVENT.invoker()).triggered(initiator == null ? new NoteSoundPlayedEvent.NoteSoundPlayedEventArgs((class_1937)level, this, meta) : new NoteSoundPlayedEvent.NoteSoundPlayedEventArgs(initiator, this, meta));
        if (player.equals((Object)initiator)) {
            return;
        }
        float mcPitch = NoteSound.getPitchByNoteOffset(NoteSound.clampPitch(meta.pitch()));
        this.playLocally(mcPitch, (float)meta.volume() / 100.0f, meta.pos(), playDistSqr);
    }

    @Environment(value=EnvType.CLIENT)
    public void playLocally(float pitch, float volume, class_2338 pos, double playDistSqr) {
        class_310 minecraft = class_310.method_1551();
        class_3414 sound = this.getByPreference(playDistSqr);
        if (playDistSqr > class_3532.method_33723((double)5.5)) {
            minecraft.field_1687.method_45446(pos, sound, INSTRUMENT_SOUND_SOURCE, volume, pitch, false);
        } else {
            class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(sound.method_14833(), INSTRUMENT_SOUND_SOURCE, volume, pitch, class_1113.method_43221(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void playLocally(float pitch, float volume, class_2338 pos) {
        this.playLocally(pitch, volume, pos, class_310.method_1551().field_1724.method_19538().method_1025(pos.method_46558()));
    }

    @Environment(value=EnvType.CLIENT)
    public void playLocally(int pitch, float volume, class_2338 pos, double playDistSqr) {
        this.playLocally(NoteSound.getPitchByNoteOffset(NoteSound.clampPitch(pitch)), volume, pos, playDistSqr);
    }

    @Environment(value=EnvType.CLIENT)
    public void playLocally(int pitch, float volume, class_2338 pos) {
        this.playLocally(NoteSound.getPitchByNoteOffset(NoteSound.clampPitch(pitch)), volume, pos, class_310.method_1551().field_1724.method_19538().method_1025(pos.method_46558()));
    }

    public static int clampPitch(int pitch) {
        return class_3532.method_15340((int)pitch, (int)MIN_PITCH, (int)MAX_PITCH);
    }

    public static float getPitchByNoteOffset(int pitch) {
        return (float)Math.pow(2.0, (double)pitch / (double)LabelUtil.NOTES_PER_SCALE);
    }

    public void writeToNetwork(class_2540 buf) {
        buf.method_10812(this.baseSoundLocation);
        buf.method_53002(this.index);
    }

    public static NoteSound readFromNetwork(class_2540 buf) {
        return NoteSoundRegistrar.getSounds(buf.method_10810())[buf.readInt()];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NoteSound)) {
            return false;
        }
        NoteSound other = (NoteSound)obj;
        return this.baseSoundLocation.equals((Object)other.baseSoundLocation) && this.index == other.index;
    }
}

