/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.item.InstrumentItem;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public abstract class ServerEvents {
    private static final int MAX_BLOCK_INSTRUMENT_DIST = 6;

    public static void register() {
        ServerTickEvents.START_WORLD_TICK.register(ServerEvents::onServerTick);
        ServerPlayConnectionEvents.DISCONNECT.register(ServerEvents::onPlayerLeave);
    }

    private static void onServerTick(class_1937 level) {
        level.method_18456().forEach(player -> {
            if (ServerEvents.shouldAbruptlyClose(player)) {
                InstrumentPacketUtil.setInstrumentClosed((class_3222)player);
            }
        });
    }

    private static void onPlayerLeave(class_3244 handler, MinecraftServer server) {
        InstrumentPacketUtil.setInstrumentClosed(handler.field_14140);
    }

    private static boolean shouldAbruptlyClose(class_1657 player) {
        if (!InstrumentEntityData.isOpen(player)) {
            return false;
        }
        if (InstrumentEntityData.isItem(player)) {
            class_1268 hand = InstrumentEntityData.getHand(player);
            if (hand == null) {
                return true;
            }
            class_1799 handItem = player.method_5998(hand);
            return !(handItem.method_7909() instanceof InstrumentItem);
        }
        return !InstrumentEntityData.getBlockPos(player).method_19769((class_2374)player.method_19538(), 6.0);
    }

    public static void notifyOpenStateToPlayer(class_1657 player, class_3222 target) {
        if (!InstrumentEntityData.isOpen(player)) {
            return;
        }
        NotifyInstrumentOpenPacket packet = InstrumentEntityData.isItem(player) ? new NotifyInstrumentOpenPacket(player.method_5667(), InstrumentEntityData.getHand(player)) : new NotifyInstrumentOpenPacket(player.method_5667(), InstrumentEntityData.getBlockPos(player));
        GIPacketHandler.sendToClient(packet, target);
    }
}

