/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.GInstrumentMod;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import java.awt.Color;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractInstrumentOptionsScreen
extends class_437 {
    public final Optional<InstrumentScreen> instrumentScreen;
    public final class_437 lastScreen;
    public final boolean isOverlay;
    protected final HashMap<String, Runnable> appliedOptions = new HashMap();

    public AbstractInstrumentOptionsScreen(class_2561 pTitle, InstrumentScreen instrumentScreen, class_437 lastScreen) {
        super(pTitle);
        this.instrumentScreen = Optional.ofNullable(instrumentScreen);
        this.lastScreen = lastScreen;
        this.isOverlay = instrumentScreen != null;
    }

    public AbstractInstrumentOptionsScreen(class_2561 pTitle, Optional<InstrumentScreen> instrumentScreen, class_437 lastScreen) {
        this(pTitle, (InstrumentScreen)instrumentScreen.orElse(null), lastScreen);
    }

    public AbstractInstrumentOptionsScreen(class_2561 pTitle, InstrumentScreen instrumentScreen) {
        this(pTitle, instrumentScreen, null);
    }

    public AbstractInstrumentOptionsScreen(class_2561 pTitle, Optional<InstrumentScreen> instrumentScreen) {
        this(pTitle, instrumentScreen, null);
    }

    public AbstractInstrumentOptionsScreen(class_2561 pTitle, class_437 lastScreen) {
        this(pTitle, Optional.empty(), lastScreen);
    }

    public int getSmallButtonWidth() {
        return 190;
    }

    public int getBigButtonWidth() {
        return (this.getSmallButtonWidth() + 4) * 2;
    }

    public int getButtonHeight() {
        return 20;
    }

    public void method_25394(class_332 gui, int pMouseX, int pMouseY, float pPartialTick) {
        this.instrumentScreen.ifPresent(screen -> {
            screen.method_25394(gui, Integer.MAX_VALUE, Integer.MAX_VALUE, pPartialTick);
            gui.method_51448().method_46416(0.0f, 0.0f, 1.0f);
        });
        super.method_25394(gui, pMouseX, pMouseY, pPartialTick);
        gui.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, Color.WHITE.getRGB());
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        this.instrumentScreen.ifPresent(screen -> {
            if (screen.isKeyConsumed(pKeyCode, pScanCode)) {
                screen.method_25404(pKeyCode, pScanCode, pModifiers);
            }
        });
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        this.instrumentScreen.ifPresent(screen -> {
            if (screen.isKeyConsumed(pKeyCode, pScanCode)) {
                screen.method_16803(pKeyCode, pScanCode, pModifiers);
            }
        });
        return super.method_16803(pKeyCode, pScanCode, pModifiers);
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        this.instrumentScreen.ifPresent(screen -> screen.method_25410(minecraft, width, height));
        super.method_25410(minecraft, width, height);
    }

    public boolean method_25421() {
        return !this.isOverlay;
    }

    public void method_25419() {
        this.saveOptions();
        if (this.lastScreen != null) {
            this.field_22787.method_1507(this.lastScreen);
        } else {
            super.method_25419();
        }
    }

    protected void queueToSave(String optionKey, Runnable saveRunnable) {
        String modId = this.modId();
        if (modId != null) {
            optionKey = modId + ":" + (String)optionKey;
        }
        if (this.appliedOptions.containsKey(optionKey)) {
            this.appliedOptions.replace((String)optionKey, saveRunnable);
        } else {
            this.appliedOptions.put((String)optionKey, saveRunnable);
        }
    }

    public void saveOptions() {
        if (this.appliedOptions.isEmpty()) {
            return;
        }
        this.appliedOptions.values().forEach(Runnable::run);
        ModClientConfigs.CONFIGS.save();
        GInstrumentMod.LOGGER.info("Successfully saved " + this.appliedOptions.size() + " option(s) for " + this.field_22785.getString());
    }

    public String modId() {
        return this.instrumentScreen.map(InstrumentScreen::getModId).orElse(null);
    }
}

